#!/bin/bash
#SBATCH --partition=general-compute
#SBATCH --ntasks=8
#SBATCH --cpus-per-task=8
#SBATCH --mem=20000
#SBATCH --constraint=CPU-L5520
#SBATCH --ntasks-per-node=1
#SBATCH --exclusive
#SBATCH --job-name="esf_example"
#SBATCH --output=esf_example.out

# Variables, Paths and Modules
echo "SLURM_JOBID="$SLURM_JOBID
echo "SLURM_JOB_NODELIST"=$SLURM_JOB_NODELIST
echo "SLURM_NNODES"=$SLURM_NNODES
echo "SLURMTMPDIR="$SLURMTMPDIR

cd $SLURM_SUBMIT_DIR
echo "submit directory = "$SLURM_SUBMIT_DIR

module load intel
module load intel-mpi
ulimit -s unlimited

# Set your input file here
INPUT=GutV2

# echo "Launch helloworld with srun"
date
export I_MPI_PMI_LIBRARY=/usr/lib64/libpmi.so
export OMP_NUM_THREADS=8
export KMP_AFFINITY=verbose,granularity=thread,scatter,norespect
export KMP_DETERMINISTIC_REDUCTION=yes
./preproc $INPUT'.fasta'
srun ./ESForest -f $INPUT'_Clean.frq' $INPUT'_Clean.fasta'
perl invmap.pl $INPUT'_Clean.Clusters' $INPUT'_Clean.map' $INPUT'.org.Clusters' 
date
echo "All Done!"
