/***********************************************************************
ESPRIT-Forest: Parallel Clustering of Massive Amplicon Sequence Data in Subquadratic Time 
by: Yunpeng Cai, Yijun Sun, Wei Zheng, Jin Yao and Yujie Yang  (C) 2016
Please kindly cite [Y.Cai et.al PLOS Comp. Biol. 2016]

THE LICENSED WORK IS PROVIDED UNDER THE TERMS OF THE ADAPTIVE PUBLIC LICENSE ("LICENSE") AS FIRST COMPLETED BY: _Yunpeng Cai, Yijun Sun, Wei Zheng, Jin Yao, Yujie Yang_ [Insert the name of the Initial Contributor here]. ANY USE, PUBLIC DISPLAY, PUBLIC PERFORMANCE, REPRODUCTION OR DISTRIBUTION OF, OR PREPARATION OF DERIVATIVE WORKS BASED ON, THE LICENSED WORK CONSTITUTES RECIPIENT'S ACCEPTANCE OF THIS LICENSE AND ITS TERMS, WHETHER OR NOT SUCH RECIPIENT READS THE TERMS OF THE LICENSE. "LICENSED WORK" AND "RECIPIENT" ARE DEFINED IN THE LICENSE. A COPY OF THE LICENSE IS LOCATED IN THE TEXT FILE ENTITLED "LICENSE.TXT" ACCOMPANYING THE CONTENTS OF THIS FILE. IF A COPY OF THE LICENSE DOES NOT ACCOMPANY THIS FILE, A COPY OF THE LICENSE MAY ALSO BE OBTAINED AT THE FOLLOWING WEB SITE: http://www.acsu.buffalo.edu/~yijunsun/lab/ESPRIT-Forest.html [Insert Initial Contributor's Designated Web Site here]

Software distributed under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the specific language governing rights and limitations under the License.
*/


/*
    HashTable that caches the histroy of Needleman Distance Computing
*/

#include "distcache.h"
#include <iostream>

void DistCache::Store(int x, int y, float dist)
{
	int pos=(x % Size)*Size+(y % Size);
	//int pos=(x+y) % Size;
	if (x > y)
	{
		int swp=x;
		x=y;
		y=swp;
	}
	cells[pos].x=x;
	cells[pos].y=y;
	cells[pos].dist=dist;
}
		
bool DistCache::Get(int x, int y,float &dist)
{
	if (x==y) return false;
	//int pos=(x+y) % Size;
	int pos=(x % Size)*Size+(y % Size);
	
	if (x > y)
	{
		int swp=x;
		x=y;
		y=swp;
	}
	if (cells[pos].x!=x || cells[pos].y!=y) return false;
	dist=cells[pos].dist;
	return true;
}
