#ifndef Needle_H
#define Needle_H
#include "ProbModel.h"

/*Needleman Wunsch Algorithm*/
enum DIRS{DIR_DIAG=0,DIR_LEFT,DIR_UP};
#define NumDIRS 3

class Needle{
	protected:
	float gap_open;
	float gap_len; 
	int Diag;
	
	int* StrToCode(char* str); 
	float Score(int row, int col); 
	float Score(ProbChar &p1, ProbChar &p2);
	float Score(int row, ProbChar &p2);


	void GetAlignments(DIRS *pr, DIRS defVal, char *sA, char *sB, char *alA,char *alB);
	void GetAlignments(DIRS *pr, DIRS defVal, ProbString &sA, ProbString &sB, ProbString &alA,ProbString &alB);
	void GetAlignments(DIRS *pr, DIRS defVal, char *sA, ProbString &sB, char *alA,ProbString &alB);
	void GetAlignments(DIRS *pr, DIRS defVal, ProbString &sA, ProbString &sB, ProbString &alA,ProbString &alB, int *posA, int *posB);

	
	float CalculateMatrix_Diag(int* source, int* dest, int slen, int dlen, int diag_dn, int diag_up, DIRS *pr, DIRS &defVal);
	float CalculateMatrix_Diag(ProbString &source, ProbString &dest, int slen, int dlen, int diag_dn, int diag_up, DIRS *pr, DIRS &defVal);
	float CalculateMatrix_Diag(int *source, ProbString &dest, int slen, int dlen, int diag_dn, int diag_up, DIRS *pr, DIRS &defVal);
	float CalculateMatrix_NoDgap(int *source, ProbString &dest, int slen, int dlen, DIRS *pr, DIRS &defVal);

	public:
		Needle(float go, float gl, int dg=0)
		{
			gap_open=-1*go;
			gap_len=-1*gl;
			Diag=dg;
		};
		~Needle(){};
		void Align(char *seq1,char *seq2,char *al1, char *al2, float diag_fact); 
		void Align(ProbString &str1,ProbString &str2,ProbString &al1, ProbString &al2, float diag_fact);
		void Align(char *seq1,ProbString &str2,char *al1, ProbString &al2, float diag_fact);		
		void Align(ProbString &str1,ProbString &str2,ProbString &al1, ProbString &al2, int* pos1, int *pos2, float diag_fact);
		void AlignToTemp(char *seq1,ProbString &str2,char *al1);		

};

#endif
