#ifndef GLOBAL_H
#define GLOBAL_H
#include <stdio.h>
#include "kmer.h"
#include "needle.h"
#include "distcache.h"

#define DS_Ave 0
#define DS_Max 1

class Global{
public:
	static float gap_o;
	static float gap_e;
	static int Needle_Diag;
	static int Kmer_Len;
	static float *krate;
	static float *nbound;
	static int num_krate;
	static float krate_step;
	static float DiagRate;
	static float ErrorRate;

	static Kmer *kmer;
	static Needle *needle;
#pragma omp threadprivate(kmer,needle)
	
	static DistCache* cache;
	
	static bool ShowAlign;
	static char *ProbSeqOut;
	
	static float level_min;
	static float level_inc;
	static float level_max;
	static float level_step;

	static void SetParam(float g_o,	float g_e, int K_Len, int K_Br);
	static void Init(int SeqNum);
	static void Finish();
	static void LoadKList(int num_k, float k_step, float *klist);
	static void LoadKList(char *filename);
};

float KdistBound(float dist);
float Kdist2Ndist(float kdist);
float calcDistance(char *seq1, char *seq2);

#define Max_StrLen 65535

float KmerDist(int uid1, int uid2);
float NeedleDist(int uid1, int uid2, float level);


#endif
