function Weight = IMRelief_2(patterns, targets, Para4IRelief)

%IM_Relief_2: Relief using EM algorithm for both binary and multiclass
%problems. NOTE: IM_Relief_2 is different from IM_Relief_1 in the margin difinition.
%IM_Relief_2 finds the most confused patterns from other classes.
%When used for binary problem, IM_RELIEF_1 is eqivalent to IM_RELIEF_2
%--------------------------------------------------------------------------
%INPUT:
%     patterns:  training data: Each column is an observation
%     targets:   class label = {1,2,...C}
%     T: # of iteration
%   distance: 'Euclidean' or 'Block'
%OUTPUT:
%    Weight: weight of features
%--------------------------------------------------------------------------
%University of Florida, by Yijun Sun
%Octber 15/17/25, 2005
%--------------------------------------------------------------------------
%Lesson One:
%          If you believe in yourself, conduct a large-scale experiment; do
%          not be frastrated by single failure. Remember that there does exists a
%          single algorithm that work best for all applications(dataset).
%Lesson two:
%          Be strong with everything.
%Lesson Three:
%          Automatizalize everything. then go....
%==========================================================================
Prob = Para4IRelief.Prob;
switch (Prob)
    case {'yes'}
        T = Para4IRelief.it;
        distance = Para4IRelief.distance;
        kernel = Para4IRelief.kernel;
        sigma = Para4IRelief.sigma;
        Outlier = Para4IRelief.Outlier;

        Uc          = unique(targets);
        if min(Uc)~=1 | max(Uc)~=length(Uc);
            error('Targets should run from 1 to C !')
        end

        N_patterns = length(targets);% # of patterns
        dim = size(patterns,1); % Data dimenionality

        for n=1:length(Uc)
            temp = find(targets==n);
            index{n} =temp;
            N(n) = length(temp);
        end

        History = zeros(dim,T+1);
        History(:,1)= 1/sqrt(dim)*ones(dim,1);
        % -------------------------------------------------------------------------

        Difference =1;
        t=0;
        Theta =[];
        while Difference>0.02 & t<=T

            t=t+1;
            NM = zeros(dim,N_patterns);
            NH = zeros(dim,N_patterns);

            for i = 1:N_patterns,
                Prob_dif = 0;
                Prob_same = 0;

                index_SameClass = index{targets(i)};
                index_DiffClass =[];
                for c = 1:length(Uc)
                    if c~=targets(i)
                        temp =index{c};
                        index_DiffClass = [index_DiffClass;temp(:)];
                    end
                end

                switch lower(distance)
                    case{'euclidean'}
                        Temp_SameClass            = (patterns(:,index_SameClass) - patterns(:,i)*ones(1,length(index_SameClass))).^2;
                        Temp_DiffClass            = (patterns(:,index_DiffClass) - patterns(:,i)*ones(1,length(index_DiffClass))).^2;
                    case{'block'}
                        Temp_SameClass            = abs(patterns(:,index_SameClass) - patterns(:,i)*ones(1,length(index_SameClass)));
                        Temp_DiffClass            = abs(patterns(:,index_DiffClass) - patterns(:,i)*ones(1,length(index_DiffClass)));
                end

                if t==1
                    dist_SameClass    = sum(Temp_SameClass,1)/sqrt(dim);
                    dist_DiffClass    = sum(Temp_DiffClass,1)/sqrt(dim);
                else
                    dist_SameClass    = (Weight(:)')*Temp_SameClass;
                    dist_DiffClass    = (Weight(:)')*Temp_DiffClass;
                end
                temp_index_SameClass = find(dist_SameClass==0);
                temp_index_DiffClass = find(dist_DiffClass==0);

                switch lower(kernel)
                    case{'exp'}
                        prob_SameClass = exp(-dist_SameClass/sigma);prob_SameClass(temp_index_SameClass) = 0;
                        %prob_S = prob_SameClass/sum(prob_SameClass);
                        if sum(prob_SameClass)~=0;prob_S = prob_SameClass/sum(prob_SameClass);else;prob_S=0;end
                        prob_DiffClass = exp(-dist_DiffClass/sigma);prob_DiffClass(temp_index_DiffClass) = 0;
                        prob_D = prob_DiffClass/sum(prob_DiffClass);

                    case {'1/d'}
                        prob_SameClass = (1./dist_SameClass).^(1/0.5);prob_SameClass(temp_index_SameClass) = 0;
                        %prob_S = prob_SameClass/sum(prob_SameClass);
                        if sum(prob_SameClass)~=0;prob_S = prob_SameClass/sum(prob_SameClass);else;prob_S=0;end
                        prob_DiffClass = (1./dist_DiffClass).^(1/0.5);prob_DiffClass(temp_index_DiffClass) = 0;
                        prob_D = prob_DiffClass/sum(prob_DiffClass);
                end

                if N(targets(i))>1
                    Pro_NoT_Outlier(i) = (sum(prob_SameClass)/length(index_SameClass))/(sum(prob_SameClass)/length(index_SameClass)+sum(prob_DiffClass)/length(index_DiffClass));
                    if Outlier ==1
                        NH(:,i) = Temp_SameClass*prob_S(:)*Pro_NoT_Outlier(i);
                        NM(:,i) = Temp_DiffClass*prob_D(:)*Pro_NoT_Outlier(i);
                    else
                        NH(:,i) = Temp_SameClass*prob_S(:);
                        NM(:,i) = Temp_DiffClass*prob_D(:);
                    end
                else
                    NM(:,i) = Temp_DiffClass*prob_D(:);
                end

            end

            C = sum(NM-NH,2);
            in = find(C<0); C(in)=0;
            Weight = C/norm(C);

            Difference = norm(Weight-History(:,t));
            Theta(t) = Difference;
            History(:,t+1) = Weight;
        end

        figure(10);plot(Theta,'-o')
        title('Theta');xlabel('Number of Iteration');ylabel('Difference');drawnow
        %
        %     figure(11);plot(History(:,2),'o-r');hold on;
        %     plot(History(:,t),'*-b');hold off;
        %     title('Updating of Weights');
        %     legend('1','end')
        %    keyboard
        %

    case {'no'}
        %search for K nearest neighbors
        T = Para4IRelief.it; %maximum iteration
        KN = Para4IRelief.KN; % # of nearest neighbor to search
        distance = Para4IRelief.distance;
        
        Uc          = unique(targets);
        if min(Uc)~=1 | max(Uc)~=length(Uc);
            error('Targets should run from 1 to C !')
        end

        N_patterns = length(targets);% # of patterns
        dim = size(patterns,1); % Data dimenionality

        for n=1:length(Uc)
            temp = find(targets==n);
            index{n} =temp;
            N(n) = length(temp);
        end

        History = zeros(dim,T+1);
        History(:,1)= 1/sqrt(dim)*ones(dim,1);
        Pi = zeros(dim,1);
        % -------------------------------------------------------------------------

        Difference =1;
        t=0;
        Theta =[];
        while Difference>0.02 & t<=T

            t=t+1;
            NM = zeros(dim,N_patterns);
            NH = zeros(dim,N_patterns);

            for i = 1:N_patterns,
                Prob_dif = 0;
                Prob_same = 0;

                index_SameClass = index{targets(i)};
                index_DiffClass =[];
                for c = 1:length(Uc)
                    if c~=targets(i)
                        temp =index{c};
                        index_DiffClass = [index_DiffClass;temp(:)];
                    end
                end

                switch lower(distance)
                    case{'euclidean'}
                        Temp_SameClass            = (patterns(:,index_SameClass) - patterns(:,i)*ones(1,length(index_SameClass))).^2;
                        Temp_DiffClass            = (patterns(:,index_DiffClass) - patterns(:,i)*ones(1,length(index_DiffClass))).^2;
                    case{'block'}
                        Temp_SameClass            = abs(patterns(:,index_SameClass) - patterns(:,i)*ones(1,length(index_SameClass)));
                        Temp_DiffClass            = abs(patterns(:,index_DiffClass) - patterns(:,i)*ones(1,length(index_DiffClass)));
                end

                if t==1
                    dist_SameClass    = sum(Temp_SameClass,1)/sqrt(dim);
                    dist_DiffClass    = sum(Temp_DiffClass,1)/sqrt(dim);
                else
                    dist_SameClass    = (Weight(:)')*Temp_SameClass;
                    dist_DiffClass    = (Weight(:)')*Temp_DiffClass;
                end

                [dum, indices_SameClass]    = sort(dist_SameClass);
                [dum, indices_DiffClass]    = sort(dist_SameClass);
                
                if N(targets(i))>1
                    NH(:,i) =  sum(Temp_SameClass(:,indices_SameClass(2:min(KN+1,length(indices_SameClass)))),2);
                    NM(:,i) =  sum(Temp_DiffClass(:,indices_DiffClass(1:min(KN,length(indices_DiffClass)))),2);
                end

                C = sum(NM-NH,2);
                Pi = Pi+C;
                in = find(Pi<0); Pi(in)=0;
                Weight = Pi/norm(Pi);

                Difference = norm(Weight-History(:,t));
                Theta(t) = Difference;
                History(:,t+1) = Weight;
            end

            figure(10);plot(Theta,'-o')
            title('Theta');xlabel('Number of Iteration');ylabel('Difference');drawnow
            figure;plot(Weight,'-o')
        end
        %
end






