function Weight = Online_IMRelief_1_2(patterns, targets, Para4IRelief,reference,plotfig)

%Online_IM_Relief_1_2: Online version of Relief using EM algorithm for both binary and multiclass problems..Here
%we use the margin difinition that is also used in Relief-F
%Online_IMRelief_1(refer to margin definition)_1(refer to online version)                
%--------------------------------------------------------------------------
%INPUT:
%     patterns:  training data: Each column is an observation
%     targets:   class label = {1,2,...C}
%     T: # of iteration
%   distance: 'Euclidean' or 'Block'
%OUTPUT:
%    Weight: weight of features
%--------------------------------------------------------------------------
%University of Florida, by Yijun Sun
%Octber 15/17/25, Nov 3, 2005
%--------------------------------------------------------------------------
%==========================================================================
N_EachBlock= 1;
C= 0.05;
T =round(3*length(targets));%maximum iteration
distance = Para4IRelief.distance;
kernel = Para4IRelief.kernel;
sigma = Para4IRelief.sigma;
%----------------------------------
Uc          = unique(targets);
if min(Uc)==-1
    targets = targets/2+1.5; %transform targets into {1,2}
end

N_patterns = length(targets);% # of patterns
dim = size(patterns,1); % Data dimenionality

for n=1:length(Uc)
    temp = find(targets==n); 
    index{n} =temp;
    N(n) = length(temp);
end

%initilization
History = zeros(dim,T+1);
History(:,1)= 1/sqrt(dim)*ones(dim,1);
Weight = 1/sqrt(dim)*ones(dim,1);
Theta =[];Theta(1)=sqrt(2);
Rand_Index = randperm(N_patterns);

% -------------------------------------------------------------------------
for t=1:T
    %disp(['>>>Processing ' num2str(t) ' / ' num2str(T)])
    if rem(t,N_patterns)==0,m=N_patterns;else;m = rem(t,N_patterns);end
    Select_Index = Rand_Index(m);%rem(t,N_patterns));%(1:N_EachBlock);%
    Select_Patterns = patterns(:,Select_Index);
    Select_Targets = targets(Select_Index);
    
    NM = zeros(dim,N_EachBlock); 
    NH = zeros(dim,N_EachBlock); 
    Pro_NoT_Outlier=[];
    
    for i = 1:N_EachBlock,
        Prob_dif = 0;
        Prob_same = 0;
        
        for c = 1:length(Uc)
            switch lower(distance)
                case {'euclidean'}
                    Temp            = (patterns(:,index{c}) - Select_Patterns(:,i)*ones(1,N(c))).^2;
                case {'block'}
                    Temp            = abs(patterns(:,index{c}) - Select_Patterns(:,i)*ones(1,N(c)));
            end
            
            dist    = (Weight(:)')*Temp;
            temp_index = find(dist==0);
            
            prob = exp(-dist/sigma);prob(temp_index) = 0; 
            if sum(prob)~=0;prob_1 = prob/sum(prob);else;prob_1=0;end
            
            if Select_Targets(i)==c; 
                NH(:,i) = Temp*prob_1(:);
                Prob_same = sum(prob)/N(c);
            end
            if Select_Targets(i)~=c; 
                NM(:,i) = NM(:,i)+ Temp*prob_1(:);%*Prioi(c)/(1-Prioi(targets(i)));
                Prob_dif = Prob_dif+sum(prob)/N(c);
            end 
        end
        
        if N(Select_Targets(i))>1
            Pro_NoT_Outlier(i) = Prob_same/(Prob_same+Prob_dif);
            NH(:,i) = NH(:,i)*Pro_NoT_Outlier(i);
            NM(:,i) = NM(:,i)*Pro_NoT_Outlier(i);
        else
            NM(:,i) = NM(:,i); %for the case where there is only one sample in Class c.
        end
    end %end of process of each block
    
    %compute intermediate results
    NM = NM/(length(Uc)-1);
    Pi = sum(NM-NH,2); 
    if t==1
        Intermediate_result = Pi;
        in = find(Pi<0); Pi(in)=0;
        Weight = Pi/norm(Pi);
        epsilon(t) = 1;
        epsilon_hat(t)=epsilon(t)/sum(epsilon(1:t));
        LearningRate(t) = epsilon(t)/(1+epsilon(t));
    else
        Theta(t) =norm(History(:,t)-History(:,t-1));
        epsilon(t) = epsilon_hat(t-1)*(1+C*log((sqrt(2)+Theta(t))./(sqrt(2)-Theta(t))));
        LearningRate(t) = epsilon(t)/(1+epsilon(t));
        Intermediate_result = Intermediate_result+LearningRate(t)*(Pi-Intermediate_result);

        epsilon_hat(t)=epsilon(t);
        epsilon_hat =epsilon_hat/sum(epsilon_hat(1:t));
        
        %compute weight
        Nu = Intermediate_result;
        in = find(Nu<0); Nu(in)=0;
        Weight = Nu/norm(Nu);
    end
    History(:,t+1) = Weight;
end

if plotfig==1
    figure(1);plot(Weight/max(Weight),':*');%title('weight');
    hold on;plot(reference(:,1)/max(reference(:,1)),'r-o');
    hold on;plot(reference(:,2)/max(reference(:,2)),'k-.s');
    legend('Online','I-Relief-1','Relief',0)
    xlabel('Number of Features')
    ylabel('Scores');axis tight
    boldify2;grid on
    
    figure(2);
    subplot(2,2,1)
    plot(LearningRate,'-');grid on;title('LR')
    subplot(2,2,2)
    plot(epsilon_hat,'-');grid on;title('epsilon-hat')
    subplot(2,2,3)
    plot(epsilon,'-');grid on;title('epsilon')
    subplot(2,2,4)
    plot(Theta(2:end),'-');grid on;title('Difference')
    
    reference(:,1) = reference(:,1)/norm(reference(:,1));
    Progress = sqrt(sum((History - reference(:,1)*ones(1,size(History,2))).^2,1));
    figure(3);
    plot(Progress(2:end),'-');%title('Progress');
    xlabel('Number of Iterations')
    ylabel('Difference');
    title('Difference from target weight');
    axis tight
    grid on
    boldify2
    
    figure(4)
    plot(LearningRate,'-');
    xlabel('Number of Iterations')
    ylabel('Learning Rates');
    grid on;title('Learning Rates(\eta)')
    boldify2
    
    figure(5)
    plot(epsilon_hat,'-');
    xlabel('Number of Iterations')
    grid on;title('Weights (\xi)')
    boldify2
    
    
end

keyboard
return

