function Main_Online_IRelief(dataset,No_RandomFeature,Percentage)

%FUNCTION MAIN: main function for Adaptive Relief
%========================================================
%Yijun Sun, University of Florida
%Nov 3, 2005
%========================================================
close all
AddSomePath; %add some pathes
%---------------------------------------------------------
FinalResult_Weight = zeros(20,4);
Stat_IRelief = zeros(21,2,20);
Stat_Relief = zeros(21,2,20);
Stat_Simba = zeros(21,2,20);
ConvergenceResult=[];

for No=1:20
    %load data
    eval(['load ' dataset '_train_data_' num2str(No) '.asc'])
    eval(['load ' dataset '_train_labels_' num2str(No) '.asc'])
    eval(['load ' dataset '_test_data_' num2str(No) '.asc'])
    eval(['load ' dataset '_test_labels_' num2str(No) '.asc'])
    
    eval(['patterns =' dataset '_train_data_' num2str(No) ';']);
    patterns = patterns'; % Each column is a pattern.
    eval(['targets = ' dataset '_train_labels_' num2str(No) ';']);
    eval(['test_patterns =' dataset '_test_data_' num2str(No) ';']);
    test_patterns = test_patterns';
    eval(['test_targets =' dataset '_test_labels_' num2str(No) ';']);
    
    %clear all data
    eval(['clear ' dataset '_train_data_' num2str(No) ';'])
    eval(['clear ' dataset '_train_labels_' num2str(No) ';']);
    eval(['clear ' dataset '_test_data_' num2str(No) ';']);
    eval(['clear ' dataset '_test_labels_' num2str(No) ';']);
    %-----------------------------------------------------------
    N = length(targets);% Number of patterns
    
    patterns = [patterns; randn(No_RandomFeature,N)]; %Add some irrelevant features
    test_patterns = [test_patterns; randn(No_RandomFeature,size(test_patterns,2))]; % Add some irrelevant features
    dim = size(patterns,1); % Data dimenionality
    
    %---------------------------------------------------------------
    %Preprocess the data: 'unif' tranform each feature into [0, 1]
    [patterns, test_patterns] = preprocessing(patterns, test_patterns,'unif');
    %---------------------------------------------------------------
%     patterns = [patterns,test_patterns];
%     targets = [targets;test_targets];
% 
%     patterns = patterns(:,1:1000);
%     targets = targets(1:1000);

    %Add label noise
    index0 = find(targets==-1);
    index1 = find(targets==1);
    
    temp = randperm(length(index0));
    Num2change = round(length(index0)*Percentage/100);
    targets(index0(temp(1:Num2change))) = 1;
    
    temp = randperm(length(index1));
    Num2change = round(length(index1)*Percentage/100);
    targets(index1(temp(1:Num2change))) = -1;
    %---------------------------------------------------------------------
    
    %---------------------------------------------------------------------
    %Parameter for Iterative Relief/Relief
    it = 10;
    distance ='euclidean'; %'block';%
    kernel = 'exp';
    Para4IRelief.it = it;
    Para4IRelief.distance = distance;
    Para4IRelief.kernel = kernel;
    Para4IRelief.Outlier = 1;
    Para4IRelief.sigma= 0.5;
    %------------------------------------------------------------------
   
    Para4Relief.distance = distance;
    Para4Relief.KN= 10;
    
    %----------------------------------------------------------------------
    %I-M-Relief.
    weights = IMRelief_1(patterns, targets, Para4IRelief);
    weights_relief = Original_Relief(patterns, targets, Para4Relief);
    Reference = [weights(:),weights_relief]; 

    %Weight = Relief_wWeightFeedback(patterns, targets, Para4Relief,Reference);
    [weights, ConvergenceRate]= Online_IMRelief_1_1(patterns, targets, Para4IRelief,Reference);%,1);
    %[weights, ConvergenceRate]= Online_IMRelief_2_1(patterns, targets, Para4IRelief,Reference);%,1);

    ConvergenceResult(:,:,No) = ConvergenceRate;
end
keyboard


return










