function Error =FindSigma_IRelief(patterns,targets,KN,F,Para4IRelief,version); 

%Function FindSigma_IRelief: find sigma for I-Relief
%ten-folding cross-validation
%----------------------------------------------------------------------
%INPUT:
%     patterns: each column is an observation
%     target: {1:C}
%     F: # of folds
%OUTPUT:
%     Error: test error
%----------------------------------------------------------------------
%University of Florida; by Yijun Sun
%OCT 15 2005
%======================================================================
it = Para4IRelief.it;
if F<2
    error('F should greater than 1')
end

Uc          = unique(targets);
if min(Uc)==-1
    targets = targets/2+1.5; %transform targets into {1,2}
end

for n=1:length(Uc)
   temp = find(targets==n); 
   index{n} =temp;
   N(n) = length(temp);
   NumberPatternEach(n) = round(N(n)/F);
end

for f=1:F
    %prepare data
    TrainData=[];TrainTargets=[];
    TestData=[]; TestTargets=[];
    for n = 1:length(Uc)
        temp_index = index{n};
        class_index = temp_index((f-1)*NumberPatternEach(n)+1:min(f*NumberPatternEach(n),N(n)));
        if isempty(class_index);X = randperm(N(n));class_index =temp_index(X(1:NumberPatternEach(n)+1));end 
        
        TestData = [TestData,patterns(:,class_index)];
        TestTargets = [TestTargets,n*ones(1,length(class_index))];
        
        temp_index((f-1)*NumberPatternEach(n)+1:min(f*NumberPatternEach(n),N(n)))=[];
        TrainData = [TrainData,patterns(:,temp_index)];
        TrainTargets = [TrainTargets,n*ones(1,length(temp_index))];
    end
    %Weight = IterativeRelief(TrainData, (TrainTargets-1.5)*2, Para4IRelief);
    if version==1;[Weight, ConvergenceRate]= Online_IMRelief_1_1(patterns, TrainTargets, Para4IRelief,[],it);end
    if version==2;[Weight, ConvergenceRate]= Online_IMRelief_2_1(patterns, TrainTargets, Para4IRelief,[],it);end
    %[Weight, ConvergenceRate]= Online_IMRelief_2_1(patterns, TrainTargets, Para4IRelief,[],it);

    distance = Para4IRelief.distance;
    switch lower(distance)
        case{'euclidean'}
            TrainData = diag(sqrt(Weight))*TrainData; 
            TestData = diag(sqrt(Weight))*TestData;
        case{'block'}
            for m = 1:size(TrainData,2)
                TrainData(:,m) = Weight(:).*TrainData(:,m); 
            end
            for m= 1:size(TestData,2)
                TestData(:,m) = Weight(:).*TestData(:,m);
            end
    end

    result = Nearest_Neighbor(TrainData, TrainTargets, TestData, KN,'knn');
    Test_Error(f) = length(find(result(:)~=TestTargets(:)))/length(result);
end

%Test_Error
Error = mean(Test_Error);


return





















