function [rough_map]=estimate_maps(center_lines,center_locs,center_data, FEs,PEs);

%-----------------------------------------------------
%input= low resolution central k-space data
%--------------------------------------------------
%output=estimated sensitivity maps->rough_map
%---------------------------------------------------
Ro=FEs;
C=PEs;

k=C/2;
kc=center_lines/2; %center_lines/2
w=20; %20
epsilon=2;
k1=center_lines/2;%center_lines/2  (32-8-15) (24-8-11)  (16-8-7)
option=2;

%tukey_window = cosine_taper_window(k,kc,w,epsilon,k1,option);
tukey_window = cosine_taper_window(128,2,10,2,2,2);
WW=tukey_window(k-center_lines:k+center_lines,k-center_lines:k+center_lines);
ww1=tukey_window(k:256,k);


    num_coils=size(center_data,3);
    for(i=1:num_coils)
       k_coil(:,:,i)=zeros(Ro,C);
       k_coil(:,center_locs,i)=center_data(:,:,i);
       k_coil_full(:,:,i)=k_coil(:,:,i).*tukey_window;
       coil_full(:,:,i)=ifft2(ifftshift(k_coil_full(:,:,i)));

     end      

%--------sum of squares image--------------------   
%sum_of_squares=sqrt(sum([abs(coil_full)].^2,3)/3);
sum_of_squares=sqrt(sum([abs(coil_full)].^2,3));

regularization_image=sum_of_squares;
warning off MATLAB:divideByZero;

for i=1:num_coils
    temp=coil_full(:,:,i);
    rough_map(:,:,i)=temp./sum_of_squares;
end


return