# Filter in selected bands, estimate energy within each band, and calculate its rate of change.
# Copyright John Kingston 2020.

# Modified by Christian DiCanio 2020 to work with textgrid files of any name across a directory, to
# permit the script to work only on target segments (not all segments), and to include a number
# of additional intensity measures at several positions around the consonant target. Difference
# values are now included as well.
clearinfo

form Band-pass filter and intensity tracking
	sentence Directory /Linguistics/Triqui/Geminate_corpus_research_Frontiers/Data_sound/tier7/
	positive Labeled_tier_number 7
	sentence Output_file_name output_tier7.txt
 	sentence Segment_file_name: consonants.txt
	
	real left_range_Band1 0
	real right_range_Band1 400
	positive Band1_low_pass 50
	
	real left_range_Band2 800
	real right_range_Band2 1500
	positive Band2_low_pass 50 
	
	real left_range_Band3 1200
	real right_range_Band3 2000
	positive Band3_low_pass 50
	
	real left_range_Band4 2000
	real right_range_Band4 2500
	positive Band4_low_pass 50
	
	real left_range_Band5 3500
	real right_range_Band5 5000
	positive Band5_low_pass 50
		
	real left_range_Band6 5000
	real right_range_Band6 8000
	positive Band6_low_pass 50
	
	real Smooth_proportion 0.10
	positive F0_minimum 100
	positive Offset 0.050
endform

# calculate smoothing values in Hz

for j from 1 to 6
	smooth = round(right_range_Band'j' * 'smooth_proportion')
	printline 'smooth'
	sm_'j' = smooth
endfor

# delete output file if it already exists

filedelete 'output_file_name$'

# make a header for the file
fileappend "'directory$''output_file_name$'" file 'tab$' labelNumber 'tab$' label 'tab$' premin1 'tab$' premax1 'tab$' postmin1 'tab$' postmax1 'tab$' consmin1 'tab$' consmax1 'tab$' bigmin1 'tab$' bigmax1 'tab$' delta_i_bf1 'tab$' delta_i_aft1 'tab$' delta_i1 'tab$' pre_t_min1 'tab$' pre_t_max1 'tab$' post_t_min1 'tab$' post_t_max1 'tab$' cons_t_min1 'tab$' cons_t_max1 'tab$' big_t_min1 'tab$' big_t_max1 'tab$' premin2 'tab$' premax2 'tab$' postmin2 'tab$' postmax2 'tab$' consmin2 'tab$' consmax2 'tab$' bigmin2 'tab$' bigmax2 'tab$' delta_i_bf2 'tab$' delta_i_aft2 'tab$' delta_i2 'tab$' pre_t_min2 'tab$' pre_t_max2 'tab$' post_t_min2 'tab$' post_t_max2 'tab$' cons_t_min2 'tab$' cons_t_max2 'tab$' big_t_min2 'tab$' big_t_max2 'tab$' premin3 'tab$' premax3 'tab$' postmin3 'tab$' postmax3 'tab$' consmin3 'tab$' consmax3 'tab$' bigmin3 'tab$' bigmax3 'tab$' delta_i_bf3 'tab$' delta_i_aft3 'tab$' delta_i3 'tab$' pre_t_min3 'tab$' pre_t_max3 'tab$' post_t_min3 'tab$' post_t_max3 'tab$' cons_t_min3 'tab$' cons_t_max3 'tab$' big_t_min3 'tab$' big_t_max3 'tab$' premin4 'tab$' premax4 'tab$' postmin4 'tab$' postmax4 'tab$' consmin4 'tab$' consmax4 'tab$' bigmin4 'tab$' bigmax4 'tab$' delta_i_bf4 'tab$' delta_i_aft4 'tab$' delta_i4 'tab$' pre_t_min4 'tab$' pre_t_max4 'tab$' post_t_min4 'tab$' post_t_max4 'tab$' cons_t_min4 'tab$' cons_t_max4 'tab$' big_t_min4 'tab$' big_t_max4 'tab$' premin5 'tab$' premax5 'tab$' postmin5 'tab$' postmax5 'tab$' consmin5 'tab$' consmax5 'tab$' bigmin5 'tab$' bigmax5 'tab$' delta_i_bf5 'tab$' delta_i_aft5 'tab$' delta_i5 'tab$' pre_t_min5 'tab$' pre_t_max5 'tab$' post_t_min5 'tab$' post_t_max5 'tab$' cons_t_min5 'tab$' cons_t_max5 'tab$' big_t_min5 'tab$' big_t_max5 'tab$' premin6 'tab$' premax6 'tab$' postmin6 'tab$' postmax6 'tab$' consmin6 'tab$' consmax6 'tab$' bigmin6 'tab$' bigmax6 'tab$' delta_i_bf6 'tab$' delta_i_aft6 'tab$' delta_i6 'tab$' pre_t_min6 'tab$' pre_t_max6 'tab$' post_t_min6 'tab$' post_t_max6 'tab$' cons_t_min6 'tab$' cons_t_max6 'tab$' big_t_min6 'tab$' big_t_max6 'tab$''newline$'

# Make a list of file names and open wave files.
Create Strings as file list... list 'directory$'*.wav
number_files = Get number of strings
for ifile to number_files
	select Strings list
	current_file$ = Get string... ifile
	Read from file... 'directory$''current_file$'
	base_name$ = current_file$ - ".wav"
	sound0 = selected("Sound")

# Open the corresponding TextGrid file.
	Read from file... 'directory$''base_name$'.TextGrid
	textGridID = selected("TextGrid")
	num_labels = Get number of intervals... labeled_tier_number

# process each frequency band

	for j from 1 to 6
		select 'sound0'

# filter and get intensity differences
		Filter (pass Hann band)... left_range_Band'j' right_range_Band'j' sm_'j'
		To Intensity... 'f0_minimum' 0.001 yes
		Formula... (self[col+1]-self[col])/0.001

# dump results to a matrix and cast its contents to a Sound; then low pass filter to smooth.

		Down to Matrix
		To Sound (slice)... 1

		low_pass = band'j'_low_pass
		roll_off = round('low_pass' * 0.1)
		Filter (pass Hann band)... 0 'low_pass' 'roll_off'

# rename sound created by each band

		Rename... sound_'j'
	endfor

Read Strings from raw text file... 'directory$''segment_file_name$'
segments = selected("Strings")
lenseg = Get number of strings

# Get values near each labeled interval (within offsets)
for k to num_labels
	select 'textGridID'
	label$ = Get label of interval... labeled_tier_number k
		for m to lenseg
			select 'segments'
				text$ [m] = Get string... m
				if label$ = text$ [m]
				select 'textGridID'
				tmin = Get starting point... labeled_tier_number k
				tmax = Get end point... labeled_tier_number k
				precons = tmin - 'offset'
				cons = tmax - tmin
				postcons = tmax + 'offset'

# select the twice-filtered sound and get minimum and maximum within labeled interval +/- offsets

		for n from 1 to 6
			select Sound sound_'n'
			premin = Get minimum... 'precons' 'tmin' Parabolic
			premax = Get maximum... 'precons' 'tmin' Parabolic
			postmin = Get minimum... 'tmax' 'postcons' Parabolic
			postmax = Get maximum... 'tmax' 'postcons' Parabolic
			consmin = Get minimum... 'tmin' 'tmax' Parabolic
			consmax = Get maximum... 'tmin' 'tmax' Parabolic
			bigmin = Get minimum... 'precons' 'postcons' Parabolic
			bigmax = Get maximum... 'precons' 'postcons' Parabolic

			delta_i_bf = premax - consmin
			delta_i_aft = postmax - consmin
			delta_i = bigmax - consmin

			pre_t_min = Get time of minimum... 'precons' 'tmin' Parabolic
			pre_t_max = Get time of maximum... 'precons' 'tmin' Parabolic
			post_t_min = Get time of minimum... 'tmax' 'postcons' Parabolic
			post_t_max = Get time of maximum... 'tmax' 'postcons' Parabolic
			cons_t_min = Get time of minimum... 'tmin' 'tmax' Parabolic
			cons_t_max = Get time of maximum... 'tmin' 'tmax' Parabolic
			big_t_min = Get time of minimum... 'precons' 'postcons' Parabolic
			big_t_max = Get time of maximum... 'precons' 'postcons' Parabolic

# write the values and the corresponding times to a text file
				
			if n = 1 
				fileappend "'directory$''output_file_name$'" 'current_file$' 'tab$' 'k' 'tab$' 'label$' 'tab$' 'premin:3' 'tab$' 'premax:3' 'tab$' 'postmin:3' 'tab$' 'postmax:3' 'tab$' 'consmin:3' 'tab$' 'consmax:3' 'tab$' 'bigmin:3' 'tab$' 'bigmax:3' 'tab$' 'delta_i_bf:3' 'tab$' 'delta_i_aft' 'tab$' 'delta_i' 'tab$' 'pre_t_min' 'tab$' 'pre_t_max' 'tab$' 'post_t_min' 'tab$' 'post_t_max' 'tab$' 'cons_t_min' 'tab$' 'cons_t_max' 'tab$' 'big_t_min' 'tab$' 'big_t_max' 'tab$' 
			else
				fileappend "'directory$''output_file_name$'" 'premin:3' 'tab$' 'premax:3' 'tab$' 'postmin:3' 'tab$' 'postmax:3' 'tab$' 'consmin:3' 'tab$' 'consmax:3' 'tab$' 'bigmin:3' 'tab$' 'bigmax:3' 'tab$' 'delta_i_bf:3' 'tab$' 'delta_i_aft' 'tab$' 'delta_i' 'tab$' 'pre_t_min' 'tab$' 'pre_t_max' 'tab$' 'post_t_min' 'tab$' 'post_t_max' 'tab$' 'cons_t_min' 'tab$' 'cons_t_max' 'tab$' 'big_t_min' 'tab$' 'big_t_max' 'tab$'
			endif			
		endfor
		
		fileappend "'directory$''output_file_name$'" 'newline$'
		
		else
		#do nothing
		endif
	endfor
endfor

# clear the decks completely before getting the next file

	select all
	minus Strings list
	Remove
endfor
select all
Remove