#Script which scans a sound file looking for a given string and allows one to visually examine, listen to, and categorize the string. 
#Written for glottal stops, but if the user changes the options, it would work just as well for any other sound. Note that the 
#"window margin" refers to the duration before and after the target sound that will be displayed in the editor window. However, 
#one can still freely zoom in and out here. The resulting categorizations are stored in a log file along with the start and end 
#points for the segment/string under examination.

#This script requires that the user have a sound file with an annotated textgrid of the same filename, e.g. foo.wav and foo.Textgrid. 
#Each file should be in the same directory. In addition, the user should create a simple text file which contains a list of
#all the segments they wish to categorize, with one segment/phone per line.

#Copyright, Dr. Christian DiCanio, Haskins Laboratories, 2015.
#Modified for glottalization, 2020. Christian DiCanio, SUNY Buffalo.

form Scan phone and categorize it
   sentence Directory_name: /Users/cdicanio/Dropbox/Unlaboratory_phonology_dicanio/
   sentence Objects_name: ALM_Rana_donde_estas_6-4-17_tonal
   sentence Segment_file_name: segments.txt
   positive Labeled_tier_number 2
   positive Word_tier_number 1
   positive Annotation_tier_number 3
   positive Window_margin 0.2
   sentence Log_file foo
endform

Read from file... 'directory_name$''objects_name$'.wav
soundID = selected("Sound")

Read from file... 'directory_name$''objects_name$'.TextGrid
textGridID = selected("TextGrid")
num_labels = Get number of intervals: labeled_tier_number

fileappend 'directory_name$''log_file$'.txt Soundfile'tab$'Segment'tab$'Seg.with.tone'tab$'Preceding_seg'tab$'Following_seg'tab$'Word'tab$'start'tab$'end'tab$'Word.size'tab$'Realization'tab$''newline$'

Read Strings from raw text file... 'directory_name$''segment_file_name$'
segments = selected("Strings")
lenseg = Get number of strings

	for i to num_labels
		select 'textGridID'
		label$ = Get label of interval... labeled_tier_number i
			for j from 1 to lenseg
			select 'segments'
				text$ [j] = Get string... j
				if label$ = text$ [j]
				select 'textGridID'
	      	intvl_start = Get starting point... labeled_tier_number i
				intvl_end = Get end point... labeled_tier_number i
				intvl_initial = intvl_start - window_margin
				intvl_final = intvl_end + window_margin

				segbf$ = do$ ("Get label of interval...", labeled_tier_number, (i-1))
				segaft$ = do$ ("Get label of interval...", labeled_tier_number, (i+1))

				lex_num = do ("Get interval at time...", word_tier_number, intvl_start)
				lex$ = do$ ("Get label of interval...", word_tier_number, lex_num)

				annot_num = do ("Get interval at time...", annotation_tier_number, intvl_start)
				annot$ = do$ ("Get label of interval...", annotation_tier_number, annot_num)

				select 'soundID'
				plus 'textGridID'
				do ("View & Edit")
					editor TextGrid 'objects_name$'
					do ("Zoom...", intvl_initial, intvl_final)
					beginPause ("Mark the prosodic position")

				#The user can change this question in any way they wish.
					comment ("Where is the sound realized?")
					
					choice ("Position", 3)
					option ("Pre-sonorant")
					option ("Intervocalic")
					option ("Coda")

					comment ("How is the sound realized?")
					
					choice ("Realization", 2)
					option ("Modal")
					option ("Other")
					option ("Creaky/glottalized")
					option ("Complete closure")

    			endPause ("Next", 1)

    			fileappend 'directory_name$''log_file$'.txt 'objects_name$''tab$''label$''tab$''annot$''tab$''segbf$''tab$''segaft$''tab$''lex$''tab$''intvl_start''tab$''intvl_end''tab$''position''tab$''realization''newline$'
				Close
				endeditor
			else
				#do nothing
	   	endif
	endfor
endfor