#ifndef KMER_H
#define KMER_H
#include <stdlib.h>

class Kmer
{
	private:
	int CodeLen;
	int KmerLen;
	int TableLen;

	int KmerIndex(char *s);	
	int KmerIndexNext(int lastidx, char *s);

	public:
	Kmer(int klen,int clen =4); //the length of the k-mer pattern and the number of character types 
	~Kmer();
	int GetKmerLen();  // = pow(clen,klen);
	
	int *AllocCodeTable();

	int debug;	
	void KmerCount(char *seq, int *tab, int *kseq);  
	float KmerComp(int *tab1, int *tab2, int *kseq1,int seqlen);
	float KmerComp(int *tab1, int *tab2, int *kseq1,int seqlen1,int seqlen2,int mul2);
	float KmerComp(int *tab1, int *tab2, int mul1, int mul2);
	int *KmerAdd(int *tab1,int *tab2,int mul1,int mul2);
	int *KmerCopy(int *tab1,int mul1);
	void KmerAdd(int *dest,int *tab1,int mul1);

	void FreeCodeTable(int *ptr) {free(ptr);};
	protected:
	virtual int KmerCode(char c);

};

#endif
