/***********************************************************************
ESPRIT-Forest: Parallel Clustering of Massive Amplicon Sequence Data in Subquadratic Time 
by: Yunpeng Cai, Yijun Sun, Wei Zheng, Jin Yao and Yujie Yang  (C) 2016
Please kindly cite [Y.Cai et.al PLOS Comp. Biol. 2016]

THE LICENSED WORK IS PROVIDED UNDER THE TERMS OF THE ADAPTIVE PUBLIC LICENSE ("LICENSE") AS FIRST COMPLETED BY: _Yunpeng Cai, Yijun Sun, Wei Zheng, Jin Yao, Yujie Yang_ [Insert the name of the Initial Contributor here]. ANY USE, PUBLIC DISPLAY, PUBLIC PERFORMANCE, REPRODUCTION OR DISTRIBUTION OF, OR PREPARATION OF DERIVATIVE WORKS BASED ON, THE LICENSED WORK CONSTITUTES RECIPIENT'S ACCEPTANCE OF THIS LICENSE AND ITS TERMS, WHETHER OR NOT SUCH RECIPIENT READS THE TERMS OF THE LICENSE. "LICENSED WORK" AND "RECIPIENT" ARE DEFINED IN THE LICENSE. A COPY OF THE LICENSE IS LOCATED IN THE TEXT FILE ENTITLED "LICENSE.TXT" ACCOMPANYING THE CONTENTS OF THIS FILE. IF A COPY OF THE LICENSE DOES NOT ACCOMPANY THIS FILE, A COPY OF THE LICENSE MAY ALSO BE OBTAINED AT THE FOLLOWING WEB SITE: http://www.acsu.buffalo.edu/~yijunsun/lab/ESPRIT-Forest.html [Insert Initial Contributor's Designated Web Site here]

Software distributed under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the specific language governing rights and limitations under the License.
*/

#include "kmer.h"
#include "PBPTree.h"
#include "needle.h"
#include <iostream>
#include <fstream>
#include "global.h"
using namespace std;

Tree::Tree()
{
	Num_Children=0;
	thres =0.0;
	Child = NULL;
	Parent = NULL;
	TailChild=NULL;
	Brother =this;
}

Tree::Tree(int uid)
{
	UID=uid;
	Num_Children=0;
	thres =0.0;
	Child = NULL;
	TailChild = NULL;
	Parent = NULL;
	Brother =this;
}

Tree::~Tree()
{
	Tree *ptr,*ptr2;
	if (this->Child !=NULL)
	{
		ptr=this->Child;
		while (ptr->Brother !=ptr)
		{
			ptr2=ptr->Brother;
			ptr->Brother=ptr2->Brother;
			delete ptr2;
		}
		delete ptr;
	}
}


void Tree::AddChild(Tree *subtree)
{
	if (subtree->Brother !=subtree)
	{
		cerr <<" Cannot insert multiple branch at the same time." <<endl;
	}
	if (Child==NULL)
	{
		Child=subtree;
		TailChild=subtree;
	}
	else
	{
		TailChild->Brother= subtree;
		subtree->Brother=this->Child;			
		TailChild=subtree;
		if (Child->Brother ==Child) cerr <<"FT here " <<endl;
	}
	
	subtree->Parent=this;
	this->Num_Children++;
}

void Tree::DeleteChild(Tree *subtree)
{
		if (this->Child ==NULL)
		{
			cerr <<"Deleting an Empty Tree" <<endl;
			return;
		}
			
		Tree *ptr=this->Child;

		if (ptr->Brother==ptr)
		{
			if (ptr !=subtree)
			{
				cerr <<"Deleting Non-exist Child" <<endl;
			}
			else
			{
				this->Child=NULL;
				this->Num_Children=0;
				delete ptr;
			}
			return;
		}
		
		while (ptr->Brother != subtree)
		{
				ptr=ptr->Brother;
				if (ptr == this->Child)
				{
					cerr <<"Deleting Non-exist Child" <<endl;
					return;
				}	
		}
		ptr->Brother=subtree->Brother;
		this->Num_Children--;
		if (TailChild ==subtree)
				TailChild = ptr;		
		if (this->Child == subtree)
				this->Child =subtree->Brother;
		delete subtree;
}


float Tree::FindSpanChild(int uid,Tree * &subtree)
{
	if (this->Child ==NULL)
	{
		subtree=NULL;
		return 1.0;
	}

	float dist;
	Tree *cur=this->Child;

	do
	{
		if (Global::cache->Get(cur->UID,uid,dist))
		{
			if (dist < this->FirstChild()->GetThres())
			{
				subtree=cur;
				return dist;
			}
		}
		else
		{
			dist=KmerDist(uid,cur->UID);
			if (dist < KdistBound(cur->GetThres()) )
			{
				dist =Kdist2Ndist(dist);
				subtree=cur;
				return dist;
			}
		}
		cur=cur->Brother;
	}while (cur !=this->Child);
	subtree=NULL;
	return 1.0;
}

Tree *Tree::FindChild(int uid)
{
	Tree *ret;
	if (this->Child ==NULL)
	{
		return NULL;
	}

	Tree *ptr=this->Child;
	Tree *ptrend=this->Child;
	do{
		if (ptr->UID ==uid)
			return ptr;
		ptr=ptr->Brother;
	}while (ptr !=ptrend);	
	return NULL;
}

void Tree::ListChildren(vector<Tree *> & tvec)
{
	if (this->Child ==NULL)
		return;
	Tree *ptr=this->Child;
	do{
		tvec.push_back(ptr);
		ptr=ptr->Brother;
	}while (ptr !=this->Child);
}

void Tree::ListChildrenAt(float thres, vector<Tree *> & tvec)
{
	if (this->Child ==NULL)
	{
		tvec.push_back(this);
		return;
	}
	Tree *ptrend=this->Child;
	Tree *ptr=this->Child;
	do{
			if (ptr->GetThres() <=thres+MIN_THRES/3) 
			{
				tvec.push_back(ptr);
			}
			else
			{
				ptr->ListChildrenAt(thres,tvec);
			}
			ptr=ptr->Brother;
	}while (ptr !=ptrend);
}

void Tree::ListBottom(vector<Tree *> & tvec)
{
	if (this->Child ==NULL)
	{
		tvec.push_back(this);
		return;
	}
	Tree *ptrend=this->Child;
	Tree *ptr=this->Child;
	do{
			if (ptr->BottomLevel()) 
			{
				tvec.push_back(ptr);
			}
			else
			{
				ptr->ListBottom(tvec);
			}
			ptr=ptr->Brother;
	}while (ptr !=ptrend);
}

void Tree::ListLeaf(vector<Tree *> & tvec)
{
	this->ListChildrenAt(0.0,tvec);
}

