function Weight = Original_Relief(patterns, targets, Para4Relief);%KN,distance)

%Original_Relief: Batch learning model for both binary and multi-class problems
%INPUT:
%     patterns:  training data: Each column is an observation
%     targets:   class label {1,2,...C}, starting from 1.
%     test_patterns:
%     test_targets:
%     KN :  # of nearest neighbor
%     distance: 'Euclidean' or 'Block' used in the evaluation of
%     margin/search for the nearest neighbor
%OUTPUT:
%    Weight: weight of features
%--------------------------------------------------------------------------
%University of Florida, by Yijun Sun
%OCT 15, 2005
%==========================================================================
KN = Para4Relief.KN;
distance = Para4Relief.distance;
N_patterns = length(targets);  % # of patterns
dim = size(patterns,1);        % Data dimenionality
Weight = ones(dim,1);

Uc          = unique(targets);
if min(Uc)==-1
    targets = targets/2+1.5;   % transform targets into {1,2}
end

for n=1:length(Uc)
    temp = find(targets==n); 
    index{n} =temp;
    N(n) = length(temp);
end
%------------------------------------------------------------------------

switch lower(distance)
    
    case{'euclidean'}
        NM = zeros(dim,N_patterns); 
        NH = zeros(dim,N_patterns); 
        for i = 1:N_patterns
            if N(targets(i))>1
                for c = 1:length(Uc)
                    Temp            = (patterns(:,index{c}) - patterns(:,i)*ones(1,N(c))).^2;
                    dist            = sum(Temp,1);
                    [m, indices]    = sort(dist);
                    
                    if targets(i)==c; 
                        NH(:,i) = NH(:,i) + sum(Temp(:,indices(2:min(KN+1,length(indices)))),2);  
                    end
                    if targets(i)~=c; 
                        NM(:,i) = NM(:,i) + sum(Temp(:,indices(1:min(KN,length(indices)))),2);   
                    end
                end
            end
        end
        
        NM = NM/(length(Uc)-1);
        C = sum(NM-NH,2); 
        index = find(C<0); C(index)=0;
        Weight = C/norm(C);
        
    case{'block'}
        NM = zeros(dim,N_patterns); 
        NH = zeros(dim,N_patterns); 
        for i = 1:N_patterns,
            for c = 1:length(Uc)
                Temp            = abs(patterns(:,index{c}) - patterns(:,i)*ones(1,N(c)));
                dist            = sum(Temp,1);
                [m, indices]    = sort(dist);

                if targets(i)==c; 
                   NH(:,i) = NH(:,i) + sum(Temp(:,indices(2:min(KN+1,length(indices)))),2); 
                end
                if targets(i)~=c; 
                   NM(:,i) = NM(:,i) + sum(Temp(:,indices(1:min(KN,length(indices)))),2);   
                end
            end
        end
        
        NM = NM/(length(Uc)-1);
        C = sum(NM-NH,2); 
        index = find(C<0); C(index)=0;
        Weight = C/norm(C);
end
return
