function Main_AdaptiveRelief_Multiclass(dataset,No_RandomFeature,Percentage);%,MarginDef)

%FUNCTION MAIN: main function for Adaptive Relief Multi-class
%========================================================
%Yijun Sun, University of Florida
%Oct 21, 2005/March 15, 2006
%========================================================
%Lesson: Automize everything, save time and your life
%=======================================================

close all
given=1; %if parameter given or not
AddSomePath; %add some pathes
%---------------------------------------------------------
[No_Train, No_Test,Ifpartition]=DataInformation(dataset);
%eval(['load C:\Work\AdaptiveRelief\Result\Result_' dataset '_' num2str(No_RandomFeature) '_' num2str(Percentage) '.mat'])
%KN = Para4Relief.KNNpara;
FinalResult_Weight = zeros(20,4);
Stat_IRelief_1 = zeros(21,2,20);
Stat_IRelief_2 = zeros(21,2,20);
Stat_Relief = zeros(21,2,20);
OptimumFeature_IRelief_1 = zeros(20,2);
OptimumFeature_IRelief_2 = zeros(20,2);
OptimumFeature_Relief =zeros(20,2);

for No=1:20
    disp(['>>>> Processing ' num2str(No) '/' num2str(20)]);
    %load data
    TotalData =[];
    TotalTargets =[];
    if Ifpartition==1
        eval(['load ' dataset '.mat'])
        TotalData = Data';%each column is an observation
        TotalTargets = targets(:);
    end
    
    if Ifpartition==0
        eval(['load ' dataset '_train.mat'])
        TotalData = Data';
        TotalTargets = targets(:);
        
        eval(['load ' dataset '_test.mat'])
        TotalData = [TotalData,Data'];
        TotalTargets = [TotalTargets;targets(:)];
    end
    
    [patterns,targets,test_patterns,test_targets]=partition(TotalData,TotalTargets,dataset);
    %clear all data
    clear Data;clear TotalData;clear TotalTargets;
    %-----------------------------------------------------------
    N = length(targets);% Number of patterns
  
    patterns = [patterns; randn(No_RandomFeature,N)]; %Add some irrelevant features
    test_patterns = [test_patterns; randn(No_RandomFeature,size(test_patterns,2))]; % Add some irrelevant features
    dim = size(patterns,1); % Data dimenionality
    
    %---------------------------------------------------------------
    %Preprocess the data: 'unif' tranform each feature into [0, 1]
    [patterns, test_patterns] = preprocessing(patterns, test_patterns,'unif');
    %---------------------------------------------------------------
    
    %Add label noise
    Uc          = unique(targets);
    for n=1:length(Uc)
        index = find(targets==n);
        temp = randperm(length(index));
        Num2change = round(length(index)*Percentage/100);
        for m = 1:Num2change
            ii(1) = n;
            while ii(1)==n
                ii = randperm(length(Uc));
            end
            targets(index(temp(m))) =ii(1);    
        end
    end
    for n=1:length(Uc)
        index = find(targets==n);
        No_EachClass(n) = length(index);
    end
    %---------------------------------------------------------------------
    
    %---------------------------------------------------------------------
    %Parameter for Iterative Relief/Relief
    it = 5;
    distance ='block';%'euclidean'; %
    kernel = 'exp';
    Para4IRelief.it = it;
    Para4IRelief.distance = distance;
    Para4IRelief.kernel = kernel;
    Para4IRelief.Outlier =1;
    %--------------------------------
    Para4Relief.distance = distance;
    %------------------------------------------------------------------
    
    if No==1
        if given==1
             KN=9;
             Para4Relief.KNNpara = 9;% # of the nearest neighbors in KNN
             Para4IRelief.sigma= 0.5;
             Para4Relief.KN= 10; % # of the nearest neighbors in Relief
             Para4IRelief.Prob= 'yes';
             Para4IRelief.KN= 10; % # of the nearest neighbors in Relief

        else
            % Cross-validation: only operated on the first dataset for computational reason.
            Error=[];
            K =[1:2:20];%min(No_EachClass)
            for k=1:length(K)
                Error(k) = CrossValidation(patterns,targets,'KNN_1',K(k),10,'fold'); % it is for multi-class problems.
            end
            [dum,I] = min(Error);
            KN = K(I(1)); % # of the nearest neighbors in KNN
            Para4Relief.KNNpara = KN;
            
            %Find sigma in Iterative AdaBoost
            Error =[];
            Sigma =[0.1,0.2,0.3,0.4,0.5,1,1.5,2];
            F=10;
            for k=1:length(Sigma)
                Para4IRelief.sigma = Sigma(k);
                Error(k) =FindSigma_IRelief(patterns,targets,KN,F,Para4IRelief,2);
            end
            [dum,I] = min(Error);
            Para4IRelief.sigma= Sigma(I(1)) % # of the nearest neighbors in KNN
            %Para4IRelief.sigma= 0.5;
            
            %Find K in Relief
            Error =[];
            K = [1:3:20];%min(No_EachClass)];
            F=10;
            for k=1:length(K)
                Para4Relief.KN = K(k);
                Error(k) =FindK_Relief(patterns,targets,KN,F,Para4Relief);
            end
            [dum,I] = min(Error);
            Para4Relief.KN= K(I(1)); % # of the nearest neighbors in KNN
        end
    end
    
    %--------------------------------------------------------------------------
    %Relief Algorithm/need modification
    weights_relief = Original_Relief(patterns, targets, Para4Relief);
    %----------------------------------------------------------------------
    %I-M-Relief.
    weights_rho1 = IMRelief_1(patterns, targets, Para4IRelief);
    weights_rho2 = IMRelief_2(patterns, targets, Para4IRelief);
%     [weights_rho1,dum] = Online_IMRelief_1_1(patterns, targets, Para4IRelief,[]);
%     [weights_rho2,dum] = Online_IMRelief_2_1(patterns, targets, Para4IRelief,[]);

%     load C:\Work\AdaptiveRelief\Result\Weights\Weights_Glass_50_0_multiclass.mat
%     weights_rho1 = squeeze(Weight0fAlgorithms(:,2,1));
%     weights_rho2 = squeeze(Weight0fAlgorithms(:,3,1));

    figure(1);plot(weights_rho1/max(weights_rho1),'-o')
    hold on;
    plot(weights_rho2/max(weights_rho2),'-ro')
    hold on;
    plot(weights_relief/max(weights_relief),'-ko');
    legend('I-Relief-1','I-Relief-2','Relief');grid on;hold off; drawnow;
    %keyboard
    %======================================================================
    %Test stage (I): Nearest Neighbor Algorithm
    switch lower(distance)
        case{'euclidean'}
            patterns_Irelief_1 = diag(sqrt(weights_rho1))*patterns; 
            test_patterns_Irelief_1 = diag(sqrt(weights_rho1))*test_patterns;
            
            patterns_Irelief_2 = diag(sqrt(weights_rho2))*patterns; 
            test_patterns_Irelief_2 = diag(sqrt(weights_rho2))*test_patterns;
            
            patterns_relief = diag(sqrt(weights_relief))*patterns; 
            test_patterns_relief = diag(sqrt(weights_relief))*test_patterns;
            
        case{'block'}
            patterns_Irelief_1 = diag((weights_rho1))*patterns; 
            test_patterns_Irelief_1 = diag((weights_rho1))*test_patterns;
            
            patterns_Irelief_2 = diag((weights_rho2))*patterns; 
            test_patterns_Irelief_2 = diag((weights_rho2))*test_patterns;
            
            patterns_relief = diag(sqrt(weights_relief))*patterns; 
            test_patterns_relief = diag(sqrt(weights_relief))*test_patterns;
    end
    result = Nearest_Neighbor(patterns, targets, test_patterns, KN, 'knn');
    Test_Error_before= length(find(result(:)~=test_targets(:)))/length(result);
    disp(['>>>> The testing error of before feature selection is ' num2str(Test_Error_before*100) '%.']);
    
    result = Nearest_Neighbor(patterns_relief, targets, test_patterns_relief, KN, 'knn');
    Test_Error_relief= length(find(result(:)~=test_targets(:)))/length(result);
    disp(['>>>> The testing error of RELIEF is ' num2str(Test_Error_relief*100) '%.']);
    
    result = Nearest_Neighbor(patterns_Irelief_1, targets, test_patterns_Irelief_1, KN, 'knn');
    Test_Error_IRelief_1= length(find(result(:)~=test_targets(:)))/length(result);
    disp(['>>>> The testing error of A-RELIEF-1 is ' num2str(Test_Error_IRelief_1*100) '%.']);
    
    result = Nearest_Neighbor(patterns_Irelief_2, targets, test_patterns_Irelief_2, KN, 'knn');
    Test_Error_IRelief_2= length(find(result(:)~=test_targets(:)))/length(result);
    disp(['>>>> The testing error of A-RELIEF-2 is ' num2str(Test_Error_IRelief_2*100) '%.']);
    
    FinalResult_Weight(No,:) = [Test_Error_before,Test_Error_relief,Test_Error_IRelief_1,Test_Error_IRelief_2];
    
    %------------------------------------------------------------
    %statistical of selected features
    weights_rho1 = weights_rho1/max(weights_rho1); %for I-Relief-1
    weights_rho2 = weights_rho2/max(weights_rho2); %for I-Relief-1
    weights_relief =weights_relief/max(weights_relief); %for Relief
    
    [Pd,Pf] = FeatureSelectStat(weights_rho1,No_RandomFeature);
    Stat_IRelief_1(:,:,No) = [Pd,Pf];
    N_NonZero_IRelief_1 = sum(weights_rho1>0.01);
    
    [Pd,Pf] = FeatureSelectStat(weights_rho2,No_RandomFeature);
    Stat_IRelief_2(:,:,No) = [Pd,Pf];
    N_NonZero_IRelief_2 = sum(weights_rho2>0.01);
    
    [Pd,Pf] = FeatureSelectStat(weights_relief,No_RandomFeature);
    Stat_Relief(:,:,No) = [Pd,Pf];
    N_NonZero_Relief = sum(weights_relief>0.01);
    
    %-------------------------------------------------------------
    %Testing errors of diiferent number of features
    Test_Error_relief=[];Test_Error_IRelief_1=[];Test_Error_IRelief_2=[];
    [dum,Index_Relief] = sort(weights_relief);
    [dum,Index_I_Relief_1] = sort(weights_rho1);
    [dum,Index_I_Relief_2] = sort(weights_rho2);
    
    if dim-No_RandomFeature>10
        Step =round(linspace(1,dim-No_RandomFeature,10));
    else
        Step =[1:dim-No_RandomFeature];
    end
    if No==1;FinalResult_Threshold = zeros(length(Step),3,20);end
    
    Find_OptimumFeatureNumber_IRelief_1 = [];
    Find_OptimumFeatureNumber_IRelief_2 = [];
    Find_OptimumFeatureNumber_Relief = [];

    for f=1:length(Step)%dim-No_RandomFeature
        index = Index_I_Relief_1(end-Step(f)+1:end);
        if length(index)>N_NonZero_IRelief_1;
            Test_Error_IRelief_1(f) = Test_Error_IRelief_1(f-1);
            Find_OptimumFeatureNumber_IRelief_1(f) =Find_OptimumFeatureNumber_IRelief_1(f-1);
        else
            Find_OptimumFeatureNumber_IRelief_1(f) = CrossValidation(patterns(index,:),targets,'KNN_1',KN,10,'fold'); 
            result = Nearest_Neighbor(patterns(index,:), targets, test_patterns(index,:), KN, 'knn');
            Test_Error_IRelief_1(f)= length(find(result(:)~=test_targets(:)))/length(result);
        end
        
        index = Index_I_Relief_2(end-Step(f)+1:end);
        if length(index)>N_NonZero_IRelief_2;
            Test_Error_IRelief_2(f) = Test_Error_IRelief_2(f-1);
            Find_OptimumFeatureNumber_IRelief_2(f) =Find_OptimumFeatureNumber_IRelief_2(f-1);
        else
            Find_OptimumFeatureNumber_IRelief_2(f) = CrossValidation(patterns(index,:),targets,'KNN_1',KN,10,'fold'); 
            result = Nearest_Neighbor(patterns(index,:), targets, test_patterns(index,:), KN, 'knn');
            Test_Error_IRelief_2(f)= length(find(result(:)~=test_targets(:)))/length(result);
        end
        
        index = Index_Relief(end-Step(f)+1:end);
        if length(index)>N_NonZero_Relief;
            Test_Error_relief(f) = Test_Error_relief(f-1);
            Find_OptimumFeatureNumber_Relief(f) =Find_OptimumFeatureNumber_Relief(f-1);
        else
            Find_OptimumFeatureNumber_Relief(f) = CrossValidation(patterns(index,:),targets,'KNN_1',KN,10,'fold'); 
            result = Nearest_Neighbor(patterns(index,:), targets, test_patterns(index,:), KN, 'knn');
            Test_Error_relief(f)= length(find(result(:)~=test_targets(:)))/length(result);
        end
        
    end
    figure(2);plot(Step,Test_Error_relief,'-o')
    hold on
    plot(Step,Test_Error_IRelief_1,'*-k')
    hold on
    plot(Step,Test_Error_IRelief_2,'-or')
    legend('Relief','I-Relief-1','I-Relief-2');hold off;drawnow;
    
    [dum,I] = min(Find_OptimumFeatureNumber_IRelief_1);
    OptimumFeature_IRelief_1(No,:)= [I(1),Test_Error_IRelief_1(I(1))];
    
    [dum,I] = min(Find_OptimumFeatureNumber_IRelief_2);
    OptimumFeature_IRelief_2(No,:)= [I(1),Test_Error_IRelief_2(I(1))];

    [dum,I] = min(Find_OptimumFeatureNumber_Relief);
    OptimumFeature_Relief(No,:)= [I(1),Test_Error_relief(I(1))];

    FinalResult_Threshold(:,:,No) = [Test_Error_relief(:),Test_Error_IRelief_1(:),Test_Error_IRelief_2(:)];
end
Stat.IRelief_1 = mean(Stat_IRelief_1,3);
Stat.IRelief_2 = mean(Stat_IRelief_2,3);
Stat.Relief = mean(Stat_Relief,3);
M = mean(FinalResult_Threshold,3);

figure;
plot(Step,M(:,1),'-v');
hold on
plot(Step,M(:,2),'-*');
hold on
plot(Step,M(:,3),'-o');
legend('Relief','I-Relief-1','I-Relief-2',0);
hold off;grid on;
axis tight
xlabel('Number of Features')
ylabel('Classification Error')
title([dataset '(' num2str(No_RandomFeature) '/' num2str(Percentage) ')'])
boldify1


keyboard
%eval(['save C:\Work\AdaptiveRelief\Result\Multiclass\Result_' dataset '_' num2str(No_RandomFeature) '_' num2str(Percentage) '.mat FinalResult_Weight FinalResult_Threshold Para4Relief Para4IRelief Stat Step'])
eval(['save C:\Work\AdaptiveRelief\Result\Comparison\Comparison_' dataset '_' num2str(No_RandomFeature) '_' num2str(Percentage) '.mat OptimumFeature_IRelief_1 OptimumFeature_IRelief_2 OptimumFeature_Relief FinalResult_Threshold Para4Relief Para4IRelief Step'])
eval(['save C:\Work\AdaptiveRelief\Result\Comparison\Result_' dataset '_' num2str(No_RandomFeature) '_' num2str(Percentage) '.mat FinalResult_Weight FinalResult_Threshold Para4Relief Para4IRelief Stat Step'])

