function CalculateWeights(dataset,No_RandomFeature,Percentage)

%FUNCTION CalculateWeights: A temp function to calculate weights
%========================================================
%Yijun Sun, University of Florida
%Oct 25, 2005
%========================================================
close all
AddSomePath; %add some pathes
eval(['load C:\Work\AdaptiveRelief\Result\Result_' dataset '_' num2str(No_RandomFeature) '_' num2str(Percentage) '.mat'])
KN = Para4Relief.KNNpara;
%---------------------------------------------------------

for No=1:20
    %load data
    eval(['load ' dataset '_train_data_' num2str(No) '.asc'])
    eval(['load ' dataset '_train_labels_' num2str(No) '.asc'])
    eval(['load ' dataset '_test_data_' num2str(No) '.asc'])
    eval(['load ' dataset '_test_labels_' num2str(No) '.asc'])
    
    switch dataset
        case {'flare-solar'}
            eval(['patterns = flare_solar_train_data_' num2str(No) ';']);
            patterns = patterns'; % Each column is an observation
            eval(['targets = flare_solar_train_labels_' num2str(No) ';']);
            eval(['test_patterns = flare_solar_test_data_' num2str(No) ';']);
            test_patterns = test_patterns';
            eval(['test_targets = flare_solar_test_labels_' num2str(No) ';']);
            
        otherwise      
            eval(['patterns =' dataset '_train_data_' num2str(No) ';']);
            patterns = patterns'; % Each column is a pattern.
            eval(['targets = ' dataset '_train_labels_' num2str(No) ';']);
            eval(['test_patterns =' dataset '_test_data_' num2str(No) ';']);
            test_patterns = test_patterns';
            eval(['test_targets =' dataset '_test_labels_' num2str(No) ';']);
    end
    
    %clear all data
    eval(['clear ' dataset '_train_data_' num2str(No) ';'])
    eval(['clear ' dataset '_train_labels_' num2str(No) ';']);
    eval(['clear ' dataset '_test_data_' num2str(No) ';']);
    eval(['clear ' dataset '_test_labels_' num2str(No) ';']);
    %-----------------------------------------------------------
    N = length(targets);% Number of patterns
    
    patterns = [patterns; randn(No_RandomFeature,N)]; %Add some irrelevant features
    test_patterns = [test_patterns; randn(No_RandomFeature,size(test_patterns,2))]; % Add some irrelevant features
    dim = size(patterns,1); % Data dimenionality
    
    if No==1;Weight0fAlgorithms =zeros(dim,3,20);end

    %---------------------------------------------------------------
    %Preprocess the data: 'unif' tranform each feature into [0, 1]
    [patterns, test_patterns] = preprocessing(patterns, test_patterns,'unif');
    %---------------------------------------------------------------
    %Add label noise
    index0 = find(targets==-1);
    index1 = find(targets==1);
    
    temp = randperm(length(index0));
    Num2change = round(length(index0)*Percentage/100);
    targets(index0(temp(1:Num2change))) = 1;
    
    temp = randperm(length(index1));
    Num2change = round(length(index1)*Percentage/100);
    targets(index1(temp(1:Num2change))) = -1;
    %---------------------------------------------------------------------
    
    %---------------------------------------------------------------------
    %Parameter for Iterative Relief/Relief
    it = 10;
    distance ='euclidean'; 
    kernel = 'exp';
    Para4IRelief.it = it;
    Para4IRelief.distance = distance;
    Para4IRelief.kernel = kernel;
    Para4IRelief.Outlier =1;
    %--------------------------------
    Para4Relief.distance = distance;
    
    %--------------------------------------------------------------------------
    %Relief Algorithm/need modification
    %weights_relief = relief(patterns', targets);
    %weights_relief = New_Relief(patterns, targets, 10,1,distance);
    weights_relief = Original_Relief(patterns, targets, Para4Relief);

    %----------------------------------------------------------------------
    %I-M-Relief.
    weights = IMRelief_1(patterns, targets, Para4IRelief);
    %weights =IMRelief_2(patterns, targets, Para4IRelief);
    
    %Simba
    extra_param.max_iter = 5;
    extra_param.start_points=5;
    weights_simba_lin = simba(patterns', targets,extra_param);
    figure(1);plot(weights/max(weights),'-o')
    hold on;
    plot(weights_relief/max(weights_relief),'-ko');hold on
    plot(weights_simba_lin/max(weights_simba_lin),'-r*')
    legend('I-Relief','Relief','Simba');grid on;hold off; drawnow;
    
    Weight0fAlgorithms(:,:,No) = [weights_relief(:)/sum(weights_relief),weights(:)/sum(weights),weights_simba_lin(:)/sum(weights_simba_lin)];
   
end

keyboard
eval(['save C:\Work\AdaptiveRelief\Result\Weights\Weights_' dataset '_' num2str(No_RandomFeature) '_' num2str(Percentage) '.mat Weight0fAlgorithms'])




return










