function pvs(temp)
%vapor pressure at saturation
a1 = -1.021416462e4;
a2 = -4.89350301;
a3 = -5.37657944e-3;
a4 = 1.92023769e-7;
a5 = 3.55758316e-10;
a6 = -9.03446886e-14;
a7 = 4.1635019;
a8 = -1.044039708e4;
a9 = -1.12946496e1;
a10 = -2.7022355e-2;
a11 = 1.289036e-5;
a12 = -2.478068e-9;
a13 = 6.5459673;
t = temp + 459.67;
if (temp < 32) 
    pvs = exp( a1/t+a2+a3*t+a4*pow(t,2)+a5*t^3+a6*t^4+a7*log(t));
else 
    pvs = exp( a8/t+a9+a10*t+a11*t^2+a12*t^3+a13*log(t));
end
pvs=pvs*2.036021
