% Computes hr, rh, enthal, dp from db, rh, and atm
% db, wb are entered in farenheit
% atm is entered in atm

function [hr,rh,enthal,dp]=psychroeng2(db,wb,atm)
atm=atm*29.921; % inch Hg

%humidity ratio
hr = psychro_w(db,wb,atm)

%relative humidity
rh = psychro_rh(db,wb,atm)

%enthalpy
enthal = psychro_h_w(db,hr); % in English unit

%partial vapor pressure
pvp = psychro_pv(db,wb,atm); % in English unit
%if SI, multiply by 33.8638

%dew point calculation
dp = psychro_dp(pvp) % in farenheit

vh = psychro_v(db, hr, atm)
% in SI, multiply by 0.062391