% Computes hr, enthal, dp, wb from db, rh, and atm
% db is entered in farenheit
% rh is entered in percentage
% atm is entered in atm

function [hr,enthal,dp,wb]=psychroeng(db,rh,atm)
atm=atm*29.921; % inch Hg

%vapor pressure at saturation
pvs=psychro_pvs(db);
%if SI, multiply by 33.8638

%partial vapor pressure
pvp = rh/100 * pvs; % rh < 1
%if SI, multiply by 33.8638

%humidity ratio
hr = 0.622*(pvp/(atm-pvp)) 

%enthalpy
enthal = db*0.24 + (1061 + (0.444*db))*hr % in English unit
%if SI, H=H*2.3244-17.8125

%dew point calculation
dp = psychro_dp(pvp) % in farenheit

%wb temperature
wb = wet_bulb(db,dp,enthal,atm) % in farenheit

vh = psychro_v(db, hr, atm)
% in SI, multiply by 0.062391