function [enthal]=psychro_enthal(db)
rh=100;
atm=1;
atm=atm*29.921; % inch Hg
db = db.*9/5+32; %db=temperature in farenheit
 
%vapor pressure at saturation
pvs=psychro_pvs2(db);
%if SI, multiply by 33.8638
 
%partial vapor pressure
pvp = rh./100 .* pvs; % rh < 1
%if SI, multiply by 33.8638
 
%humidity ratio
hr = 0.622.*(pvp./(atm-pvp)); 
 
%enthalpy
enthaleng = db.*0.24 + (1061 + (0.444.*db)).*hr; % in English unit
enthal = enthaleng.*2.3244-17.8125; %if SI, H=H*2.3244-17.8125
