% Computes hr, rh, enthal, dp from db, rh, and atm
% db is entered in celsius
% rh is entered in percentage
% atm is entered in atm

function [hr,rh,enthal,dp,vh]=psychro2(db,wb,atm)
atm=atm*29.921; % inch Hg

%db, wb=temperature in farenheit
db = db*9/5+32;
wb = wb*9/5+32;

%humidity ratio
hr = psychro_w(db,wb,atm);

%relative humidity
rh = psychro_rh(db,wb,atm);

%enthalpy
enthal = psychro_h_w(db,hr); % in English unit
enthal = enthal*2.3244-17.8125;  % in SI

%partial vapor pressure
pvp = psychro_pv(db,wb,atm); % in English unit
%if SI, multiply by 33.8638

%dew point calculation
dp = psychro_dp(pvp); % in farenheit
dp = (dp-32)*5/9;      % in celsius

vh = psychro_v(db, hr, atm);
vh = vh*0.062391;  % in SI, multiply by 0.062391