% Computes hr, enthal, dp, wb from db, rh, and atm
% db is entered in celsius
% rh is entered in percentage
% atm is entered in atm

function [hr,enthal,dp,wb,vh]=psychro(db,rh,atm)
atm=atm*29.921; % inch Hg
db = db*9/5+32; %db=temperature in farenheit

%vapor pressure at saturation
pvs=psychro_pvs(db);
%if SI, multiply by 33.8638

%partial vapor pressure
pvp = rh/100 * pvs; % rh < 1
%if SI, multiply by 33.8638

%humidity ratio
hr = 0.622*(pvp/(atm-pvp)); 

%enthalpy
enthaleng = db*0.24 + (1061 + (0.444*db))*hr; % in English unit
enthal = enthaleng*2.3244-17.8125;           %if SI, H=H*2.3244-17.8125

%dew point calculation
dpf = psychro_dp(pvp); % in farenheit
dp = (dpf-32)*5/9;      % in celsius

%wb temperature
wbf = wet_bulb(db,dpf,enthaleng,atm); % in farenheit
wb = (wbf-32)*5/9;

vh = psychro_v(db, hr, atm);
vh = vh*0.062391;  % in SI, multiply by 0.062391