format compact
clear;clc;

atm=1; %1 atm
rh=100;
cp=4.186; %KJ/kg/deg

load('flow.dat')
for i=9:9
    Tylo = flow(1,i);
    Tylowet = flow(2,i);
    Tyhi = flow(3,i);
    Txlo = flow(4,i);
    Txhi = flow(5,i);

    Hy = flow(6,i);
    Gyprime = flow(7,i);
    Gx = flow(8,i);

    Th2o=linspace(Txlo,Txhi);
    for j=1:length(Th2o)
        [hr,enthal,dp,wb,vh]=psychro(Th2o(j),rh,atm);
%        a(j,:)=[h,enthal,dp,wb,vh];
        H(j)=enthal;
    end
    figure(1)
    plot(Th2o,H)
    hold on
    
    plot([Txlo Txhi],[Hy Gx*cp/Gyprime*(Txhi-Txlo)+Hy])
    axis([Txlo-5 Txhi+5 0 H(end)])
    grid
    mytitle=['data ', num2str(i)];
    title(mytitle)
    hold off
    
    figure(2)
    plot(Gx/Gyprime*(Th2o-Txlo)+Hy,1./(H-Gx*cp/Gyprime*(Th2o-Txlo)-Hy))
    title('Hy v. 1/(H*-Hy)')
    
    figure(3)
    plot(Th2o,1./(H-Gx*cp/Gyprime*(Th2o-Txlo)-Hy))
    title('Tx v. 1/(H*-Hy)')  
    
    ntu(i)=trapz(Th2o,1./(H-Gx*cp/Gyprime*(Th2o-Txlo)-Hy))*Gx*cp/Gyprime
    htu(i)=ntu(i)*Gyprime

    rate=H-Gx*cp/Gyprime*(Th2o-Txlo)-Hy;
    figure(4)
    plot(rate)
    deltaHy=trapz(rate);
    TofL=(Txhi-Txlo)/deltaHy*cumtrapz(rate)+Txlo;

    figure(5)
    plot(TofL,[1:length(TofL)]);
    pause
end

