﻿using System;
using System.Drawing;
using System.Collections;

public class ServerClientProtocol
{
    private ArrayList _checkBoxValues = new ArrayList(), _gameNames = new ArrayList(), _hostNames = new ArrayList();
    private int _outCome, _lastSquare, _newSquare, _otherPiece, _winningPlayer, _winType;
    private int[][] _boardSquares = new int[10][];
    private String _clientNames = "", _message = "", _playerName = "";

    public ServerClientProtocol()
    {

    }

    public void decodeClientNames(String fromServer)
    {
        _clientNames = "";
        int index = 0;
        while (fromServer[index] != 36)//$
        {
            if (fromServer[index] == 37)//%
            {
                _clientNames += "\r\n";
            }
            else
            {
                _clientNames += fromServer[index];
            }
            index++;
        }
    }

    public String encodeServerChatFieldVaraibles(String playerName, String message)
    {
        String serverClient = "";
        serverClient += playerName;
        serverClient += "%"; //end of sequence
        serverClient += message;
        serverClient += "%"; //end of sequence
        return serverClient;
    }

    public void decodeServerChatFieldVariables(String serverClient)
    {
        int index = 0;
        _playerName = "";
        while (serverClient[index] != 37)//%
        {
            _playerName += serverClient[index];
            index++;
        }
        index++;
        _message = "";
        while (serverClient[index] != 37)//%
        { 
            _message += serverClient[index];
            index++;
        }
    }

    public String encodeCheckBoxValues(bool[] checkBoxValues)
    {
        String serverClient = "";
        for (int x = 0; x < checkBoxValues.Length; x++)
        {
            if (checkBoxValues[x] == false)
            {
                serverClient += "0";
            }
            else
            {
                serverClient += "1";
            }
        }
        return serverClient;
    }

    public void decodeStrategoGame(String fromServer)
    {
        _checkBoxValues = new ArrayList();
        _gameNames = new ArrayList();
        _hostNames = new ArrayList();
        int index = 0;

        while (fromServer[index] != 36)//$
        {
            bool[] checkBoxValues = new bool[3];
            String gameName = "", hostName = "";
            while (fromServer[index] != 37)//%
            {
                gameName += fromServer[index];
                index++;
            }
            index++;
            _gameNames.Add(gameName);
            while (fromServer[index] != 37)//$
            {
                hostName += fromServer[index];
                index++;
            }
            index++;
            _hostNames.Add(hostName);
            for (int x = 0; x < checkBoxValues.Length; x++)
            {
                if (fromServer[index] - 48 == 0)
                {
                    checkBoxValues[x] = false;
                }
                else
                {
                    checkBoxValues[x] = true;
                }
                index++;
            }
            _checkBoxValues.Add(checkBoxValues);
        }
    }

    public ArrayList decodePlayerNames(String serverClient)
    {
        ArrayList playerNames = new ArrayList();
        int index = 0;
        String name = "";
        while (serverClient[index] != 36)//$
        {
            if (serverClient[index] == 37)//%
            {
                playerNames.Add(name);
                name = "";
            }
            else
            {
                name += serverClient[index];
            }
            index++;
        }
        return playerNames;
    }

    public bool[] decodeCheckBoxValues(String serverClient)
    {
        bool[] checkBoxValues = new bool[3];
        for (int x = 0; x < checkBoxValues.Length; x++)
        {
            if (serverClient[x] - 48 == 0)
            {
                checkBoxValues[x] = false;
            }
            else
            {
                checkBoxValues[x] = true;
            }
        }
        return checkBoxValues;
    }

    public String encodeStrategoBoard(BoardSquare[][] boardSquares, Player currentPlayer)
    {
        String encodedBoard = "";

        int index = 100;
        //if the player is the blue player
        if (currentPlayer.getPlayerColor().Equals(Color.Blue))
        {
            index += 100;
        }

        for (int x = 0; x < boardSquares.Length; x++)
        {
            for (int y = 0; y < boardSquares[x].Length; y++)
            {
                //if the boardsquare has a piece in it that belongs to this player
                if (boardSquares[x][y].getPiece() != null && boardSquares[x][y].getPiece().getPlayer().Equals(currentPlayer))
                {
                    encodedBoard += (boardSquares[x][y].getPiece().getRank() + index);
                }
                //if there is no piece that belongs to this player
                else
                {
                    encodedBoard += 0;
                }
                encodedBoard += "%";
            }
        }

        return encodedBoard;
    }

    public int[][] decodeStrategoBoard(String fromServer, Player player)
    {
        int[][] decodedSquares = new int[10][];
        int index = 0;

        for (int x = 0; x < decodedSquares.Length; x++)
        {
            decodedSquares[x] = new int[10];
            for (int y = 0; y < decodedSquares[x].Length; y++)
            {
                int piece = (fromServer[index] - 48);
                //if this player is the red player
                if (player.getPlayerColor().Equals(Color.Red))
                {
                    decodedSquares[x][y] = fromServer[index] - 48;
                }
                //if this player is the blue player
                else
                {
                    if (piece == 1)
                    {
                        decodedSquares[x][y] = 2;
                    }
                    else if (piece == 2)
                    {
                        decodedSquares[x][y] = 1;
                    }
                    else
                    {
                        decodedSquares[x][y] = piece;
                    }
                }

                index++;
            }
        }

        return decodedSquares;
    }

    public int[][] decodeStrategoBoardPieces(String fromServer, Player player)
    {
        int[][] decodedSquares = new int[10][];
        int index = 0;

        for (int x = 0; x < decodedSquares.Length; x++)
        {
            decodedSquares[x] = new int[10];
            for (int y = 0; y < decodedSquares[x].Length; y++)
            {
                String dummy = "";
                while (fromServer[index] != 37)//%
                {
                    dummy += fromServer[index];
                    index++;
                }

                int piece = int.Parse(dummy);

                //if player is the red player
                if (player.getPlayerColor().Equals(Color.Red))
                {
                    decodedSquares[x][y] = piece;
                }
                //if player is the blue player
                else
                {
                    //if the piece belongs to the red player
                    if (piece / 100 == 1)
                    {
                        decodedSquares[x][y] = (piece + 100);
                    }
                    //if the piece belongs to the blue player
                    else if (piece / 100 == 2)
                    {
                        decodedSquares[x][y] = (piece - 100);
                    }
                    else
                    {
                        decodedSquares[x][y] = (piece);
                    }
                }
                index++;
            }
        }
        return decodedSquares;
    }

    public void decodeStrategoUpdates(String fromServer, Player player)
    {
        int index = 0;
        String dummy = "";

        _outCome = (fromServer[index] - 48);
        index++;

        while (fromServer[index] != 37)//%
        {
            dummy += fromServer[index];
            index++;
        }

        _lastSquare = int.Parse(dummy);

        dummy = "";
        index++;

        while (fromServer[index] != 37)//%
        {
            dummy += fromServer[index];
            index++;
        }

        _newSquare = int.Parse(dummy);

        dummy = "";
        index++;

        while (fromServer[index] != 37)//%
        {
            dummy += fromServer[index];
            index++;
        }

        _otherPiece = int.Parse(dummy);

        index++;


        for (int x = 0; x < _boardSquares.Length; x++)
        {
            _boardSquares[x] = new int[10];
            for (int y = 0; y < _boardSquares[x].Length; y++)
            {
                int piece = (fromServer[index] - 48);
                //if this player is the red player
                if (player.getPlayerColor().Equals(Color.Red))
                {
                    _boardSquares[x][y] = fromServer[index] - 48;
                }
                //if this player is the blue player
                else
                {
                    if (piece == 1)
                    {
                        _boardSquares[x][y] = 2;
                    }
                    else if (piece == 2)
                    {
                        _boardSquares[x][y] = 1;
                    }
                    else
                    {
                        _boardSquares[x][y] = piece;
                    }
                }

                index++;
            }
        }
    }

    public void decodeEndGame(String fromServer)
    {
        int index = 0;
        String dummy = "";

        _winningPlayer = (fromServer[index] - 48);
        index++;
        _winType = (fromServer[index] - 48);
        index++;

        while (fromServer[index] != 37)//%
        {
            dummy += fromServer[index];
            index++;
        }

        _lastSquare = int.Parse(dummy);

        dummy = "";
        index++;

        while (fromServer[index] != 37)//%
        {
            dummy += fromServer[index];
            index++;
        }

        _newSquare = int.Parse(dummy);

        dummy = "";
        index++;

        while (fromServer[index] != 37)//%
        {
            dummy += fromServer[index];
            index++;
        }

        _otherPiece = int.Parse(dummy);
    }

    public String encodeMovingPiece(bool attackedUnit, int lastSquare, int newSquare)
    {
        String serverClient = "";

        if (attackedUnit == true)
        {
            serverClient += "1";
        }
        else
        {
            serverClient += "0";
        }

        serverClient += lastSquare;
        serverClient += "%";
        serverClient += newSquare;
        serverClient += "%";

        return serverClient;
    }

    public ArrayList getCheckBoxValues()
    {
        return _checkBoxValues;
    }

    public ArrayList getGameNames()
    {
        return _gameNames;
    }

    public ArrayList getHostNames()
    {
        return _hostNames;
    }

    public String getMessage()
    {
        return _message;
    }

    public String getPlayerName()
    {
        return _playerName;
    }

    public String getClientNames()
    {
        return _clientNames;
    }

    public int getOutCome()
    {
        return _outCome;
    }

    public int getLastSquare()
    {
        return _lastSquare;
    }

    public int getNewSquare()
    {
        return _newSquare;
    }

    public int getOtherPiece()
    {
        return _otherPiece;
    }

    public int[][] getBoardSquares()
    {
        return _boardSquares;
    }

    public int getWinningPlayer()
    {
        return _winningPlayer;
    }

    public int getWinType()
    {
        return _winType;
    }
}
