﻿using System;

public class Piece
{
    private BoardSquare _currentSquare;
    private int _rank;
    private Player _player;

    public Piece(int rank, Player player, BoardSquare currentSquare)
    {
        _rank = rank;
        _player = player;
        _currentSquare = currentSquare;
    }

    //returns the rank of this piece
    public int getRank()
    {
        return _rank;
    }

    //returns the player that owns this piece
    public Player getPlayer()
    {
        return _player;
    }
    
    //returns the square that this piece is currently in
    public BoardSquare getCurrentSquare()
    {
        return _currentSquare;
    }

    //sets the piece's current square to the new square
    public void setCurrentSquare(BoardSquare square)
    {
        _currentSquare = square;
    }
}
