﻿using System;
using System.Collections;
using System.Data.SqlClient;
using System.Drawing;
using System.Net.Sockets;
using System.Threading;
using System.Windows.Forms;

/*
 * Get rid of _currentTurn from code when I am done with AI
 * Figure out way to not have piece images always being painted when something is clicked
 * 
 */

public class LoadingScreen
{
    private ArrayList _strategoButtons = new ArrayList(), _strategoGames = new ArrayList();
    private Bitmap _backgroundImage;
    private bool _failureScreenShowing = false, _pendingGame = false;
    private bool[] _checkBoxValues = new bool[3];
    private Button _button1, _button2, _button3;
    private CheckedListBox _checkBoxOptions;
    private ComboBox[] _playerComboBox = new ComboBox[2];
    private Form _loadingForm;
    private Label _textLabel, _optionsLabel;
    private Panel _backgroundPanel, _checkBoxOptionsPanel, _listOfGamesPanel;
    private StrategoClient _strategoClient;
    private String _playerName = "", _clientNames = "", _gameName = "";
    private Socket _bindingSocket;
    private TextBox _chatField, _chatBox, _playerNamesBox, _gameInfoBox;
    private System.Windows.Forms.Timer _refreshTimer;

    public LoadingScreen(String playerName, Socket bindingSocket)
    {
        _playerName = playerName;
        _bindingSocket = bindingSocket;

        _loadingForm = new Form();
        _loadingForm.BackColor = Color.Black;
        _loadingForm.Text = "Stratego";
        _loadingForm.Size = new Size(510, 328);
        _loadingForm.StartPosition = FormStartPosition.CenterScreen;
        _loadingForm.MaximizeBox = false;
        _loadingForm.FormBorderStyle = FormBorderStyle.FixedSingle;
        _loadingForm.FormClosing += new FormClosingEventHandler(this.closeLoadingForm);

        _backgroundImage = Stratego.Properties.Resources.strategobox;

        _backgroundPanel = new Panel();
        _backgroundPanel.Size = new Size(400, 264);
        _backgroundPanel.BackColor = Color.Black;
        _backgroundPanel.Location = new Point(0, 35);
        _backgroundPanel.Paint += new PaintEventHandler(this.paintBackground);

        _checkBoxOptionsPanel = new Panel();
        _checkBoxOptionsPanel.Size = new Size(100, 100);
        _checkBoxOptionsPanel.Location = new Point(0, 0);
        _checkBoxOptionsPanel.BackColor = Color.Black;
        _checkBoxOptionsPanel.BorderStyle = BorderStyle.Fixed3D;

        _listOfGamesPanel = new Panel();
        _listOfGamesPanel.BackColor = Color.Black;
        _listOfGamesPanel.BorderStyle = BorderStyle.Fixed3D;
        _listOfGamesPanel.AutoScroll = true;

        _refreshTimer = new System.Windows.Forms.Timer();
        _refreshTimer.Interval = 5000;
        _refreshTimer.Tick += new EventHandler(this.refreshFindGame);

        _button1 = new Button();
        _button1.Text = "Join Server";
        _button1.Name = "JOIN_SERVER";
        _button1.Visible = true;
        _button1.BackColor = Color.Gray;
        _button1.Size = new Size(100, 50);
        _button1.Location = new Point(_backgroundImage.Width, 117);
        _button1.Click += new System.EventHandler(this.buttonEvent);

        _button2 = new Button();
        _button2.Text = "Solo Game";
        _button2.Name = "SOLO_GAME";
        _button2.Visible = true;
        _button2.BackColor = Color.Gray;
        _button2.Size = new Size(100, 50);
        _button2.Location = new Point(_backgroundImage.Width, 167);
        _button2.Click += new System.EventHandler(this.buttonEvent);

        _button3 = new Button();
        _button3.Text = "Exit";
        _button3.Name = "EXIT_SERVER";
        _button3.Visible = true;
        _button3.BackColor = Color.Gray;
        _button3.Size = new Size(100, 50);
        _button3.Click += new System.EventHandler(this.buttonEvent);

        _checkBoxValues[0] = false;
        _checkBoxValues[1] = true;
        _checkBoxValues[2] = true;

        _textLabel = new Label();
        _textLabel.ForeColor = Color.White;
        _textLabel.Size = new Size(125, 35);
        _textLabel.Font = new Font("Arial", 15);
        _textLabel.Location = new Point(0, 0);
        _textLabel.TextAlign = ContentAlignment.MiddleCenter;
        _textLabel.Text = "Enter Name:";

        _optionsLabel = new Label();
        _optionsLabel.ForeColor = Color.White;
        _optionsLabel.TextAlign = ContentAlignment.MiddleCenter;
        _optionsLabel.Font = new Font("Arial", 18);
        _optionsLabel.Text = "Game Options:";
        _optionsLabel.Size = new Size(250, 35);

        _chatBox = new TextBox();
        _chatBox.Size = new Size(200, 200);
        _chatBox.Font = new Font("Times New Roman", 10);
        _chatBox.ReadOnly = true;
        _chatBox.BackColor = Color.Black;
        _chatBox.ForeColor = Color.White;
        _chatBox.Multiline = true;
        _chatBox.ScrollBars = ScrollBars.Vertical;

        _playerNamesBox = new TextBox();
        _playerNamesBox.Size = new Size(200, 200);
        _playerNamesBox.Font = new Font("Times New Roman", 10);
        _playerNamesBox.ReadOnly = true;
        _playerNamesBox.BackColor = Color.Black;
        _playerNamesBox.ForeColor = Color.White;
        _playerNamesBox.Multiline = true;
        _playerNamesBox.ScrollBars = ScrollBars.Vertical;

        _gameInfoBox = new TextBox();
        _gameInfoBox.Size = new Size(200, 200);
        _gameInfoBox.Font = new Font("Times New Roman", 10);
        _gameInfoBox.ReadOnly = true;
        _gameInfoBox.BackColor = Color.Black;
        _gameInfoBox.ForeColor = Color.White;
        _gameInfoBox.Multiline = true;
        _gameInfoBox.ScrollBars = ScrollBars.Vertical;

        for (int x = 0; x < _playerComboBox.Length; x++)
        {
            _playerComboBox[x] = new ComboBox();
            _playerComboBox[x].Text = "";
            _playerComboBox[x].BackColor = Color.Black;
            //_playerComboBox[x].DropDownStyle = ComboBoxStyle.DropDownList;
            _playerComboBox[x].Font = new Font("Times New Roman", 15);
            _playerComboBox[x].ForeColor = Color.White;
            _playerComboBox[x].Size = new Size(254, 75);
        }
        _playerComboBox[1].Name = "BOOT_PLAYER_1";
        _playerComboBox[1].SelectedIndexChanged += new EventHandler(this.bootPlayer);

        _chatField = new TextBox();
        _chatField.Size = new Size((_backgroundPanel.Width - 125), 35);
        _chatField.Location = new Point(125, 0);
        _chatField.Font = new Font("Arial", 15);
        _chatField.BackColor = Color.Black;
        _chatField.ForeColor = Color.White;

        _checkBoxOptions = new CheckedListBox();
        _checkBoxOptions.Items.AddRange(new String[] {"Blue", "Chat", "Graveyard", "1-9"});
        _checkBoxOptions.Font = new Font("Arial", 15);
        _checkBoxOptions.BackColor = Color.Black;
        _checkBoxOptions.ForeColor = Color.White;
        _checkBoxOptions.BorderStyle = BorderStyle.None;
        _checkBoxOptions.IntegralHeight = false;
        _checkBoxOptions.CheckOnClick = true;
        _checkBoxOptions.ThreeDCheckBoxes = true;
        _checkBoxOptions.MultiColumn = true;
        _checkBoxOptions.Size = new Size(250, 90);

        _loadingForm.Controls.Add(_chatField);
        _loadingForm.Controls.Add(_textLabel);
        _loadingForm.Controls.Add(_backgroundPanel);
        _loadingForm.Controls.Add(_button1);
        _loadingForm.Controls.Add(_button2);

        _loadingForm.Show();
        Application.Run(_loadingForm);
    }

    //creates the screen that allows you to select between a solo game or a multiplayer game
    public void createLoadingScreen()
    {
        _clientNames = "";
        _gameName = "";
        _failureScreenShowing = false;
        _loadingForm.Controls.Remove(_chatField);
        _loadingForm.Controls.Remove(_chatBox);
        _loadingForm.Controls.Remove(_checkBoxOptionsPanel);
        _loadingForm.Controls.Remove(_optionsLabel);
        _loadingForm.Controls.Remove(_textLabel);
        _loadingForm.Controls.Remove(_playerNamesBox);
        _loadingForm.Controls.Remove(_backgroundPanel);
        _loadingForm.Controls.Remove(_button1);
        _loadingForm.Controls.Remove(_button2);
        _loadingForm.Controls.Remove(_button3);
        _loadingForm.Controls.Remove(_checkBoxOptions);
        _loadingForm.Controls.Remove(_playerComboBox[0]);
        _loadingForm.Controls.Remove(_playerComboBox[1]);
        _loadingForm.Controls.Remove(_listOfGamesPanel);
        _loadingForm.Controls.Remove(_gameInfoBox);

        _button1.Text = "Join Server";
        _button1.Name = "JOIN_SERVER";
        _button1.Enabled = true;
        _button1.Location = new Point(_backgroundImage.Width, 117);

        _button2.Text = "Solo Game";
        _button2.Name = "SOLO_GAME";
        _button2.Location = new Point(_backgroundImage.Width, 167);

        _chatField.Size = new Size((_backgroundPanel.Width - 125), 35);
        _chatField.Location = new Point(125, 0);
        _chatField.Font = new Font("Arial", 15);
        _chatField.BackColor = Color.Black;
        _chatField.ForeColor = Color.White;
        _chatField.KeyDown -= new KeyEventHandler(this.chatFieldTextEntered);

        _textLabel.Size = new Size(125, 35);
        _textLabel.Font = new Font("Arial", 15);
        _textLabel.Location = new Point(0, 0);
        _textLabel.ForeColor = Color.White;
        _textLabel.Text = "Enter Name:";

        _loadingForm.Controls.Add(_chatField);
        _loadingForm.Controls.Add(_textLabel);
        _loadingForm.Controls.Add(_backgroundPanel);
        _loadingForm.Controls.Add(_button1);
        _loadingForm.Controls.Add(_button2);

        _chatField.Text = _playerName;
        _chatField.SelectAll();
        _chatField.Focus();
    }

    public delegate void createServerScreenDelegate();

    //creates the screen that allows you to chat with other people and create/find games of stratego
    public void createServerScreen()
    {
        _pendingGame = false;
        _failureScreenShowing = false;
        _loadingForm.Controls.Remove(_chatField);
        _loadingForm.Controls.Remove(_chatBox);
        _loadingForm.Controls.Remove(_textLabel);
        _loadingForm.Controls.Remove(_checkBoxOptionsPanel);
        _loadingForm.Controls.Remove(_optionsLabel);
        _loadingForm.Controls.Remove(_playerNamesBox);
        _loadingForm.Controls.Remove(_backgroundPanel);
        _loadingForm.Controls.Remove(_button1);
        _loadingForm.Controls.Remove(_button2);
        _loadingForm.Controls.Remove(_button3);
        _loadingForm.Controls.Remove(_checkBoxOptions);
        _loadingForm.Controls.Remove(_playerComboBox[0]);
        _loadingForm.Controls.Remove(_playerComboBox[1]);
        _loadingForm.Controls.Remove(_listOfGamesPanel);
        _loadingForm.Controls.Remove(_gameInfoBox);

        _button1.Text = "Create Game";
        _button1.Name = "CREATE_GAME_OPTIONS";
        _button1.Enabled = true;
        _button1.Location = new Point(0, 89);

        _button2.Text = "Find Game";
        _button2.Name = "FIND_GAME";
        _button2.Enabled = true;
        _button2.Location = new Point(0, (89 + _button1.Height));

        _button3.Text = "Exit";
        _button3.Name = "EXIT_SERVER";
        _button3.Location = new Point(0, (89 + _button1.Height + _button2.Height));

        _chatBox.Size = new Size(250, 280);
        _chatBox.Location = new Point(_button1.Width, 0);
        _chatBox.Font = new Font("Times New Roman", 10);
        _chatBox.Text = "";

        _chatField.Size = new Size(250, 35);
        _chatField.Location = new Point(_button1.Width, _chatBox.Height);
        _chatField.Font = new Font("Times New Roman", 10);
        _chatField.Text = "";
        _chatField.KeyDown += new KeyEventHandler(this.chatFieldTextEntered);

        _playerNamesBox.Size = new Size(160, 328);
        _playerNamesBox.Location = new Point((_button1.Width + _chatBox.Width), 0);
        _playerNamesBox.Font = new Font("Times New Roman", 10);
        _playerNamesBox.Text = _clientNames;
        _playerNamesBox.ForeColor = Color.White;
        _playerNamesBox.TextAlign = HorizontalAlignment.Left;

        _loadingForm.Controls.Add(_button1);
        _loadingForm.Controls.Add(_button2);
        _loadingForm.Controls.Add(_button3);
        _loadingForm.Controls.Add(_chatBox);
        _loadingForm.Controls.Add(_chatField);
        _loadingForm.Controls.Add(_playerNamesBox);

        _chatField.Focus();
    }

    public delegate void createServerScreenHostDelegate();

    public void createServerScreenHost()
    {
        _pendingGame = true;

        _checkBoxValues[0] = _checkBoxOptions.GetItemChecked(0);
        _checkBoxValues[1] = _checkBoxOptions.GetItemChecked(1);
        _checkBoxValues[2] = _checkBoxOptions.GetItemChecked(2);

        _loadingForm.Controls.Remove(_chatField);
        _loadingForm.Controls.Remove(_chatBox);
        _loadingForm.Controls.Remove(_textLabel);
        _loadingForm.Controls.Remove(_checkBoxOptionsPanel);
        _loadingForm.Controls.Remove(_optionsLabel);
        _loadingForm.Controls.Remove(_playerNamesBox);
        _loadingForm.Controls.Remove(_backgroundPanel);
        _loadingForm.Controls.Remove(_button1);
        _loadingForm.Controls.Remove(_button2);
        _loadingForm.Controls.Remove(_button3);
        _loadingForm.Controls.Remove(_checkBoxOptions);

        _playerComboBox[0].Location = new Point(0, 0);
        _playerComboBox[0].Text = _playerName;
        _playerComboBox[0].Enabled = false;
        _playerComboBox[1].Location = new Point(0, _playerComboBox[0].Height);
        _playerComboBox[1].Text = "";
        for (int x = 0; x < _playerComboBox[1].Items.Count; x++)
        {
            _playerComboBox[1].Items.RemoveAt(x);
        }
        _playerComboBox[1].Enabled = false;

        _checkBoxOptionsPanel.Size = new Size(256, 140);
        _checkBoxOptionsPanel.Location = new Point(_playerComboBox[0].Width + 2, 0);

        _optionsLabel.Location = new Point(_playerComboBox[0].Width + 4, 2);
        _optionsLabel.Text = _gameName + " Options:";

        _checkBoxOptions.Location = new Point(_playerComboBox[0].Width + 4, (2 + _optionsLabel.Height));
        _checkBoxOptions.Enabled = false;

        _chatBox.Size = new Size(254, 216);
        _chatBox.Location = new Point(0, (_playerComboBox[0].Height + _playerComboBox[1].Height));
        _chatBox.Font = new Font("Times New Roman", 10);
        _chatBox.Text = "";

        _chatField.Size = new Size(254, 35);
        _chatField.Location = new Point(0, (_playerComboBox[0].Height + _playerComboBox[1].Height + _chatBox.Height));
        _chatField.Font = new Font("Times New Roman", 10);
        _chatField.Text = "";
        _chatField.KeyDown += new KeyEventHandler(this.chatFieldTextEntered);

        _button1.Text = "Start Game";
        _button1.Name = "START_GAME";
        _button1.Location = new Point((78 + _chatBox.Width), (44 + _checkBoxOptionsPanel.Height));

        _button2.Text = "Cancel";
        _button2.Name = "CANCEL_PENDING_GAME";
        _button2.Location = new Point((78 + _chatBox.Width), (44 + _checkBoxOptionsPanel.Height + _button1.Height));

        _loadingForm.Controls.Add(_playerComboBox[0]);
        _loadingForm.Controls.Add(_playerComboBox[1]);
        _loadingForm.Controls.Add(_checkBoxOptions);
        _loadingForm.Controls.Add(_optionsLabel);
        _loadingForm.Controls.Add(_checkBoxOptionsPanel);
        _loadingForm.Controls.Add(_chatBox);
        _loadingForm.Controls.Add(_chatField);
        _loadingForm.Controls.Add(_button1);
        _loadingForm.Controls.Add(_button2);

        _chatField.Focus();
    }

    public delegate void createServerScreenClientDelegate(String gameName, bool[] checkBoxValues);

    public void createServerScreenClient(String gameName, bool[] checkBoxValues)
    {
        _pendingGame = true;
        _refreshTimer.Stop();
        _gameName = gameName;

        for (int x = 0; x < checkBoxValues.Length; x++)
        {
            _checkBoxOptions.SetItemChecked(x, checkBoxValues[x]);
            _checkBoxValues[x] = checkBoxValues[x];
        }

        _loadingForm.Controls.Remove(_chatField);
        _loadingForm.Controls.Remove(_chatBox);
        _loadingForm.Controls.Remove(_textLabel);
        _loadingForm.Controls.Remove(_checkBoxOptionsPanel);
        _loadingForm.Controls.Remove(_optionsLabel);
        _loadingForm.Controls.Remove(_playerNamesBox);
        _loadingForm.Controls.Remove(_backgroundPanel);
        _loadingForm.Controls.Remove(_button1);
        _loadingForm.Controls.Remove(_button2);
        _loadingForm.Controls.Remove(_button3);
        _loadingForm.Controls.Remove(_checkBoxOptions);
        _loadingForm.Controls.Remove(_playerComboBox[0]);
        _loadingForm.Controls.Remove(_playerComboBox[1]);
        _loadingForm.Controls.Remove(_listOfGamesPanel);
        _loadingForm.Controls.Remove(_gameInfoBox);

        _playerComboBox[0].Location = new Point(0, 0);
        _playerComboBox[0].Enabled = false;
        _playerComboBox[1].Location = new Point(0, _playerComboBox[0].Height);
        _playerComboBox[1].Enabled = false;

        _checkBoxOptionsPanel.Size = new Size(256, 140);
        _checkBoxOptionsPanel.Location = new Point(_playerComboBox[0].Width + 2, 0);

        _optionsLabel.Location = new Point(_playerComboBox[0].Width + 4, 2);
        _optionsLabel.Text = _gameName + " Options:";

        _checkBoxOptions.Location = new Point(_playerComboBox[0].Width + 4, (2 + _optionsLabel.Height));
        _checkBoxOptions.Enabled = false;

        _chatBox.Size = new Size(254, 216);
        _chatBox.Location = new Point(0, (_playerComboBox[0].Height + _playerComboBox[1].Height));
        _chatBox.Font = new Font("Times New Roman", 10);
        _chatBox.Text = "";

        _chatField.Size = new Size(254, 35);
        _chatField.Location = new Point(0, (_playerComboBox[0].Height + _playerComboBox[1].Height + _chatBox.Height));
        _chatField.Font = new Font("Times New Roman", 10);
        _chatField.Text = "";
        _chatField.KeyDown += new KeyEventHandler(this.chatFieldTextEntered);

        _button1.Text = "Start Game";
        _button1.Name = "NULL";
        _button1.Enabled = false;
        _button1.Location = new Point((78 + _chatBox.Width), (44 + _checkBoxOptionsPanel.Height));

        _button2.Text = "Cancel";
        _button2.Name = "LEAVE_PENDING_GAME";
        _button2.Enabled = true;
        _button2.Location = new Point((78 + _chatBox.Width), (44 + _checkBoxOptionsPanel.Height + _button1.Height));

        _loadingForm.Controls.Add(_playerComboBox[0]);
        _loadingForm.Controls.Add(_playerComboBox[1]);
        _loadingForm.Controls.Add(_checkBoxOptions);
        _loadingForm.Controls.Add(_optionsLabel);
        _loadingForm.Controls.Add(_checkBoxOptionsPanel);
        _loadingForm.Controls.Add(_chatBox);
        _loadingForm.Controls.Add(_chatField);
        _loadingForm.Controls.Add(_button1);
        _loadingForm.Controls.Add(_button2);

        _chatField.Focus();
    }

    public void createFindGameScreen()
    {
        for (int x = 0; x < _strategoButtons.Count; x++)
        {
            _listOfGamesPanel.Controls.Remove((Button)_strategoButtons[x]);
        }
        _checkBoxOptions.SetItemChecked(0, false);
        _checkBoxOptions.SetItemChecked(1, true);
        _checkBoxOptions.SetItemChecked(2, true);
        _checkBoxOptions.SetItemChecked(3, false);

        _loadingForm.Controls.Remove(_chatField);
        _loadingForm.Controls.Remove(_chatBox);
        _loadingForm.Controls.Remove(_textLabel);
        _loadingForm.Controls.Remove(_playerNamesBox);
        _loadingForm.Controls.Remove(_backgroundPanel);
        _loadingForm.Controls.Remove(_button1);
        _loadingForm.Controls.Remove(_button2);
        _loadingForm.Controls.Remove(_button3);

        _listOfGamesPanel.Size = new Size(154, 328);
        _listOfGamesPanel.Location = new Point(0, 0);

        _gameInfoBox.Text = "Please select a game" + "\r\n\r\nHost: " + "\r\n\r\nGameName: ";
        _gameInfoBox.Location = new Point(_listOfGamesPanel.Width, 0);
        _gameInfoBox.Font = new Font("Arial", 15);
        _gameInfoBox.Size = new Size(256, 140);
        _gameInfoBox.TextAlign = HorizontalAlignment.Center;

        _checkBoxOptionsPanel.Size = new Size(256, 140);
        _checkBoxOptionsPanel.Location = new Point(_listOfGamesPanel.Width, _gameInfoBox.Height);

        _optionsLabel.Location = new Point((2 + _listOfGamesPanel.Width), (2 + _gameInfoBox.Height));
        _optionsLabel.Text = _gameName + " Options:";

        _checkBoxOptions.Location = new Point((2 + _listOfGamesPanel.Width), (2 + _optionsLabel.Height + _gameInfoBox.Height));
        _checkBoxOptions.Enabled = false;

        _button1.Text = "Join Game";
        _button1.Name = "JOIN_PENDING_GAME";
        _button1.Location = new Point((2 + _listOfGamesPanel.Width + _checkBoxOptionsPanel.Width), 89);

        _button2.Text = "Refresh";
        _button2.Name = "REFRESH_GAMES";
        _button2.Enabled = false;
        _button2.Location = new Point((2 + _listOfGamesPanel.Width + _checkBoxOptionsPanel.Width), (89 + _button1.Height));

        _button3.Text = "Cancel";
        _button3.Name = "CANCEL_FIND_GAME";
        _button3.Location = new Point((2 + _listOfGamesPanel.Width + _checkBoxOptionsPanel.Width), (89 + _button1.Height + _button2.Height));

        _loadingForm.Controls.Add(_listOfGamesPanel);
        _loadingForm.Controls.Add(_gameInfoBox);
        _loadingForm.Controls.Add(_optionsLabel);
        _loadingForm.Controls.Add(_checkBoxOptions);
        _loadingForm.Controls.Add(_checkBoxOptionsPanel);
        _loadingForm.Controls.Add(_button1);
        _loadingForm.Controls.Add(_button2);
        _loadingForm.Controls.Add(_button3);

        _refreshTimer.Start();
    }

    //creates the screen that allows you to create a game of stratego
    public void createCreateGameOptionsScreen(String message)
    {
        _checkBoxValues[0] = false;
        _checkBoxValues[1] = true;
        _checkBoxValues[2] = true;
        _loadingForm.Controls.Remove(_chatField);
        _loadingForm.Controls.Remove(_chatBox);
        _loadingForm.Controls.Remove(_textLabel);
        _loadingForm.Controls.Remove(_playerNamesBox);
        _loadingForm.Controls.Remove(_backgroundPanel);
        _loadingForm.Controls.Remove(_button1);
        _loadingForm.Controls.Remove(_button2);
        _loadingForm.Controls.Remove(_button3);

        _chatField.Size = new Size(280, 35);
        _chatField.Location = new Point(115, 0);
        _chatField.Font = new Font("Times New Roman", 12);
        _chatField.BackColor = Color.Black;
        _chatField.ForeColor = Color.White;
        _chatField.KeyDown -= new KeyEventHandler(this.chatFieldTextEntered);

        _textLabel.Size = new Size(280, 30);
        _textLabel.Font = new Font("Times New Roman", 12);
        _textLabel.Location = new Point(115, (0 + _chatField.Height));
        _textLabel.ForeColor = Color.Red;
        _textLabel.Text = message;

        _checkBoxOptionsPanel.Size = new Size(256, 140);
        _checkBoxOptionsPanel.Location = new Point(127, (0 + _chatField.Height + _textLabel.Height));

        _optionsLabel.Location = new Point(130, (2 + _chatField.Height + _textLabel.Height));
        _optionsLabel.Text = "Game Options:";

        _checkBoxOptions.Location = new Point(130, (2 + _chatField.Height + _textLabel.Height + _optionsLabel.Height));
        _checkBoxOptions.Enabled = true;
        _checkBoxOptions.SetItemChecked(0, false);
        _checkBoxOptions.SetItemChecked(1, true);
        _checkBoxOptions.SetItemChecked(2, true);
        _checkBoxOptions.SetItemChecked(3, false);

        _button1.Text = "Create Game";
        _button1.Name = "CREATE_GAME";
        _button1.Location = new Point(205, (4 + _chatField.Height + _textLabel.Height + _checkBoxOptionsPanel.Height));

        _button2.Text = "Cancel";
        _button2.Name = "CANCEL_TO_SERVERSCREEN";
        _button2.Location = new Point(205, (4 + _chatField.Height + _textLabel.Height + _checkBoxOptionsPanel.Height + _button1.Height));

        _loadingForm.Controls.Add(_button1);
        _loadingForm.Controls.Add(_button2);
        _loadingForm.Controls.Add(_chatField);
        _loadingForm.Controls.Add(_textLabel);
        _loadingForm.Controls.Add(_checkBoxOptions);
        _loadingForm.Controls.Add(_optionsLabel);
        _loadingForm.Controls.Add(_checkBoxOptionsPanel);

        _chatField.Text = "";
        _chatField.Focus();
    }

    public delegate void createFailureScreenDelegate(String reason);

    //creates the screen that involves server errors or failures
    public void createFailureScreen(String reason)
    {
        _clientNames = "";
        _failureScreenShowing = true;
        _strategoClient = null;
        _loadingForm.Controls.Remove(_chatField);
        _loadingForm.Controls.Remove(_chatBox);
        _loadingForm.Controls.Remove(_textLabel);
        _loadingForm.Controls.Remove(_playerNamesBox);
        _loadingForm.Controls.Remove(_backgroundPanel);
        _loadingForm.Controls.Remove(_button1);
        _loadingForm.Controls.Remove(_button2);
        _loadingForm.Controls.Remove(_button3);

        _chatField.Size = new Size(280, 35);
        _chatField.Location = new Point(115 + 0);
        _chatField.Font = new Font("Arial", 15);
        _chatField.BackColor = Color.Black;
        _chatField.ForeColor = Color.White;
        _chatField.KeyDown -= new KeyEventHandler(this.chatFieldTextEntered);

        _textLabel.Size = new Size(280, 70);
        _textLabel.Font = new Font("Arial", 15);
        _textLabel.Location = new Point(115, (0 + _chatField.Height + 40));
        _textLabel.ForeColor = Color.Red;
        _textLabel.Text = reason;

        _button1.Text = "Join Server";
        _button1.Name = "JOIN_SERVER";
        _button1.Location = new Point(205, (0 + _chatField.Height + 45 + _textLabel.Height));

        _button2.Text = "Cancel";
        _button2.Name = "CANCEL_TO_LOADINGSCREEN";
        _button2.Location = new Point(205, (0 + _chatField.Height + 45 + _textLabel.Height + _button1.Height));

        _loadingForm.Controls.Add(_button1);
        _loadingForm.Controls.Add(_button2);
        _loadingForm.Controls.Add(_textLabel);
        _loadingForm.Controls.Add(_chatField);

        _chatField.Text = _playerName;
        _chatField.Focus();
        _chatField.SelectAll();
    }

    //creates the screen that loads the solo player game
    private void createSoloScreen()
    {
        _loadingForm.Controls.Remove(_chatField);
        _loadingForm.Controls.Remove(_textLabel);
        _loadingForm.Controls.Remove(_backgroundPanel);
        _loadingForm.Controls.Remove(_button1);
        _loadingForm.Controls.Remove(_button2);

        _checkBoxOptionsPanel.Size = new Size(256, 140);
        _checkBoxOptionsPanel.Location = new Point(127, 46);

        _optionsLabel.Location = new Point(130, 48);
        _optionsLabel.Text = "Variants:";

        _checkBoxOptions.Location = new Point(130, (48 + _optionsLabel.Height));
        _checkBoxOptions.Enabled = true;
        _checkBoxOptions.SetItemChecked(0, false);
        _checkBoxOptions.SetItemChecked(1, true);
        _checkBoxOptions.SetItemChecked(2, true);
        _checkBoxOptions.SetItemChecked(3, false);

        _button1.Text = "Start";
        _button1.Name = "SOLO_START";
        _button1.Location = new Point(205, (50 + _checkBoxOptionsPanel.Height));

        _button2.Text = "Cancel";
        _button2.Name = "CANCEL_TO_LOADINGSCREEN";
        _button2.Location = new Point(205, (50 + _checkBoxOptionsPanel.Height + _button1.Height));

        _loadingForm.Controls.Add(_checkBoxOptions);
        _loadingForm.Controls.Add(_button1);
        _loadingForm.Controls.Add(_button2);
        _loadingForm.Controls.Add(_optionsLabel);
        _loadingForm.Controls.Add(_checkBoxOptionsPanel);
    }

    public void setPlayerNamesBox(String playerNames)
    {
        _playerNamesBox.Text = null;
        _playerNamesBox.Text = playerNames;
        _clientNames = playerNames;
    }

    public delegate void setFindGameInfoBoxDelegate(String info);

    public void setFindGameInfoBox(String info)
    {
        int index = -1;
        for (int x = 0; x < _strategoGames.Count; x++)
        {
            if (_gameName.CompareTo(((StrategoGame)_strategoGames[x])._gameName) == 0)
            {
                _listOfGamesPanel.Controls.Remove((Button)_strategoButtons[x]);
                _strategoButtons.RemoveAt(x);
                index = x;
                x = _strategoGames.Count;
            }
        }

        if (index != -1)
        {
            for (int x = index; x < _strategoButtons.Count; x++)
            {
                ((Button)_strategoButtons[x]).Location = new Point(((Button)_strategoButtons[x]).Location.X, (((Button)_strategoButtons[x]).Location.Y - 50));
            }
        }

        _gameName = "";
        _gameInfoBox.Text = info;
        _checkBoxOptions.SetItemChecked(0, false);
        _checkBoxOptions.SetItemChecked(1, true);
        _checkBoxOptions.SetItemChecked(2, true);
    }

    public delegate void createStrategoGameButtonsDelegate(ArrayList gameNames, ArrayList hostNames, ArrayList checkBoxValues);

    public void createStrategoGameButtons(ArrayList gameNames, ArrayList hostNames, ArrayList checkBoxValues)
    {
        for (int x = 0; x < _strategoButtons.Count; x++)
        {
            _listOfGamesPanel.Controls.Remove((Button)_strategoButtons[x]);
        }
        _strategoButtons = new ArrayList();
        _strategoGames = new ArrayList();

        for (int x = 0; x < gameNames.Count; x++)
        {
            _strategoGames.Add(new StrategoGame((String)gameNames[x], (String)hostNames[x], (bool[])checkBoxValues[x]));
            Button button = new Button();
            button.Text = (String)gameNames[x];
            button.Name = "GET_GAME_INFO";
            button.Visible = true;
            button.BackColor = Color.White;
            button.ForeColor = Color.Black;
            button.Size = new Size(100, 50);
            button.Location = new Point(27, (0 + (x * 50)));
            button.Click += new System.EventHandler(this.buttonEvent);
            _strategoButtons.Add(button);
            _listOfGamesPanel.Controls.Add(button);
        }

        bool noneSelected = true;
        if (_gameName.CompareTo("") == 0)
        {
            for (int x = 0; x < _strategoGames.Count; x++)
            {
                if (_gameName.CompareTo(((StrategoGame)_strategoGames[x])._gameName) == 0)
                {
                    _gameName = ((StrategoGame)_strategoGames[x])._gameName;
                    _gameInfoBox.Text = "Game Selected\r\n\r\n" + "Game: " + _gameName + "\r\n\r\nHost: " + ((StrategoGame)_strategoGames[x])._hostName;
                    _checkBoxOptions.SetItemChecked(0, ((StrategoGame)_strategoGames[x])._checkBoxValues[0]);
                    _checkBoxOptions.SetItemChecked(1, ((StrategoGame)_strategoGames[x])._checkBoxValues[1]);
                    _checkBoxOptions.SetItemChecked(2, ((StrategoGame)_strategoGames[x])._checkBoxValues[2]);
                    x = _strategoGames.Count;
                    noneSelected = false;
                }
            }
        }

        if (noneSelected == true)
        {
            _gameName = "";
            _gameInfoBox.Text = "No Game Selected\r\n\r\n" + "Game: " + "\r\n\r\nHost: ";
            _checkBoxOptions.SetItemChecked(0, false);
            _checkBoxOptions.SetItemChecked(1, false);
        }
    }

    public void setFailureScreenMessage(String reason)
    {
        _textLabel.Text = reason;
    }

    public Form getLoadingForm()
    {
        return _loadingForm;
    }

    public bool[] getCheckBoxValues()
    {
        _checkBoxValues[0] = _checkBoxOptions.GetItemChecked(0);
        _checkBoxValues[1] = _checkBoxOptions.GetItemChecked(1);
        _checkBoxValues[2] = _checkBoxOptions.GetItemChecked(2);
        return _checkBoxValues;
    }

    public TextBox getChatBox()
    {
        return _chatBox;
    }

    public Socket getBindingSocket()
    {
        return _bindingSocket;
    }

    public void setPlayerBooting(bool value)
    {
        _playerComboBox[1].Enabled = value;
    }

    public delegate void setPlayerLabelsDelegate(ArrayList playerNames);

    public void setPlayerLabels(ArrayList playerNames)
    {
        if (playerNames != null)
        {
            for (int x = 0; x < playerNames.Count; x++)
            {
                //does not add boot command to host name
                if (x > 0)
                {
                    _playerComboBox[x].Items.Add("Boot " + (String)playerNames[x]);
                }
                _playerComboBox[x].Text = (String)playerNames[x];
            }
            for (int x = playerNames.Count; x < 2; x++)
            {
                _playerComboBox[x].Items.RemoveAt(0);
                _playerComboBox[x].Text = "";
                _playerComboBox[x].Enabled = false;
            }
        }
    }

    public bool isFailureScreenShowing()
    {
        _strategoClient = null;
        return _failureScreenShowing;
    }

    private void refreshFindGame(object sender, EventArgs e)
    {
        _refreshTimer.Stop();
        _button2.Enabled = true;
    }

    public void setChatBoxText(String playerName, String message)
    {
        _chatBox.AppendText(playerName + ": " + message + "\n");
    }

    //paints the background image onto a panel
    private void paintBackground(object sender, PaintEventArgs e)
    {
        Graphics g = e.Graphics;
        g.DrawImage(_backgroundImage, new Point(0, 0));
        g.Dispose();
    }

    private void closeLoadingForm(object sender, FormClosingEventArgs args)
    {
        //if this is connected to the server
        if (_strategoClient != null)
        {
            _strategoClient.exitServer();
        }
        System.Environment.Exit(0);
    }

    //when the player presses a key, this checks to see if it was the enter key
    private void chatFieldTextEntered(object sender, KeyEventArgs args)
    {
        //if enter is pressed and the player has entered a message
        if (args.KeyCode == Keys.Enter && _chatField.Text.CompareTo("") != 0)
        {
            if (_pendingGame == true)
            {
                _strategoClient.writeToPendingGameChatArea(_playerName, _chatField.Text);
            }
            else
            {
                _strategoClient.writeToServerChatArea(_playerName, _chatField.Text);
            }
            _chatField.Text = "";
            args.SuppressKeyPress = true;
        }
    }

    public void bootPlayer(object sender, EventArgs e)
    {
        if (((ComboBox)sender).Name.CompareTo("BOOT_PLAYER_1") == 0)
        {
            _strategoClient.bootPlayer();
            _chatField.Focus();
        }
    }

    public delegate void startGameDelegate(String opponentsName);

    public void startGame(String opponentsName)
    {
        _loadingForm.Controls.Remove(_chatField);
        _loadingForm.Controls.Remove(_chatBox);
        _loadingForm.Controls.Remove(_textLabel);
        _loadingForm.Controls.Remove(_checkBoxOptionsPanel);
        _loadingForm.Controls.Remove(_optionsLabel);
        _loadingForm.Controls.Remove(_playerNamesBox);
        _loadingForm.Controls.Remove(_backgroundPanel);
        _loadingForm.Controls.Remove(_button1);
        _loadingForm.Controls.Remove(_button2);
        _loadingForm.Controls.Remove(_button3);
        _loadingForm.Controls.Remove(_checkBoxOptions);

        _loadingForm.Hide();

        new GameLogic(_playerName, opponentsName, false, _checkBoxValues, _checkBoxOptions.GetItemChecked(3), _strategoClient, this);
    }

    //deals with button press events
    private void buttonEvent(object sender, EventArgs args)
    {
        //if they clicked the start multiplayer game button
        if (((Button)sender).Name.CompareTo("START_GAME") == 0)
        {
            _chatField.Focus();
            _strategoClient.startPendingGame();
        }
        //if they clicked the start solo game button
        else if (((Button)sender).Name.CompareTo("SOLO_START") == 0)
        {
            _loadingForm.Controls.Remove(_checkBoxOptions);
            _loadingForm.Controls.Remove(_button1);
            _loadingForm.Controls.Remove(_button2);

            _loadingForm.Hide();

            _checkBoxValues[0] = _checkBoxOptions.GetItemChecked(0);
            _checkBoxValues[1] = _checkBoxOptions.GetItemChecked(1);
            _checkBoxValues[2] = _checkBoxOptions.GetItemChecked(2);

            new GameLogic(_playerName, "Computer", true, _checkBoxValues, _checkBoxOptions.GetItemChecked(3), null, this); 
        }
        //if they clicked the join server button
        else if(((Button)sender).Name.CompareTo("JOIN_SERVER") == 0)
        {
            //if the player has entered a name
            if (_chatField.Text.CompareTo("") != 0)
            {
                _playerName = _chatField.Text;
                _strategoClient = new StrategoClient(this);
                _strategoClient.connectToHost();
                //if the client is now connected to the server
                if (_strategoClient != null && _strategoClient.isSocketConnected() == true)
                {
                    Thread newThread = new Thread(new ThreadStart(_strategoClient.run));
                    newThread.Start();
                    _strategoClient.checkNameValidation(_playerName);
                }
                //if it could not connect to the server
                else
                {
                    _chatField.SelectAll();
                    _chatField.Focus();
                }
            }
            //if they have not entered a name
            else
            {
                _chatField.Focus();
            }
        }
        //if they clicked on the create game button
        else if (((Button)sender).Name.CompareTo("CREATE_GAME") == 0)
        {
            //if the player has entered a game name
            if (_chatField.Text.CompareTo("") != 0)
            {
                _gameName = _chatField.Text;
                _strategoClient.createPendingGame(_gameName);
            }
            _chatField.Focus();
        }
        //if they clicked on the create game options button
        else if (((Button)sender).Name.CompareTo("CREATE_GAME_OPTIONS") == 0)
        {
            this.createCreateGameOptionsScreen("Enter name of game");
        }
        //if they clicked on the join game button
        else if (((Button)sender).Name.CompareTo("JOIN_PENDING_GAME") == 0)
        {
            //if they have selected a game
            if (_gameName.CompareTo("") != 0)
            {
                _strategoClient.joinPendingGame(_gameName);
            }
            //if they have not yet selected a game
            else
            {
                _gameName = "";
                _gameInfoBox.Text = "No Game Selected\r\n\r\n" + "Game: " + "\r\n\r\nHost: ";
                _checkBoxOptions.SetItemChecked(0, false);
                _checkBoxOptions.SetItemChecked(1, false);
            }
        }
        //if they clicked on the join game button
        else if (((Button)sender).Name.CompareTo("LEAVE_PENDING_GAME") == 0)
        {
            _strategoClient.leavePendingGame();
            _chatBox.Text = "";
            this.createServerScreen();
        }
        //if they clicked on the find game button
        else if (((Button)sender).Name.CompareTo("FIND_GAME") == 0)
        {
            this.createFindGameScreen();
            _strategoClient.getListOfStrategoGames();
        }
        //if they clicked on the refresh game button
        else if (((Button)sender).Name.CompareTo("REFRESH_GAMES") == 0)
        {
            _button2.Enabled = false;
            _strategoClient.getListOfStrategoGames();
            _refreshTimer.Start();
        }
        //if they clicked on the exit server button
        else if (((Button)sender).Name.CompareTo("EXIT_SERVER") == 0)
        {
            _strategoClient.exitServer();
            _strategoClient = null;
            this.createLoadingScreen();
        }
        //if they clicked cancel to the server screen
        else if (((Button)sender).Name.CompareTo("CANCEL_PENDING_GAME") == 0)
        {
            _strategoClient.cancelPendingGame(_gameName);
        }
        //if they clicked cancel to the server screen
        else if (((Button)sender).Name.CompareTo("CANCEL_FIND_GAME") == 0)
        {
            _button2.Enabled = false;
            _refreshTimer.Stop();

            _gameName = "";
            this.createServerScreen();
        }
        //if they clicked cancel to the loading screen
        else if (((Button)sender).Name.CompareTo("CANCEL_TO_LOADINGSCREEN") == 0)
        {
            this.createLoadingScreen();
        }
        //if they clicked cancel to the server screen
        else if (((Button)sender).Name.CompareTo("CANCEL_TO_SERVERSCREEN") == 0)
        {
            this.createServerScreen();
        }
        //if they clicked a game info button
        else if (((Button)sender).Name.CompareTo("GET_GAME_INFO") == 0)
        {
            for (int x = 0; x < _strategoButtons.Count; x++)
            {
                if (((Button)sender).Equals((Button)_strategoButtons[x]) == true)
                {
                    _gameName = ((StrategoGame)_strategoGames[x])._gameName;
                    _gameInfoBox.Text = "Game Selected\r\n\r\n" + "Game: " + _gameName + "\r\n\r\nHost: " + ((StrategoGame)_strategoGames[x])._hostName;
                    _checkBoxOptions.SetItemChecked(0, ((StrategoGame)_strategoGames[x])._checkBoxValues[0]);
                    _checkBoxOptions.SetItemChecked(1, ((StrategoGame)_strategoGames[x])._checkBoxValues[1]);
                    _checkBoxOptions.SetItemChecked(2, ((StrategoGame)_strategoGames[x])._checkBoxValues[2]);
                    x = _strategoButtons.Count;
                }
            }
        }
        //if they clicked the solo game button
        else if (((Button)sender).Name.CompareTo("SOLO_GAME") == 0)
        {
            //if the player has entered a name
            if (_chatField.Text.CompareTo("") != 0)
            {
                _playerName = _chatField.Text;
                this.createSoloScreen();
            }
            //if they have not entered a name
            else
            {
                _chatField.Focus();
            }
        }
    }

    public class StrategoGame
    {
        public bool[] _checkBoxValues = new bool[3];
        public String _gameName, _hostName;

        public StrategoGame(String gameName, String hostName, bool[] checkBoxValues)
        {
            _gameName = gameName;
            _hostName = hostName;
            for (int x = 0; x < _checkBoxValues.Length; x++)
            {
                _checkBoxValues[x] = checkBoxValues[x];
            }
        }
    }

    public static void Main()
    {
        Socket bindingSocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
        System.Net.IPEndPoint localIP = new System.Net.IPEndPoint(System.Net.IPAddress.Any, 4569);
        try
        {
            //bindingSocket.Bind(localIP);
            new LoadingScreen("", bindingSocket);
        }
        catch
        {
            MessageBox.Show(null, "Only one instance of Stratego can be running." + "\n ", "Multiple Instances", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
        }
    }
}