﻿using System.Collections;

public class BoardSquare
{
    private ArrayList _oneMoveSquares;
    private int _index;
    private Piece _piece=null;

    public BoardSquare(int index)
    {
        _index = index;
    }

    //sets the piece for the current square
    public void setPiece(Piece newPiece)
    {
        _piece = newPiece;
    }

    public Piece getPiece()
    {
        return _piece;
    }

    //returns the index of this square
    public int getIndex()
    {
        return _index;
    }

    //sets the possible adjacent moves for a piece in this square
    public void setOneMoveSquares(BoardSquare[] oneMoveSquares)
    {
        _oneMoveSquares = new ArrayList(oneMoveSquares.Length);
        for (int x = 0; x < oneMoveSquares.Length; x++)
        {
            _oneMoveSquares.Add(oneMoveSquares[x]);
        }
    }

    //returns the array of squares one square away from this square
    public ArrayList getOneMoveSquares()
    {
        return _oneMoveSquares;
    }
}