/*
* Program: DCCL.c
*
* Description: A client that sends read and write commands to a server that is mimicking a physical disk system.
*
* "DCCL"
*
* To execute:
*
* From command line type: ./DCCL <ipAddress>
* where <ipAddress> is the IP Address of the server you want to connect to
*
*
* Written by: Chuck Laderer
* Date last edited: November 16, 2009
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sstream>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define SIZE 1024
#define TIME_PORT 50152

//port ranges: 50150-50159

int main(int argc, char *argv[])
{
	//if there are not 2 arguments
	if(argc != 2)
	{
		printf("Error: Not enough arguments\n");
		exit(-1);
	}

	int sockfd, nread;
	struct sockaddr_in serv_addr;
	struct hostent *host;

	//create endpoint
	if((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
		fprintf(stderr, "Error opening socket\n");
		perror(NULL);
		exit(2);
	}

	//connect to server
	serv_addr.sin_family = AF_INET;
	host = gethostbyname(argv[1]);
	memcpy(&serv_addr.sin_addr.s_addr, host->h_addr, host->h_length);
	serv_addr.sin_port = htons(TIME_PORT);

	if(connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0)
	{
		fprintf(stderr, "Error accepting connection\n");
		perror(NULL);
		exit(3);
	}

	//while program is running
	while(true)
	{
		char userInput[100], buf[SIZE];

		//reads the entered input
		if(fgets(userInput, sizeof userInput, stdin) != NULL)
		{
			char *newline = strchr(userInput, '\n');
			//if it is not null
			if(newline != NULL)
			{
				*newline = '\0';
			}
		}

		//transfer user inputed request
		write(sockfd, userInput, (strlen(userInput) + 1));

		//if the user enters 'exit'
		if(strcmp(userInput, "exit") == 0)
		{
			close(sockfd);
			exit(0);
		}

		//read reversed string
		nread = read(sockfd, buf, SIZE);

		fprintf(stderr, "%s\n", buf);
	}
}
