/*
* Program: lsServer.c
*
* Description: Creates a server that accepts client connections and processes any ex commands given to it by the client
*
* "lsServer"
*
* To execute:
*
* From command line type: lsServer
*
* Written by: Chuck Laderer
* Date last edited: November 16, 2009
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <string.h>
#include <sstream>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <signal.h>
#include <pthread.h>
#include <ctype.h>

#define SIZE 1024
char buf[SIZE], dummyBuf[SIZE];

#define TIME_PORT 50151

//port ranges: 50150-50159

/*
*
* Parameters:
*
* line must be a char array
* command_array[] must be a pointer to a char array
*/
int parseLine(char *line, char *command_array[])
{
	char *p;
	int count = 0;
	p = strtok(line, " ");
	while(p && strcmp(p, "\n") != 0)
	{
		command_array[count] = p;
		count++;
		p = strtok(NULL, " ");
	}
	return count;
}

int main(int argc, char *argv[])
{
	//if there is 1 argument
	if(argc == 1)
	{
		int sockfd, client_sockfd, nread;
		socklen_t len;

		struct sockaddr_in serv_addr, client_addr;

		//create endpoint
		if((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		{
			fprintf(stderr, "Error opening socket\n");
			exit(2);
		}

		//bind address
		serv_addr.sin_family = AF_INET;
		serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
		serv_addr.sin_port = htons(TIME_PORT);

		if(bind(sockfd, (sockaddr*)&serv_addr, sizeof(serv_addr)) < 0)
		{
			fprintf(stderr, "Error binding socket\n");
			exit(3);
		}

		//specify queue
		listen(sockfd, 5);
		for(;;)
		{
			len = sizeof(client_addr);
			client_sockfd = accept(sockfd, (sockaddr*)&client_addr, &len);
			if(client_sockfd == -1)
			{
				fprintf(stderr, "Error accepting connection\n");
				continue;
			}

			//read client string
			read(client_sockfd, buf, SIZE);

			/*//reverse the string
			int y=0;
			for(int x=(strlen(buf)-1); x>=0; x--)
			{
				dummyBuf[y] = buf[x];
				y++;
			}*/

			char *command_array[100], *command_arrayB[100];

			/*//reads the entered input
			if(buf != NULL)
			{
				char *newline = strchr(buf, '\n');
				//if it is not null
				if(newline != NULL)
				{
					*newline = '\0';
				}
			}*/

			int count = parseLine(buf, command_array);

			//check to see if the pipe is in a bad spot in the command array
			bool pipeError = (strcmp(command_array[0], "|") == 0 || strcmp(command_array[count-1], "|") == 0);
			bool hasPipe=false;
			int pipeIndex=-1;

			//loops through the command_array to determine if there is a pipe
			for(int x=0; x<count; x++)
			{
				//if this command is a pipe
				if(strcmp(command_array[x], "|") == 0)
				{
					command_array[x] = NULL;
					hasPipe = true;
				}

				//if the pipe command is found
				if(hasPipe == true)
				{
					//if the pipeIndex has already been incremented
					if(pipeIndex != -1)
					{
						command_arrayB[pipeIndex] = command_array[x];
						command_array[x] = NULL;
					}
					pipeIndex++;
				}
			}
				
			//if the pipe command is the first or last command
			if(pipeError == true)
			{
				printf("Error: bad pipe command placement\n");
			}
			//if the pipe command is not the first or last command
			else
			{					
				//if there us a pipe command
				if(hasPipe == true)
				{
					int myPipe[2];
			
					if(pipe(myPipe))
					{
						printf("Error: Pipe failed.\n");
						exit(-1);
					}

					pid_t child1PID = fork();

					//checks to see if the child1PID is a child or parent process
					switch(child1PID)
					{
						case -1: //an error has occured in the fork attempt
							printf("Error: Failed to fork a child.\n"); 
							break;
						case 0: //this is the child process
							close(myPipe[0]);
							close(1);

							dup2(myPipe[1], STDOUT_FILENO);
							close(myPipe[1]);

							if(execvp(command_array[0], command_array) == -1)
							{
								printf("Error: running command: '%s'\n", buf);
							}
							break;
						default: //this is the parent process
							pid_t child2PID = fork();

							//checks to see if the child2PID is a child or parent process
							switch(child2PID)
							{
								case -1: //an error has occured in the fork attempt
									printf("Error: Failed to fork a child.\n");
									break;
								case 0: //this is the child process
									close(myPipe[1]);
									close(0);

									dup2(myPipe[0], STDIN_FILENO);
									close(myPipe[0]);

									if(execvp(command_arrayB[0], command_arrayB) == -1)
									{
										printf("Error: running command: '%s'\n", buf);
									}
									break;
								default: //this is the parent process
									//close pipes
									close(myPipe[0]);
									close(myPipe[1]);

									waitpid(child2PID, NULL, 0);

									break;
							}

							waitpid(child1PID, NULL, 0);

							break;
					}
				}
				//if there are no pipes
				else
				{
					command_array[count] = NULL;
					pid_t ChildPID = fork();

					//checks to see if the pid_t is a child or parent process
					switch(ChildPID)
					{
						case -1: //an error has occured in the fork attempt
							printf("Error: Failed to fork a child.\n"); 
							break;
						case 0: //this is the child process
							//if the command cannot be executed
							if(execvp(command_array[0], command_array) == -1)
							{
								printf("Error: running command: '%s'\n", buf);
								exit(-1);
							}
							break;
						default: //this is the parent process
							waitpid(ChildPID, NULL, 0);
							break;
					}
				}
			}


			//write the reversed string back to the client
			write(client_sockfd, dummyBuf, (strlen(dummyBuf) + 1));

			close(client_sockfd);
		}
	}
	//if there is not 1 argument
	else
	{
		printf("Error: Not enough arguments\n");
		exit(-1);
	}
}
