/*
* Program: lsClient.c
*
* Description: Creates a client that connects to a server to write a string to it and receive the reverse of it.
*
* "lsClient"
*
* To execute:
*
* From command line type: lsClient <ipAddress> <command1> <command2>
* where <ipAddress> is the IP Address of the server you want to connect to
* where <command1> is a command for the ls command
* where <command2> is another command for the ls command
*
*
* Written by: Chuck Laderer
* Date last edited: November 16, 2009
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sstream>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define SIZE 1024
char buf[SIZE];

#define TIME_PORT 50151

//port ranges: 50150-50159

int main(int argc, char *argv[])
{
	//if there are 4 arguments
	if(argc == 4)
	{
		int sockfd, nread;
		struct sockaddr_in serv_addr;
		struct hostent *host;

		//create endpoint
		if((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		{
			fprintf(stderr, "Error opening socket\n");
			perror(NULL);
			exit(2);
		}

		//connect to server
		serv_addr.sin_family = AF_INET;
		host = gethostbyname(argv[1]);
		memcpy(&serv_addr.sin_addr.s_addr, host->h_addr, host->h_length);
		serv_addr.sin_port = htons(TIME_PORT);

		if(connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0)
		{
			fprintf(stderr, "Error accepting connection\n");
			perror(NULL);
			exit(3);
		}

		char userInput[100];

		//reads the entered input
		if(fgets(userInput, sizeof userInput, stdin) != NULL)
		{
			char *newline = strchr(userInput, '\n');
			//if it is not null
			if(newline != NULL)
			{
				*newline = '\0';
			}
		}

		fprintf(stderr, "Entered commands: %s\n", userInput);

		//transfer user inputed string
		write(sockfd, userInput, (strlen(userInput) + 1));

		//read reversed string
		nread = read(sockfd, buf, SIZE);

		fprintf(stderr, "Receiving data %s\n", buf);

		close(sockfd);
		exit(0);
	}
	//if there are not 4 arguments
	else
	{
		printf("Error: Not enough arguments\n");
		exit(-1);
	}
}
