/*
* Program: IDSC.c
*
* Description: A client that sends read and write commands to a server that is mimicking a physical disk system.
*
* "IDSC"
*
* To execute:
*
* From command line type: ./IDSC <ipAddress> <numRequests> <scheduler> <bucketSize> <seed>
* where <ipAddress> is the IP Address of the server you want to connect to
* where <numRequests> is the number of commands that are sent to the server
* where <scheduler> is the type of scheduler you want the server to use
* where <bucketSize> is the number of commands you want the server to process of once with the SSTC scheduler
* where <seed> is the number used for the random number generator
*
* Written by: Chuck Laderer
* Date last edited: November 16, 2009
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sstream>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define SIZE 1024
#define TIME_PORT 50153

//port ranges: 50150-50159

int main(int argc, char *argv[])
{
	//if there are not 6 arguments
	if(argc != 6)
	{
		printf("Error: Not enough arguments\n");
		exit(-1);
	}

	int sockfd, nread, numCommands = atoi(argv[2]), c, s;
	struct sockaddr_in serv_addr;
	struct hostent *host;

	srand(atoi(argv[5]));

	//create endpoint
	if((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
		fprintf(stderr, "Error opening socket\n");
		perror(NULL);
		exit(2);
	}

	//connect to server
	serv_addr.sin_family = AF_INET;
	host = gethostbyname(argv[1]);
	memcpy(&serv_addr.sin_addr.s_addr, host->h_addr, host->h_length);
	serv_addr.sin_port = htons(TIME_PORT);

	if(connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0)
	{
		fprintf(stderr, "Error accepting connection\n");
		perror(NULL);
		exit(3);
	}

	char userInput[SIZE] = {0}, buf[SIZE] = {0};

	strcat(userInput, "I\0");

	if(userInput != NULL)
	{
		char *newline = strchr(userInput, '\n');
		//if it is not null
		if(newline != NULL)
		{
			*newline = '\0';
		}
	}

	//writes the information command to the server
	write(sockfd, userInput, (strlen(userInput) + 1));

	//reads the number of cylinders and sectors from the server
	read(sockfd, buf, SIZE);

	c = atoi(strtok(buf, " "));
	s = atoi(strtok(NULL,  " "));

	fprintf(stderr, "Cylinders, Sectors: %i, %i\n", c, s);

	memset(userInput, '\0', sizeof(userInput));

	//adds the user inputed commands to the string
	strcat(userInput, argv[2]);
	strcat(userInput, " ");
	strcat(userInput, argv[3]);
	strcat(userInput, " ");
	strcat(userInput, argv[4]);

	if(userInput != NULL)
	{
		char *newline = strchr(userInput, '\n');
		//if it is not null
		if(newline != NULL)
		{
			*newline = '\0';
		}
	}

	write(sockfd, userInput, (strlen(userInput) + 1));

	//while program is running
	int x=0;
	char output[SIZE] = {0};
	//loops until the requested number of commands has been processed
	while(x < numCommands)
	{
		char cylinder[SIZE] = {0}, sector[SIZE] = {0};
		//a read command
		if((rand() % 2) == 0)
		{
			strcat(output, "R ");
			sprintf(cylinder, "%d", (rand() % c));
			strcat(output, cylinder);
			strcat(output, " ");
			sprintf(sector, "%d", (rand() % s));
			strcat(output, sector);
		}
		//a write command
		else
		{
			strcat(output, "W ");
			sprintf(cylinder, "%d", (rand() % c));
			strcat(output, cylinder);
			strcat(output, " ");
			sprintf(sector, "%d", (rand() % s));
			strcat(output, sector);
			strcat(output, " 1 a");
		}

		strcat(output, " ");

		x++;
	}
	char *newline = strchr(output, '\n');
	//if it is not null
	if(newline != NULL)
	{
		*newline = '\0';
	}
	write(sockfd, output, (strlen(output) + 1));
	read(sockfd, buf, SIZE);

	fprintf(stderr, "Closing Client: %s\n", buf);
	close(sockfd);
	exit(0);
}
