package achievementsystem;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

/**
 * This class extends the JTextPane and creates a new method of appending text that allows you to specify the color of the text.
 */
public class TextPane extends JTextPane{
	private static final long serialVersionUID = 1L;

	/**
	 * Creates a pane where text can be put.
	 */
	public TextPane(){
		this.setEditable(false);
		this.setBackground(Color.BLACK);
	}

	/**
	 * Adds the specified text to this pane. Makes that text the specified color.
	 * @param color = The color to make the message.
	 * @param text = The text to display in this pane.
	 */
	public void append(Color color, String text){
		StyleContext styleContext = StyleContext.getDefaultStyleContext();
		AttributeSet attributeSet = styleContext.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color);
		
		this.setEditable(true);
		this.setCaretPosition(this.getDocument().getLength());
		this.setCharacterAttributes(attributeSet, false);
		this.replaceSelection(text);
		this.setEditable(false);
	}
}