package achievementsystem;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;

/**
 * This class extends the basic JPanel class to allow the achievement icons to not constantly scroll horizontally and instead to wrap upon
 * getting to the edge of the JScrollPane.
 *
 */
public class ScrollPanel extends JPanel implements Scrollable{
	private static final long serialVersionUID = 1L;

	@Override
	public void setBounds(int x, int y, int width, int height){
		super.setBounds(x, y, this.getParent().getWidth(), height);
	}

	@Override
	public Dimension getPreferredSize(){
		return new Dimension(this.getWidth(), this.getPreferredHeight());
	}

	@Override
	public Dimension getPreferredScrollableViewportSize(){
		return super.getPreferredSize();
	}

	@Override
	public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction){
		return 100;
	}

	@Override
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction){
		return orientation == SwingConstants.VERTICAL ? this.getParent().getHeight() : this.getParent().getWidth();
	}

	@Override
	public boolean getScrollableTracksViewportWidth(){
		return true;
	}

	@Override
	public boolean getScrollableTracksViewportHeight(){
		return false;
	}

	/**
	 * Sets the height so that is updates based on the components that are added to this panel.
	 * @return
	 * The preferred height based on components added to this panel.
	 */
	private int getPreferredHeight(){
		int rv = 487;
		for(int x = 0; x < this.getComponentCount(); x++){
			Rectangle r = this.getComponent(x).getBounds();
			int height = r.y + r.height;
			
			if(height + 20 > rv){
				rv = height;
			}
		}
		rv += ((FlowLayout)this.getLayout()).getVgap();
		return rv;
	}
}