package achievementsystem;

public class Player{
	
	private int _attacks=0, _hits=0, _physDmgDone=0, _physDmgTaken=0, _spellDmgDone=0, _spellDmgTaken=0, _kills=0, _assists=0, _deaths=0, _numSpellsCast=0, 
				_wins=0, _losses=0, _timePlayed=0;
	private String _name="";
	
	/**
	 * Creates a player and sets initializes it with the following statistics.
	 * @param name = The player's name
	 * @param attacks = The number of attacks the player has
	 * @param hits = The number of hits the player has
	 * @param physDmgDone = The physical damage the player has done
	 * @param physDmgTaken = The physical damage the player has taken
	 * @param spellDmgDone = The spell damage the player has done
	 * @param spellDmgTaken = The spell damage the player has taken
	 * @param kills = The number of kills the player has
	 * @param assists = The number of assists the player has
	 * @param deaths = The number of deaths the player has
	 * @param numSpellsCast = The number of spells the player has cast
	 * @param wins = The number of wins this player has
	 * @param losses = The number of losses this player has
	 * @param timePlayed = The total time the player has played the game
	 */
	public Player(String name, int attacks, int hits, int physDmgDone, int physDmgTaken, int spellDmgDone, int spellDmgTaken, int kills, int assists, int deaths, 
				int numSpellsCast, int wins, int losses, int timePlayed){
		_name = name;
		_attacks = attacks;
		_hits = hits;
		_physDmgDone = physDmgDone;
		_physDmgTaken = physDmgTaken;
		_spellDmgDone = spellDmgDone;
		_spellDmgTaken = spellDmgTaken;
		_kills = kills;
		_assists = assists;
		_deaths = deaths;
		_numSpellsCast = numSpellsCast;
		_wins = wins;
		_losses = losses;
		_timePlayed = timePlayed;
	}

	public String getName(){
		return _name;
	}

	public Integer getAttacks() {
		return _attacks;
	}
	
	public Integer getHits() {
		return _hits;
	}
	
	public Integer getPhysDmgDone() {
		return _physDmgDone;
	}

	public Integer getPhysDmgTaken() {
		return _physDmgTaken;
	}
	
	public Integer getSpellDmgDone() {
		return _spellDmgDone;
	}
	
	public Integer getSpellDmgTaken() {
		return _spellDmgTaken;
	}
	
	public Integer getKills() {
		return _kills;
	}
	
	public Integer getAssists() {
		return _assists;
	}
	
	public Integer getDeaths() {
		return _deaths;
	}
	
	public Integer getNumSpellsCast() {
		return _numSpellsCast;
	}
	
	public Integer getWins() {
		return _wins;
	}
	
	public Integer getLosses() {
		return _losses;
	}
	
	public Integer getTimePlayed() {
		return _timePlayed;
	}
}
