package achievementsystem;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Random;
import javax.swing.JOptionPane;

/**
 * This class deals with controlling the flow of the program. It handles and event that is triggered and responds to them accordingly.
 */
public class Logic implements ActionListener{
	
	private boolean _00Award=false, _awesomeAward=false, _bigWinnerAward=false, _bruiserAward=false, _loserAward=false, _ripAward=false, _sharpshooterAward=false, 
					_supernovaAward=false, _tankAward=false, _veteranAward=false;
	private Database _database;
	private Graphics _graphics;
	private LinkedList<Game> _selectedPlayerGames=new LinkedList<Game>();
	private Player _selectedPlayer;

	/**
	 * Initializes the database and graphics.
	 */
	public Logic(){
		_database = new Database();
		_graphics = new Graphics(this);
		
		_graphics.createPlayerCreationScreen(_database.getPlayerNames());
	}

	/**
	 * Closes the database connection and then exits from the game.
	 */
	public void exitProgram(){
		_database.closeConnection();
		_graphics.getFrame().dispose();
		System.exit(0);
	}

	/**
	 * Returns the database object that handles calls to the database.
	 * @return
	 * The database object.
	 */
	public Database getDatabase(){
		return _database;
	}

	/**
	 * This method checks to see if the specified player has unlocked any achievements by looking at that player's stats and games.
	 * @param player = The player that is being checked for unlocked achievements.
	 * @param games = The list of games that the player has played in.
	 */
	public void checkForAchievements(Player player, LinkedList<Game> games){
		_sharpshooterAward = false;
		_bruiserAward = false;
		_00Award = false;
		_tankAward = false;
		_supernovaAward = false;
		
		//loops through all the player's games to check for various awards
		for(int x=0; x<games.size(); x++){
			//if the player attacked more than once and the ratio of attacks to hits was greater than 75%
			if(_sharpshooterAward == false && games.get(x).getAttacks() > 1 && ((double)games.get(x).getAttacks()) / ((double)games.get(x).getHits()) >= .75){
				_sharpshooterAward = true;
			}
			//if the player did more than 500 points of damage this game
			if(_bruiserAward == false && (games.get(x).getPhysDmgDone() + games.get(x).getSpellDmgDone()) >= 500){
				_bruiserAward = true;
			}
			//if the player killed more than 50 players this game
			if(_00Award == false && games.get(x).getKills() >= 50){
				_00Award = true;
			}
			//if the player took more than 5000 damage this game
			if(_tankAward == false && (games.get(x).getPhysDmgTaken() + games.get(x).getSpellDmgTaken()) > 5000){
				_tankAward = true;
			}
			//if the player casted more than 200 spells in a game
			if(_supernovaAward == false && games.get(x).getNumSpellsCast() >= 200){
				_supernovaAward = true;
			}
		}
		
		//the order that the awards are in determines how they are displayed on the screen
		
		//Sharp Shooter Award = 75% accuracy in a game
		if(_sharpshooterAward == true){
			_graphics.addAchievementButton(_graphics.getSharpshooterIcon(), "SHARPSHOOTERAWARD_BUTTON");
		}
		else{
			_graphics.addAchievementButton(_graphics.getQuestionIcon(), "SHARPSHOOTERAWARD_BUTTON");
		}
		
		//Bruiser Award = 500 damage in a game
		if(_bruiserAward == true){
			_graphics.addAchievementButton(_graphics.getBruiserIcon(), "BRUISERAWARD_BUTTON");
		}
		else{
			_graphics.addAchievementButton(_graphics.getQuestionIcon(), "BRUISERAWARD_BUTTON");
		}
		
		//Veteran = 1000 total games
		if((player.getWins() + player.getLosses()) >= 1000){
			_veteranAward = true;
			_graphics.addAchievementButton(_graphics.getVeteranIcon(), "VETERANAWARD_BUTTON");
		}
		else{
			_veteranAward = false;
			_graphics.addAchievementButton(_graphics.getQuestionIcon(), "VETERANAWARD_BUTTON");
		}
		
		//Big Winner Award = 200 total wins
		if(player.getWins() >= 200){
			_bigWinnerAward = true;
			_graphics.addAchievementButton(_graphics.getBigWinnerIcon(), "BIGWINNERAWARD_BUTTON");
		}
		else{
			_bigWinnerAward = false;
			_graphics.addAchievementButton(_graphics.getQuestionIcon(), "BIGWINNERAWARD_BUTTON");
		}
		
		//00 Award = 50 kills in a game
		if(_00Award == true){
			_graphics.addAchievementButton(_graphics.get00Icon(), "00AWARD_BUTTON");
		}
		else{
			_graphics.addAchievementButton(_graphics.getQuestionIcon(), "00AWARD_BUTTON");
		}
		
		//RIP Award = 200 total deaths
		if(player.getDeaths() >= 200){
			_ripAward = true;
			_graphics.addAchievementButton(_graphics.getRIPIcon(), "RIPAWARD_BUTTON");
		}
		else{
			_ripAward = false;
			_graphics.addAchievementButton(_graphics.getQuestionIcon(), "RIPAWARD_BUTTON");
		}
		
		//Loser Award = 400 total Losses
		if(player.getLosses() >= 400){
			_loserAward = true;
			_graphics.addAchievementButton(_graphics.getLoserIcon(), "LOSERAWARD_BUTTON");
		}
		else{
			_loserAward = false;
			_graphics.addAchievementButton(_graphics.getQuestionIcon(), "LOSERAWARD_BUTTON");
		}
		
		//Tank Award = take 5000 or more damage in a game
		if(_tankAward == true){
			_graphics.addAchievementButton(_graphics.getTankIcon(), "TANKAWARD_BUTTON");
		}
		else{
			_graphics.addAchievementButton(_graphics.getQuestionIcon(), "TANKAWARD_BUTTON");
		}
		
		//Supernova Award = cast 200 or more spells in a game
		if(_supernovaAward == true){
			_graphics.addAchievementButton(_graphics.getSupernovaIcon(), "SUPERNOVAAWARD_BUTTON");
		}
		else{
			_graphics.addAchievementButton(_graphics.getQuestionIcon(), "SUPERNOVAAWARD_BUTTON");
		}
		
		//Awesome Award = all other achievements have been unlocked
		if(_sharpshooterAward == true && _bruiserAward == true && _veteranAward == true && _bigWinnerAward == true && _00Award == true && _ripAward == true && 
				_loserAward == true && _tankAward == true && _supernovaAward == true){
			_awesomeAward = true;
			_graphics.addAchievementButton(_graphics.getAwesomeIcon(), "AWESOMEAWARD_BUTTON");
		}
		else{
			_awesomeAward = false;
			_graphics.addAchievementButton(_graphics.getQuestionIcon(), "AWESOMEAWARD_BUTTON");			
		}
	}
	

	@Override
	public void actionPerformed(ActionEvent event){
		//exit from the game
		if(event.getActionCommand().equals("EXIT_MENUITEM")){
			this.exitProgram();
		}
		//delete data in database and set GUI to player creation screen
		else if(event.getActionCommand().equals("DELETEDATA_MENUITEM")){
			//prompt user for confirmation for delete command
			int n = JOptionPane.showOptionDialog(_graphics.getFrame(), "Do you really want to delete all the data?", "Confirm Delete", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null, null, null);
			
			//if the user wants to delete the database of all the data
			if(n == 1){
				_database.deleteAllFromDatabase();
				_graphics.removeAchievementsScreenComponents();
				_graphics.removeGameCustomizationScreenComponents();
				_graphics.removePlayerCreationScreenComponents();
				_graphics.createPlayerCreationScreen(new LinkedList<String>());
			}
		}
		//check to see if name is valid and if it is then create the new player, otherwise display error
		else if(event.getActionCommand().equals("CREATEPLAYER_BUTTON")){
			//if there is text entered
			if(_graphics.getCreatePlayerTextField().getText() != null && _graphics.getCreatePlayerTextField().getText() != ""){
				//if the player is not in the database, add them to it
				if(_database.insertPlayer(_graphics.getCreatePlayerTextField().getText()) == true){
					System.out.println("GOOD NAME");
					_graphics.removePlayerCreationScreenComponents();
					_graphics.createPlayerCreationScreen(_database.getPlayerNames());
				}
				//if the player is already in the database
				else{
					System.out.println("BAD NAME");
					_graphics.setCreateWarningTextPaneText("Name already taken");
					_graphics.getCreatePlayerTextField().selectAll();
				}
			}
			//if there is no text entered
			else{
				System.out.println("EMPTY NAME");
				_graphics.setCreateWarningTextPaneText("Enter a valid name.");
				_graphics.getCreatePlayerTextField().grabFocus();
			}
		}
		//tries to find the specified player in the database to view their profile
		else if(event.getActionCommand().equals("FINDPLAYER_BUTTON")){
			//if there is text entered
			if(_graphics.getFindPlayerTextField().getText() != null && _graphics.getFindPlayerTextField().getText() != ""){
				_selectedPlayer = _database.getPlayer(_graphics.getFindPlayerTextField().getText());
				//if the player is in the database, set GUI to view player profile screen
				if(_selectedPlayer != null){
					_selectedPlayerGames = _database.getGamesForPlayer(_selectedPlayer.getName());
					
					_graphics.removePlayerCreationScreenComponents();
					_graphics.createAchievementsScreen(_selectedPlayer, _selectedPlayerGames);
					_graphics.showPlayerStats(_selectedPlayer);
				}
				//if the player is not in the database
				else{
					_graphics.setFindWarningTextPaneText("Player not found.");
					_graphics.getFindPlayerTextField().selectAll();
				}
			}
			//if there is no text entered
			else{
				_graphics.setFindWarningTextPaneText("Enter a valid name.");
				_graphics.getFindPlayerTextField().grabFocus();
			}
		}
		//set GUI to create game screen to allow user to add games for player
		else if(event.getActionCommand().equals("CUSTOMIZEGAME_BUTTON")){
			_graphics.removePlayerCreationScreenComponents();
			_graphics.createGameCustomizationScreen(_database.getPlayerNames());
		}
		//shows all of the statistics for the player being viewed
		else if(event.getActionCommand().equals("VIEWALLSTATS_BUTTON")){
			_graphics.showPlayerStats(_selectedPlayer);
		}
		//if the user wants to go back to the player creation screen
		else if(event.getActionCommand().equals("DONE_BUTTON")){
			_graphics.removeGameCustomizationScreenComponents();
			_graphics.removeAchievementsScreenComponents();
			_graphics.createPlayerCreationScreen(_database.getPlayerNames());
		}
		//set GUI to view the statistics for the player's name that was clicked
		else if(event.getActionCommand().equals("PLAYERNAMES_BUTTON")){
			//loops through all of the player name buttons to find the one that was clicked
			for(int x=0; x<_graphics.getPlayerNameButtons().size(); x++){
				//if this button was the button that was clicked, view that player's profile
				if(event.getSource().equals(_graphics.getPlayerNameButtons().get(x))){
					_selectedPlayer = _database.getPlayer(_graphics.getPlayerNameButtons().get(x).getText());
					_selectedPlayerGames = _database.getGamesForPlayer(_selectedPlayer.getName());
					
					_graphics.removePlayerCreationScreenComponents();
					_graphics.createAchievementsScreen(_selectedPlayer, _selectedPlayerGames);
					_graphics.showPlayerStats(_selectedPlayer);
					break;
				}
			}
		}
		//shows the statistics for the game that was selected
		else if(event.getActionCommand().equals("PLAYERGAME_BUTTON")){
			//loops through the game buttons to find the button that was pressed
			for(int x=0; x<_graphics.getPlayerGameButtons().size(); x++){
				//if this button was the button that was pressed, show the statistics for that game
				if(event.getSource().equals(_graphics.getPlayerGameButtons().get(x))){
					_graphics.showGameStats((x + 1), _selectedPlayerGames.get(x));
					break;
				}
			}
		}
		//check to make sure that all fields have a number and create game for the selected player if they do
		else if(event.getActionCommand().equals("CREATEGAME_BUTTON")){
			//if a text field's text cannot be converted to an integer, throw an error
			try{
				_database.insertGame(new Game(_graphics.getSelectedComboBoxPlayerName(), Integer.parseInt(_graphics.getAttacksTextFieldText().getText()), 
						Integer.parseInt(_graphics.getHitsTextFieldText().getText()), Integer.parseInt(_graphics.getPhysDmgDoneTextFieldText().getText()), 
						Integer.parseInt(_graphics.getPhysDmgTakenTextFieldText().getText()), Integer.parseInt(_graphics.getSpellDmgDoneTextFieldText().getText()), 
						Integer.parseInt(_graphics.getSpellDmgTakenTextFieldText().getText()), Integer.parseInt(_graphics.getKillsTextFieldText().getText()), 
						Integer.parseInt(_graphics.getAssistsTextFieldText().getText()), Integer.parseInt(_graphics.getDeathsTextFieldText().getText()), 
						Integer.parseInt(_graphics.getNumSpellsCastTextFieldText().getText()), Integer.parseInt(_graphics.getTimePlayedTextFieldText().getText()), 
						Integer.parseInt(_graphics.getWonTextFieldText().getText())));
				_graphics.setCreateWarningTextPaneText("Game added successfully for " + _graphics.getSelectedComboBoxPlayerName());
			}
			catch(NumberFormatException exception){
				_graphics.setCreateWarningTextPaneText("All fields must have values");
			}
		}
		//randomize the statistics for a game to make creating games faster
		else if(event.getActionCommand().equals("RANDOMIZEGAME_BUTTON")){
			int attacks = new Random().nextInt(10000);
			_graphics.getAttacksTextFieldText().setText(String.valueOf(attacks));
			_graphics.getHitsTextFieldText().setText(String.valueOf(new Random().nextInt(attacks)));
			_graphics.getPhysDmgDoneTextFieldText().setText(String.valueOf(new Random().nextInt(10000)));
			_graphics.getPhysDmgTakenTextFieldText().setText(String.valueOf(new Random().nextInt(10000)));
			_graphics.getNumSpellsCastTextFieldText().setText(String.valueOf(new Random().nextInt(10000)));
			_graphics.getSpellDmgDoneTextFieldText().setText(String.valueOf(new Random().nextInt(10000)));
			_graphics.getSpellDmgTakenTextFieldText().setText(String.valueOf(new Random().nextInt(10000)));
			_graphics.getKillsTextFieldText().setText(String.valueOf(new Random().nextInt(10000)));
			_graphics.getAssistsTextFieldText().setText(String.valueOf(new Random().nextInt(10000)));
			_graphics.getDeathsTextFieldText().setText(String.valueOf(new Random().nextInt(10000)));
			_graphics.getTimePlayedTextFieldText().setText(String.valueOf(new Random().nextInt(10000) + 1));
			_graphics.getWonTextFieldText().setText(String.valueOf(new Random().nextInt(2)));
		}
		//if the sharpshooter award button was clicked, display info on it
		else if(event.getActionCommand().equals("SHARPSHOOTERAWARD_BUTTON")){
			//if the award is unlocked
			if(_sharpshooterAward == true){
				_graphics.setupAchievementDescription(_graphics.getSharpshooterIcon(), "Sharpshooter Award", "Acquired 75% Accuracy in a single game.");
			}
			else{
				_graphics.setupAchievementDescription(_graphics.getQuestionIcon(), "Sharpshooter Award", "Needs 75% Accuracy in a single game to unlock.");
			}
		}
		//if the bruiser award button was clicked, display info on it
		else if(event.getActionCommand().equals("BRUISERAWARD_BUTTON")){
			//if the award is unlocked
			if(_bruiserAward == true){
				_graphics.setupAchievementDescription(_graphics.getBruiserIcon(), "Bruiser Award", "Acquired 500 Points of Damage in a single game.");
			}
			else{
				_graphics.setupAchievementDescription(_graphics.getQuestionIcon(), "Bruiser Award", "Needs 500 Points of Damage in a single game to unlock.");
			}
		}
		//if the veteran award button was clicked, display info on it
		else if(event.getActionCommand().equals("VETERANAWARD_BUTTON")){
			//if the award is unlocked
			if(_veteranAward == true){
				_graphics.setupAchievementDescription(_graphics.getVeteranIcon(), "Veteran Award", "Acquired 1000 Games Played.");
			}
			else{
				_graphics.setupAchievementDescription(_graphics.getQuestionIcon(), "Veteran Award", "Needs 1000 Games Played to unlock.");
			}
		}
		//if the big winner award button was clicked, display info on it
		else if(event.getActionCommand().equals("BIGWINNERAWARD_BUTTON")){
			//if the award is unlocked
			if(_bigWinnerAward == true){
				_graphics.setupAchievementDescription(_graphics.getBigWinnerIcon(), "Big Winner Award", "Acquired 200 Games Won.");
			}
			else{
				_graphics.setupAchievementDescription(_graphics.getQuestionIcon(), "Big Winner Award", "Needs 200 Games Won to unlock.");
			}
		}
		//if the 00 award button was clicked, display info on it
		else if(event.getActionCommand().equals("00AWARD_BUTTON")){
			//if the award is unlocked
			if(_00Award == true){
				_graphics.setupAchievementDescription(_graphics.get00Icon(), "00 Award", "Acquired 50 Player Kills in a single game.");
			}
			else{
				_graphics.setupAchievementDescription(_graphics.getQuestionIcon(), "00 Award", "Needs 50 Player Kills in a single game to unlock.");
			}
		}
		//if the RIP award button was clicked, display info on it
		else if(event.getActionCommand().equals("RIPAWARD_BUTTON")){
			//if the award is unlocked
			if(_ripAward == true){
				_graphics.setupAchievementDescription(_graphics.getRIPIcon(), "RIP Award", "Acquired 200 Total Deaths.");
			}
			else{
				_graphics.setupAchievementDescription(_graphics.getQuestionIcon(), "RIP Award", "Needs 200 Total Deaths to unlock.");
			}
		}
		//if the loser award button was clicked, display info on it
		else if(event.getActionCommand().equals("LOSERAWARD_BUTTON")){
			//if the award is unlocked
			if(_loserAward == true){
				_graphics.setupAchievementDescription(_graphics.getLoserIcon(), "Loser Award", "Acquired 400 Games Lost.");
			}
			else{
				_graphics.setupAchievementDescription(_graphics.getQuestionIcon(), "Loser Award", "Needs 400 Games Lost to unlock.");
			}
		}
		//if the tank award button was clicked, display info on it
		else if(event.getActionCommand().equals("TANKAWARD_BUTTON")){
			//if the award is unlocked
			if(_tankAward == true){
				_graphics.setupAchievementDescription(_graphics.getTankIcon(), "Tank Award", "Acquired 5000 Damage Taken in a single game.");
			}
			else{
				_graphics.setupAchievementDescription(_graphics.getQuestionIcon(), "Tank Award", "Needs 5000 Damage Taken in a single game to unlock.");
			}
		}
		//if the supernova award button was clicked, display info on it
		else if(event.getActionCommand().equals("SUPERNOVAAWARD_BUTTON")){
			//if the award is unlocked
			if(_supernovaAward == true){
				_graphics.setupAchievementDescription(_graphics.getSupernovaIcon(), "Supernova Award", "Acquired 200 Spells Cast in a single game.");
			}
			else{
				_graphics.setupAchievementDescription(_graphics.getQuestionIcon(), "Supernova Award", "Needs 200 Spells Cast in a single game to unlock.");
			}
		}
		//if the awesome award button was clicked, display info on it
		else if(event.getActionCommand().equals("AWESOMEAWARD_BUTTON")){
			//if the award is unlocked
			if(_awesomeAward == true){
				_graphics.setupAchievementDescription(_graphics.getAwesomeIcon(), "Awesome Award", "Acquired every achievement.");
			}
			else{
				_graphics.setupAchievementDescription(_graphics.getQuestionIcon(), "Secret Award", "Its a secret.");
			}
		}
	}
	
	/**
	 * Starting point of the program. Creates the logic object.
	 */
	public static void main(String[] args){
		new Logic();
	}
}
