package achievementsystem;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

/**
 * The GUI for the program. Deals with changing the screen to represent the various interaction with the program.
 */
public class Graphics{
	
	private ImageIcon _00Icon, _awesomeIcon, _bigWinnerIcon, _bruiserIcon, _loserIcon, _questionIcon, _ripIcon, _sharpshooterIcon, _supernovaIcon, 
						_tankIcon, _veteranIcon;
	private JButton _button1, _button2, _button3;
	private JComboBox _playerNamesComboBox;
	private JFrame _frame;
	private JLabel _iconLabel;
	private JPanel _namesPanel, _playerStatsPanel, _achievementDescPanel, _scrollPanel, _panel1, _panel2, _fillerPanel;
	private JScrollPane _scrollPane1, _scrollPane2, _scrollPane3;
	private JTabbedPane _tabbedPane;
	private JTextField _createPlayerTextField, _findPlayerTextField;
	private JTextField _attacksTextField, _hitsTextField, _physDmgDoneTextField, _physDmgTakenTextField, _numSpellsCastTextField, _spellDmgDoneTextField, _spellDmgTakenTextField,
						_killsTextField, _assistsTextField, _deathsTextField, _timePlayedTextField, _wonTextField;
	private JTextPane _infoTextPane, _nameTextPane, _createWarningTextPane, _findWarningTextPane, _iconNameTextPane;
	private LinkedList<JButton> _playerNameButtons=new LinkedList<JButton>(), _playerGameButtons=new LinkedList<JButton>(), 
								_achievementButtons=new LinkedList<JButton>();
	private Logic _logic;
	private ScrollPanel _achievementsPanel;
	private TextPane _gameStatTextPane;
	
	/**
	 * Constructor for the Graphics class. Initializes all the global variables and sets-up the basic screen.
	 * @param logic = The control for the logic of this program
	 */
	public Graphics(Logic logic){
		_logic = logic;
		
		this.loadImageIcons();
		
		//initializes the frame
		_frame = new JFrame("Achievement System");
		_frame.setSize(800, 600);
		_frame.setFocusable(false);
		_frame.setLocationRelativeTo(null);
		_frame.setVisible(true);
		_frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		_frame.setResizable(false);
		_frame.setLayout(new GridBagLayout());
		_frame.addWindowListener(new WindowListener(){
			@Override
			public void windowClosing(WindowEvent event){
				Graphics.this.exitProgram();
			}
			@Override
			public void windowActivated(WindowEvent event){
			}
			@Override
			public void windowClosed(WindowEvent event){
			}
			@Override
			public void windowDeactivated(WindowEvent event){
			}
			@Override
			public void windowDeiconified(WindowEvent event){
			}
			@Override
			public void windowIconified(WindowEvent event){
			}
			@Override
			public void windowOpened(WindowEvent event){
			}
		});
		
		this.createPanels();
		
		this.createPanes();
		
		this.createTextFieldsAndButtons();
		
		_iconLabel = new JLabel();
		_iconLabel.setBackground(Color.BLACK);
		
		_playerNamesComboBox = new JComboBox();
		_playerNamesComboBox.setActionCommand("PLAYERNAMES_COMBOBOX");
		_playerNamesComboBox.addActionListener(_logic);
		
		this.createMenu();
	}

	/**
	 * Tries to load the icon resources for the achievements icons and an exception is thrown if it cannot
	 * locate the files.
	 */
	private void loadImageIcons(){
		try{
			URL imageURL = Logic.class.getResource("/images/Question.jpg");
			_questionIcon = new ImageIcon(imageURL);
			imageURL = Logic.class.getResource("/images/00.jpg");
			_00Icon = new ImageIcon(imageURL);
			imageURL = Logic.class.getResource("/images/Awesome.jpg");
			_awesomeIcon = new ImageIcon(imageURL);
			imageURL = Logic.class.getResource("/images/Big Winner.jpg");
			_bigWinnerIcon = new ImageIcon(imageURL);
			imageURL = Logic.class.getResource("/images/Bruiser.jpg");
			_bruiserIcon = new ImageIcon(imageURL);
			imageURL = Logic.class.getResource("/images/Loser.jpg");
			_loserIcon = new ImageIcon(imageURL);
			imageURL = Logic.class.getResource("/images/RIP.jpg");
			_ripIcon = new ImageIcon(imageURL);
			imageURL = Logic.class.getResource("/images/Sharpshooter.jpg");
			_sharpshooterIcon = new ImageIcon(imageURL);
			imageURL = Logic.class.getResource("/images/Supernova.jpg");
			_supernovaIcon = new ImageIcon(imageURL);
			imageURL = Logic.class.getResource("/images/Tank.jpg");
			_tankIcon = new ImageIcon(imageURL);
			imageURL = Logic.class.getResource("/images/Veteran.jpg");
			_veteranIcon = new ImageIcon(imageURL);
		}
		catch(NullPointerException exception){
			exception.printStackTrace();
			JOptionPane.showMessageDialog(null, "You are missing image files on your computer. Reinstall the program.", "Failure", 0);
			_logic.getDatabase().closeConnection();
			System.exit(0);
		}
	}

	/**
	 * Initializes the panels used for the GUI.
	 */
	private void createPanels(){
		_namesPanel = new JPanel();
		_namesPanel.setBackground(Color.BLACK);
		_namesPanel.setLayout(new GridBagLayout());
		
		_playerStatsPanel = new JPanel();
		_playerStatsPanel.setBackground(Color.BLACK);
		_playerStatsPanel.setLayout(new GridBagLayout());
		
		_achievementDescPanel = new JPanel();
		_achievementDescPanel.setBackground(Color.BLACK);
		_achievementDescPanel.setLayout(new GridBagLayout());
		
		_fillerPanel = new JPanel();
		_fillerPanel.setBackground(Color.BLACK);
		_fillerPanel.setLayout(new GridBagLayout());
		
		_panel1 = new JPanel();
		_panel1.setBackground(Color.BLACK);
		_panel1.setLayout(new GridBagLayout());
		
		_panel2 = new JPanel();
		_panel2.setBackground(Color.BLACK);
		_panel2.setLayout(new GridBagLayout());
		
		_scrollPanel = new JPanel();
		_scrollPanel.setBackground(Color.BLACK);
		_scrollPanel.setLayout(new GridBagLayout());
		
		_achievementsPanel = new ScrollPanel();
		_achievementsPanel.setBackground(Color.BLACK);
		_achievementsPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
	}

	/**
	 * Initializes the text, scroll, and tabbed panes used in this GUI.
	 */
	private void createPanes(){
		_infoTextPane = new JTextPane();
		_infoTextPane.setBackground(Color.BLACK);
		_infoTextPane.setFont(new Font(Font.DIALOG, Font.BOLD, 12));
		_infoTextPane.setEditable(false);
		
		_nameTextPane = new JTextPane();
		_nameTextPane.setBackground(Color.BLACK);
		_nameTextPane.setFont(new Font(Font.DIALOG, Font.BOLD, 14));
		_nameTextPane.setEditable(false);
		
		_createWarningTextPane = new JTextPane();
		_createWarningTextPane.setBackground(Color.BLACK);
		_createWarningTextPane.setForeground(Color.RED);
		_createWarningTextPane.setFont(new Font(Font.DIALOG, Font.BOLD, 18));
		_createWarningTextPane.setEditable(false);
		
		_findWarningTextPane = new JTextPane();
		_findWarningTextPane.setBackground(Color.BLACK);
		_findWarningTextPane.setForeground(Color.RED);
		_findWarningTextPane.setFont(new Font(Font.DIALOG, Font.BOLD, 18));
		_findWarningTextPane.setEditable(false);
		
		_iconNameTextPane = new JTextPane();
		_iconNameTextPane.setBackground(Color.BLACK);
		_iconNameTextPane.setForeground(Color.WHITE);
		_iconNameTextPane.setFont(new Font(Font.DIALOG, Font.BOLD, 18));
		_iconNameTextPane.setEditable(false);
		
		_gameStatTextPane = new TextPane();
		_gameStatTextPane.setFont(new Font(Font.DIALOG, Font.BOLD, 12));
		_gameStatTextPane.setEditable(false);
		
		_scrollPane1 = new JScrollPane(_scrollPanel);
		_scrollPane1.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		
		_scrollPane2 = new JScrollPane(_gameStatTextPane);
		_scrollPane2.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		
		_scrollPane3 = new JScrollPane(_achievementsPanel);
		_scrollPane3.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		_scrollPane3.setPreferredSize(new Dimension(500, 800));
		
		_tabbedPane = new JTabbedPane(JTabbedPane.TOP);
		_tabbedPane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
	}
	
	/**
	 * Initializes the text fields and buttons used in this GUI.
	 */
	private void createTextFieldsAndButtons(){
		_createPlayerTextField = new JTextField(20);
		_createPlayerTextField.setBackground(Color.BLACK);
		_createPlayerTextField.setCaretColor(Color.WHITE);
		_createPlayerTextField.setForeground(Color.WHITE);
		_createPlayerTextField.setSelectionColor(Color.WHITE);
		_createPlayerTextField.setFont(new Font(Font.DIALOG, Font.BOLD, 17));
		
		_findPlayerTextField = new JTextField(20);
		_findPlayerTextField.setBackground(Color.BLACK);
		_findPlayerTextField.setCaretColor(Color.WHITE);
		_findPlayerTextField.setForeground(Color.WHITE);
		_findPlayerTextField.setSelectionColor(Color.WHITE);
		_findPlayerTextField.setFont(new Font(Font.DIALOG, Font.BOLD, 17));
		
		_button1 = new JButton();
		_button1.addActionListener(_logic);

		_button2 = new JButton();
		_button2.addActionListener(_logic);

		_button3 = new JButton();
		_button3.addActionListener(_logic);
	}
	
	/**
	 * Initializes the Menu Items and Menu Bar used in this GUI.
	 */
	private void createMenu(){
		JMenuItem exitMenuItem = new JMenuItem("Exit");
		exitMenuItem.addActionListener(_logic);
		exitMenuItem.setActionCommand("EXIT_MENUITEM");
		exitMenuItem.setToolTipText("Exits the program.");
		
		JMenu fileMenu = new JMenu("File");
		fileMenu.setToolTipText("Control the interaction with the program.");
		fileMenu.add(exitMenuItem);
		
		JMenuItem resetDataMenuItem = new JMenuItem("Delete Database Data");
		resetDataMenuItem.addActionListener(_logic);
		resetDataMenuItem.setActionCommand("DELETEDATA_MENUITEM");
		resetDataMenuItem.setToolTipText("Deletes all data in the database.");
		
		JMenu dataBaseMenu = new JMenu("DataBase");
		dataBaseMenu.setToolTipText("Controls the interaction with the database.");
		dataBaseMenu.add(resetDataMenuItem);
		
		JMenuBar menuBar = new JMenuBar();
		menuBar.add(fileMenu);
		menuBar.add(dataBaseMenu);
		
		_frame.setJMenuBar(menuBar);
	}
	
	/**
	 * Creates the screen where the user can create players, find players, and view players' profiles.
	 * @param playerNames = The list of player names in the database
	 */
	public void createPlayerCreationScreen(LinkedList<String> playerNames){
		_panel2.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED, Color.GRAY, Color.WHITE));
		
		_infoTextPane.setForeground(Color.WHITE);
		_infoTextPane.setText("Select a Player from the Database to view their profile:");
		
		_createWarningTextPane.setText("Enter name of player to create");
		
		_findWarningTextPane.setText("Enter name of player to find");
		
		_createPlayerTextField.setText(null);
		_findPlayerTextField.setText(null);
		
		_button1.setText("Create Player");
		_button1.setFont(new Font(Font.DIALOG, Font.BOLD, 12));
		_button1.setPreferredSize(new Dimension(125, 50));
		_button1.setActionCommand("CREATEPLAYER_BUTTON");
		
		_button2.setText("Find Player");
		_button2.setFont(new Font(Font.DIALOG, Font.BOLD, 12));
		_button2.setPreferredSize(new Dimension(125, 50));
		_button2.setActionCommand("FINDPLAYER_BUTTON");
		
		_button3.setText("Customize Games");
		_button3.setFont(new Font(Font.DIALOG, Font.BOLD, 12));
		_button3.setPreferredSize(new Dimension(150, 50));
		_button3.setActionCommand("CUSTOMIZEGAME_BUTTON");
		
		
		GridBagConstraints c = new GridBagConstraints();
		c.anchor = GridBagConstraints.NORTH;
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 1.0;
		for(int x=0; x<playerNames.size(); x++){
			JButton button = new JButton(playerNames.get(x));
			button.setHorizontalAlignment(SwingConstants.LEFT);
			button.setBackground(Color.BLACK);
			button.setForeground(Color.WHITE);
			button.setFont(new Font(Font.DIALOG, Font.BOLD, 14));
			button.setBorder(BorderFactory.createRaisedBevelBorder());
			button.setActionCommand("PLAYERNAMES_BUTTON");
			button.addActionListener(_logic);
			
			c.gridy = x;
			_scrollPanel.add(button, c);
			_playerNameButtons.add(button);
		}
		c.weighty = 1.0;
		c.gridy = playerNames.size();
		_scrollPanel.add(_fillerPanel, c);
		
		
		c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 0;
		_namesPanel.add(_infoTextPane, c);
		
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		c.gridx = 0;
		c.gridy = 1;
		_namesPanel.add(_scrollPane1, c);
		
		
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 0;
		c.gridx = 0;
		c.gridy = 0;
		_panel1.add(_createPlayerTextField, c);
		
		c.weighty = 1.0;
		c.gridy = 1;
		_panel1.add(_createWarningTextPane, c);
		
		c.fill = GridBagConstraints.NONE;
		c.gridy = 2;
		_panel1.add(_button1, c);
		
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 0;
		c.gridy = 3;
		_panel1.add(_findPlayerTextField, c);
		
		c.weighty = 1.0;
		c.gridy = 4;
		_panel1.add(_findWarningTextPane, c);
		
		c.fill = GridBagConstraints.NONE;
		c.gridy = 5;
		_panel1.add(_button2, c);
		
		_panel2.add(_button3);
		
		
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 0.3;
		c.weighty = 1.0;
		c.gridheight = 2;
		c.gridx = 0;
		c.gridy = 0;
		_frame.add(_namesPanel, c);
		
		c.weightx = 0.7;
		c.gridx = 1;
		c.gridheight = 1;
		_frame.add(_panel1, c);
		
		c.gridy = 1;
		_frame.add(_panel2, c);
		
		_frame.validate();
		_frame.repaint();
		_createPlayerTextField.grabFocus();
	}
	
	/**
	 * Creates the screen where the user can add a game for players
	 * @param playerNames = The list of player names in the database
	 */
	public void createGameCustomizationScreen(LinkedList<String> playerNames){
		for(int x=0; x<playerNames.size(); x++){
			_playerNamesComboBox.addItem(playerNames.get(x));
		}
		_panel1.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED, Color.GRAY, Color.WHITE));
		
		_gameStatTextPane.setText(null);
		
		_createWarningTextPane.setText(null);
		_createWarningTextPane.setPreferredSize(new Dimension(400, 200));
		
		_button1.setText("Create Game");
		_button1.setFont(new Font(Font.DIALOG, Font.BOLD, 12));
		_button1.setPreferredSize(new Dimension(125, 50));
		_button1.setActionCommand("CREATEGAME_BUTTON");
		
		_button2.setText("Randomize Game");
		_button2.setFont(new Font(Font.DIALOG, Font.BOLD, 12));
		_button2.setPreferredSize(new Dimension(150, 50));
		_button2.setActionCommand("RANDOMIZEGAME_BUTTON");
		
		_button3.setText("Done");
		_button3.setFont(new Font(Font.DIALOG, Font.BOLD, 12));
		_button3.setPreferredSize(new Dimension(125, 50));
		_button3.setActionCommand("DONE_BUTTON");
		
		_wonTextField = this.addStatisticForGame("Game Won: (0 = loss)");
		_attacksTextField = this.addStatisticForGame("Attacks: ");
		_hitsTextField = this.addStatisticForGame("Hits: ");
		_physDmgDoneTextField = this.addStatisticForGame("Physcial Damage Done: ");
		_physDmgTakenTextField = this.addStatisticForGame("Physcial Damage Taken: ");
		_numSpellsCastTextField = this.addStatisticForGame("Number of Spells Cast: ");
		_spellDmgDoneTextField = this.addStatisticForGame("Spell Damage Done: ");
		_spellDmgTakenTextField = this.addStatisticForGame("Spell Damage Taken: ");
		_killsTextField = this.addStatisticForGame("Kills: ");
		_assistsTextField = this.addStatisticForGame("Assists: ");
		_deathsTextField = this.addStatisticForGame("Deaths: ");
		_timePlayedTextField = this.addStatisticForGame("Time Played: ");
		
		
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.NONE;
		c.gridx = 0;
		c.gridy = 0;
		_namesPanel.add(_playerNamesComboBox, c);
		
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		c.gridy = 1;
		_namesPanel.add(_scrollPane1, c);
		
		
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.NONE;
		c.weightx = 0;
		c.weighty = 0;
		_fillerPanel.add(_button2, c);
		
		
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.NONE;
		c.weightx = 0;
		c.weighty = 0;
		_panel2.add(_button3, c);
		
		
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		c.gridx = 0;
		c.gridy = 0;
		_panel1.add(_createWarningTextPane, c);
		
		c.fill = GridBagConstraints.NONE;
		c.weightx = 0;
		c.weighty = 0;
		c.gridy = 1;
		_panel1.add(_button1, c);
		
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		c.gridy = 2;
		_panel1.add(_fillerPanel, c);
		
		c.fill = GridBagConstraints.NONE;
		c.weightx = 0;
		c.weighty = 0;
		c.gridy = 3;
		_panel1.add(_panel2, c);
		

		c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		c.gridx = 0;
		c.gridy = 0;
		_frame.add(_namesPanel, c);
		
		c.fill = GridBagConstraints.VERTICAL;
		c.weightx = 0;
		c.weighty = 0;
		c.gridx = 1;
		_frame.add(_panel1, c);
		
		_frame.validate();
		_frame.repaint();
	}
	
	/**
	 * Creates the screen where the user can view the statistics and achievements for the selected player.
	 * @param player = The player who's statistics are being viewed
	 * @param games = The list of games for the player
	 */
	public void createAchievementsScreen(Player player, LinkedList<Game> games){
		_playerStatsPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED, Color.GRAY, Color.WHITE));
		
		_infoTextPane.setForeground(Color.WHITE);
		_infoTextPane.setText("Select game to view statictics:");
		
		_nameTextPane.setForeground(Color.WHITE);
		_nameTextPane.setText(null);
		
		_iconNameTextPane.setText("No achievement selected.");
		
		_createWarningTextPane.setText(null);
		_createWarningTextPane.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED, Color.GRAY, Color.WHITE));
		
		_gameStatTextPane.setText(null);
		_gameStatTextPane.setFont(new Font(Font.DIALOG, Font.BOLD, 14));
		
		_button1.setText("View All Stats");
		_button1.setFont(new Font(Font.DIALOG, Font.BOLD, 12));
		_button1.setPreferredSize(new Dimension(125, 50));
		_button1.setActionCommand("VIEWALLSTATS_BUTTON");
		
		_button2.setText("Done");
		_button2.setFont(new Font(Font.DIALOG, Font.BOLD, 12));
		_button2.setPreferredSize(new Dimension(125, 30));
		_button2.setActionCommand("DONE_BUTTON");
		
		_iconLabel.setIcon(_questionIcon);
		
		_logic.checkForAchievements(player, games);
		
		
		GridBagConstraints c = new GridBagConstraints();
		c.anchor = GridBagConstraints.NORTH;
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 1.0;
		for(Integer x=0; x<games.size(); x++){
			JButton button = new JButton("Game " + ((Integer)(x + 1)).toString());
			button.setHorizontalAlignment(SwingConstants.LEFT);
			button.setBackground(Color.BLACK);
			button.setForeground(Color.WHITE);
			button.setFont(new Font(Font.DIALOG, Font.BOLD, 14));
			button.setBorder(BorderFactory.createRaisedBevelBorder());
			button.setActionCommand("PLAYERGAME_BUTTON");
			button.addActionListener(_logic);
			
			c.gridy = x;
			_scrollPanel.add(button, c);
			_playerGameButtons.add(button);
		}
		c.weighty = 1.0;
		c.gridy = games.size();
		_scrollPanel.add(_fillerPanel, c);
		
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.NONE;
		c.gridx = 0;
		c.gridy = 0;
		_namesPanel.add(_infoTextPane, c);
		
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		c.gridx = 0;
		c.gridy = 1;
		_namesPanel.add(_scrollPane1, c);
		
		c.fill = GridBagConstraints.NONE;
		c.weightx = 0;
		c.weighty = 0;
		c.gridy = 2;
		_namesPanel.add(_button1, c);
		
		
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.NONE;
		c.weightx = 0;
		c.weighty = 0;
		_playerStatsPanel.add(_nameTextPane, c);
		
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		c.gridy = 1;
		_playerStatsPanel.add(_scrollPane2, c);
		
		
		c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 0;
		_achievementDescPanel.add(_iconLabel, c);
		
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.gridx = 1;
		_achievementDescPanel.add(_iconNameTextPane, c);
		
		c.weightx = 1.0;
		c.weighty = 1.0;
		c.gridx = 0;
		c.gridy = 1;
		c.gridwidth = 2;
		_achievementDescPanel.add(_createWarningTextPane, c);
		
		
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 0.6;
		c.weighty = 0.6;
		_panel2.add(_scrollPane3, c);
		
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 0.4;
		c.weighty = 0.4;
		_panel2.add(_achievementDescPanel, c);
		
		
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = .2;
		c.weighty = .2;
		_panel1.add(_namesPanel, c);
		
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		_panel1.add(_playerStatsPanel, c);
		
		_tabbedPane.addTab(player.getName() + "'s Statistics", _panel1);
		_tabbedPane.addTab(player.getName() + "'s Achievements", _panel2);
		_tabbedPane.setSelectedIndex(0);
		
		
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		_frame.add(_tabbedPane, c);
		
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.EAST;
		c.weightx = 0;
		c.weighty = 0;
		c.gridy = 1;
		_frame.add(_button2, c);
		
		_frame.validate();
		_frame.repaint();
	}

	/**
	 * Shows the statistics for the selected game of a player.
	 * @param index = The selected game index
	 * @param game = The game selected
	 */
	public void showGameStats(Integer index, Game game){
		this.clearStats();
		
		_nameTextPane.setText("Game " + index.toString() + ":");
		
		if(game.getWin() == 0){
			_gameStatTextPane.append(Color.WHITE, "Game:					" + " Lost\n\n\n\n");
		}
		else{
			_gameStatTextPane.append(Color.WHITE, "Game:					" + "Won\n\n\n\n");
		}
		
		_gameStatTextPane.append(Color.WHITE, "Attacks:					" + game.getAttacks() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Hits:					" + game.getHits() + "\n\n");
		_gameStatTextPane.append(Color.WHITE, "Physical Damage Done:			" + game.getPhysDmgDone() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Physical Damage Taken:			" + game.getPhysDmgTaken() + "\n\n");
		_gameStatTextPane.append(Color.WHITE, "Number of Spells Cast:			" + game.getNumSpellsCast() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Spell Damage Done:				" + game.getSpellDmgDone() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Spell Damage Taken:			" + game.getSpellDmgTaken() + "\n\n");
		_gameStatTextPane.append(Color.WHITE, "Kills:					" + game.getKills() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Assists:					" + game.getAssists() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Deaths:					" + game.getDeaths() + "\n\n");
		_gameStatTextPane.append(Color.WHITE, "Time Played:				" + game.getTimePlayed() + "\n");
	}

	/**
	 * Shows the statistics for the player.
	 * @param player = The player who's profile is being viewed
	 */
	public void showPlayerStats(Player player){
		this.clearStats();
		
		_nameTextPane.setText("All Game Stats:");
		_gameStatTextPane.append(Color.WHITE, "Games Played:				" + (player.getWins() + player.getLosses()) + "\n");
		_gameStatTextPane.append(Color.WHITE, "Wins:					" + player.getWins() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Losses:					" + player.getLosses() + "\n\n");
		_gameStatTextPane.append(Color.WHITE, "Attacks:					" + player.getAttacks() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Hits:					" + player.getHits() + "\n\n");
		_gameStatTextPane.append(Color.WHITE, "Physical Damage Done:			" + player.getPhysDmgDone() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Physical Damage Taken:			" + player.getPhysDmgTaken() + "\n\n");
		_gameStatTextPane.append(Color.WHITE, "Number of Spells Cast:			" + player.getNumSpellsCast() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Spell Damage Done:				" + player.getSpellDmgDone() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Spell Damage Taken:			" + player.getSpellDmgTaken() + "\n\n");
		_gameStatTextPane.append(Color.WHITE, "Kills:					" + player.getKills() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Assists:					" + player.getAssists() + "\n");
		_gameStatTextPane.append(Color.WHITE, "Deaths:					" + player.getDeaths() + "\n\n");
		_gameStatTextPane.append(Color.WHITE, "Time Played:				" + player.getTimePlayed() + "\n");
	}

	/**
	 * Clears the screen of any statistics.
	 */
	public void clearStats(){
		_nameTextPane.setText(null);
		_gameStatTextPane.setText(null);
	}

	/**
	 * Adds a button that is used for viewing achievements of a player.
	 * @param icon = The picture icon of this button
	 * @param actionCommand = The command to be used when the button is pressed
	 */
	public void addAchievementButton(ImageIcon icon, String actionCommand){
		JButton button = new JButton(icon);
		button.setBackground(Color.BLACK);
		button.setPreferredSize(new Dimension(110, 110));
		button.setActionCommand(actionCommand);
		button.addActionListener(_logic);
		_achievementsPanel.add(button);
		_achievementButtons.add(button);
	}

	/**
	 * Displays information about the selected achievement.
	 * @param icon = The picture icon of this button
	 * @param name = The name of the achievement selected
	 * @param description = The description of how to unlock the achievement
	 */
	public void setupAchievementDescription(ImageIcon icon, String name, String description){
		_iconLabel.setIcon(icon);
		_iconNameTextPane.setText(name);
		_createWarningTextPane.setText(description);
		_achievementDescPanel.validate();
	}

	/**
	 * Adds a JTextField to a panel that will allow for entering of a statistic.
	 * @param statistic = The statistic for a game
	 * @return
	 * The JTextField that was initialized
	 */
	public JTextField addStatisticForGame(String statistic){
		JTextField textField = new JTextField(20);
		textField.setDocument(new TextVerifier());
		textField.setBackground(Color.BLACK);
		textField.setCaretColor(Color.WHITE);
		textField.setForeground(Color.WHITE);
		textField.setSelectionColor(Color.WHITE);
		textField.setFont(new Font(Font.DIALOG, Font.BOLD, 14));
		textField.setHorizontalAlignment(JTextField.CENTER);
		
		JTextPane textPane = new JTextPane();
		textPane.setBackground(Color.BLACK);
		textPane.setForeground(Color.WHITE);
		textPane.setFont(new Font(Font.DIALOG, Font.BOLD, 16));
		textPane.setEditable(false);
		textPane.setText(statistic);
		
		
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 1.0;
		c.gridx = 0;
		_scrollPanel.add(textPane, c);
		
		c.fill = GridBagConstraints.NONE;
		c.weightx = 0;
		c.gridx = 1;
		_scrollPanel.add(textField, c);
		
		return textField;
	}
	
	/**
	 * Removes all of the components of the Player Creation Screen.
	 */
	public void removePlayerCreationScreenComponents(){
		for(int x=0; x<_playerNameButtons.size(); x++){
			_scrollPanel.remove(_playerNameButtons.remove(x));
			x--;
		}
		_scrollPanel.remove(_fillerPanel);
		_panel2.setBorder(null);
		_namesPanel.remove(_infoTextPane);
		_namesPanel.remove(_scrollPane1);
		_panel1.remove(_createPlayerTextField);
		_panel1.remove(_createWarningTextPane);
		_panel1.remove(_button1);
		_panel1.remove(_findPlayerTextField);
		_panel1.remove(_findWarningTextPane);
		_panel1.remove(_button2);
		_panel2.remove(_button3);
		_frame.remove(_namesPanel);
		_frame.remove(_panel1);
		_frame.remove(_panel2);
	}

	/**
	 * Removes all of the components for the Game Customiztion Screen.
	 */
	public void removeGameCustomizationScreenComponents(){
		_scrollPanel.removeAll();
		_playerNamesComboBox.removeAllItems();
		_createWarningTextPane.setPreferredSize(null);
		_panel1.setBorder(null);
		_namesPanel.remove(_playerNamesComboBox);
		_namesPanel.remove(_scrollPane1);
		_panel1.remove(_createWarningTextPane);
		_panel1.remove(_button1);
		_panel1.remove(_fillerPanel);
		_panel1.remove(_panel2);
		_fillerPanel.remove(_button2);
		_panel2.remove(_button3);
		_frame.remove(_namesPanel);
		_frame.remove(_panel1);
	}

	/**
	 * Removes all of the components for the Achievement Screen.
	 */
	public void removeAchievementsScreenComponents(){
		for(int x=0; x<_playerGameButtons.size(); x++){
			_scrollPanel.remove(_playerGameButtons.remove(x));
			x--;
		}
		for(int x=0; x<_achievementButtons.size(); x++){
			_achievementsPanel.remove(_achievementButtons.remove(x));
			x--;
		}
		_scrollPanel.remove(_fillerPanel);
		_playerStatsPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED, Color.GRAY, Color.WHITE));
		_createWarningTextPane.setBorder(null);
		_namesPanel.remove(_infoTextPane);
		_namesPanel.remove(_scrollPane1);
		_namesPanel.remove(_button1);
		_playerStatsPanel.remove(_nameTextPane);
		_playerStatsPanel.remove(_scrollPane2);
		_panel2.remove(_scrollPane3);
		_achievementDescPanel.remove(_iconLabel);
		_achievementDescPanel.remove(_iconNameTextPane);
		_achievementDescPanel.remove(_createWarningTextPane);
		_panel1.remove(_namesPanel);
		_panel1.remove(_playerStatsPanel);
		_panel2.remove(_achievementDescPanel);
		_frame.remove(_tabbedPane);
		_frame.remove(_button2);
	}

	/**
	 * Exits from the program.
	 */
	public void exitProgram(){
		_logic.exitProgram();
	}

	/**
	 * Sets the text pane to display the specified text.
	 * @param text = The text to display
	 */
	public void setCreateWarningTextPaneText(String text){
		_createWarningTextPane.setText(text);
	}

	/**
	 * Sets the text pane to display the specified text.
	 * @param text = The text to display
	 */
	public void setFindWarningTextPaneText(String text){
		_findWarningTextPane.setText(text);
	}

	public JFrame getFrame(){
		return _frame;
	}

	public LinkedList<JButton> getPlayerNameButtons(){
		return _playerNameButtons;
	}
	
	public LinkedList<JButton> getPlayerGameButtons(){
		return _playerGameButtons;
	}

	public JTextField getCreatePlayerTextField(){
		return _createPlayerTextField;
	}

	public JTextField getFindPlayerTextField(){
		return _findPlayerTextField;
	}
	
	public ImageIcon get00Icon(){
		return _00Icon;
	}
	
	public ImageIcon getAwesomeIcon(){
		return _awesomeIcon;
	}
	
	public ImageIcon getBigWinnerIcon(){
		return _bigWinnerIcon;
	}
	
	public ImageIcon getBruiserIcon(){
		return _bruiserIcon;
	}
	
	public ImageIcon getLoserIcon(){
		return _loserIcon;
	}
	
	public ImageIcon getQuestionIcon(){
		return _questionIcon;
	}
	
	public ImageIcon getRIPIcon(){
		return _ripIcon;
	}
	
	public ImageIcon getSharpshooterIcon(){
		return _sharpshooterIcon;
	}
	
	public ImageIcon getSupernovaIcon(){
		return _supernovaIcon;
	}
	
	public ImageIcon getTankIcon(){
		return _tankIcon;
	}
	
	public ImageIcon getVeteranIcon(){
		return _veteranIcon;
	}

	public JTextField getAttacksTextFieldText(){
		return _attacksTextField;
	}
	
	public JTextField getHitsTextFieldText(){
		return _hitsTextField;
	}
	
	public JTextField getPhysDmgDoneTextFieldText(){
		return _physDmgDoneTextField;
	}
	
	public JTextField getPhysDmgTakenTextFieldText(){
		return _physDmgTakenTextField;
	}
	
	public JTextField getNumSpellsCastTextFieldText(){
		return _numSpellsCastTextField;
	}
	
	public JTextField getSpellDmgDoneTextFieldText(){
		return _spellDmgDoneTextField;
	}
	
	public JTextField getSpellDmgTakenTextFieldText(){
		return _spellDmgTakenTextField;
	}
	
	public JTextField getKillsTextFieldText(){
		return _killsTextField;
	}
	
	public JTextField getAssistsTextFieldText(){
		return _assistsTextField;
	}
	
	public JTextField getDeathsTextFieldText(){
		return _deathsTextField;
	}
	
	public JTextField getTimePlayedTextFieldText(){
		return _timePlayedTextField;
	}
	
	public JTextField getWonTextFieldText(){
		return _wonTextField;
	}

	public String getSelectedComboBoxPlayerName(){
		return (String)_playerNamesComboBox.getSelectedItem();
	}

	public class TextVerifier extends PlainDocument{
		private static final long serialVersionUID = 1L;

		/**
		 * Checks to see if the entered text is a valid length.
		 * @param string = The entered text.
		 * @return
		 * boolean value
		 */
	    public boolean isValidLength(String string){
	    	if(string.length() > 9){
	    		return false;
	    	}
	    	else{
	    		return true;
	    	}
	    }

	    /**
	     * Checks to see if the entered text is numerical values only. No other character is allowed.
	     * @param string = The entered text.
	     * @return
	     * boolean value
	     */
	    public boolean isValidNumber(String string){
	    	for(int x=0; x<string.length(); x++){
	    		switch(string.charAt(x)){
	    			case '0':
	    			case '1':
	    			case '2':
	    			case '3':
	    			case '4':
	    			case '5':
	    			case '6':
	    			case '7':
	    			case '8':
	    			case '9':
	    				break;
	    			default:
	    				return false;    		
	    		}
	    	}
	    	return true;
	    }

	    /**
	     * Checks to see if the entered text is a valid number and if it is then it inserts it into the text field.
	     */
		public void insertString(int offset, String string, AttributeSet attSet) throws BadLocationException{
			//if the string is null
	        if(string == null) {
	          return;
	        }
	        String oldString = this.getText(0, this.getLength());
	        String newString = oldString.substring(0, offset) + string + oldString.substring(offset);
	        
	        //if the text is valid
	        if(this.isValidLength(newString) == true && this.isValidNumber(newString) == true){
	        	super.insertString(offset, string, attSet);
	        }
	    }
	}
}
