package achievementsystem;

/**
 * Represents a game played by a player. It stores all of that player's statistics.
 */
public class Game{
	
	private int _attacks=0, _hits=0, _physDmgDone=0, _physDmgTaken=0, _spellDmgDone=0, _spellDmgTaken=0, _kills=0, _assists=0, _deaths=0, _numSpellsCast=0, _win=0, _timePlayed=0;
	private String _playerName="";
	
	/**
	 * Creates a game for the specified player with the specified statistics.
	 * @param playerName = The player's name
	 * @param attacks = The number of attacks the player had
	 * @param hits = The number of hits the player had
	 * @param physDmgDone = The physical damage the player did
	 * @param physDmgTaken = The physical damage the player took
	 * @param spellDmgDone = The spell damage the player did
	 * @param spellDmgTaken = The spell damage the player took
	 * @param kills = The number of kills the player had
	 * @param assists = The number of assists the player had
	 * @param deaths = The number of deaths the player had
	 * @param numSpellsCast = The number of spells the player cast
	 * @param timePlayed = The total time the player was in the game
	 * @param win = Whether or not the game was won (0 = loss, else win)
	 */
	public Game(String playerName, int attacks, int hits, int physDmgDone, int physDmgTaken, int spellDmgDone, int spellDmgTaken, int kills, int assists, int deaths, 
				int numSpellsCast, int timePlayed, int win){
		_playerName = playerName;
		_attacks = attacks;
		_hits = hits;
		_physDmgDone = physDmgDone;
		_physDmgTaken = physDmgTaken;
		_spellDmgDone = spellDmgDone;
		_spellDmgTaken = spellDmgTaken;
		_kills = kills;
		_assists = assists;
		_deaths = deaths;
		_numSpellsCast = numSpellsCast;
		_timePlayed = timePlayed;
		_win = win;
	}
	
	public String getPlayerName(){
		return _playerName;
	}

	public Integer getAttacks() {
		return _attacks;
	}
	
	public Integer getHits() {
		return _hits;
	}
	
	public Integer getPhysDmgDone() {
		return _physDmgDone;
	}

	public Integer getPhysDmgTaken() {
		return _physDmgTaken;
	}
	
	public Integer getSpellDmgDone() {
		return _spellDmgDone;
	}
	
	public Integer getSpellDmgTaken() {
		return _spellDmgTaken;
	}
	
	public Integer getKills() {
		return _kills;
	}
	
	public Integer getAssists() {
		return _assists;
	}
	
	public Integer getDeaths() {
		return _deaths;
	}
	
	public Integer getNumSpellsCast() {
		return _numSpellsCast;
	}
	
	public Integer getWin() {
		return _win;
	}
	
	public Integer getTimePlayed() {
		return _timePlayed;
	}
}
