package achievementsystem;

import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import javax.swing.JOptionPane;

/**
 * Deals with the connection and sending of statements to the database.
 */
public class Database{
	
	private Connection _connection;

	/**
	 * Creates the object and tries to initialize a connection with the database. It will throw an exception and exit the program if it can't connect to the database.
	 */
	public Database(){
		//tries to make a connection to the database
		try{
			URL databaseURL = Logic.class.getResource("/database/GameDatabase.s3db");
			Class.forName("org.sqlite.JDBC").newInstance();
			_connection = DriverManager.getConnection("jdbc:sqlite:" + databaseURL.getPath());
		}
		catch(NullPointerException exception){
			exception.printStackTrace();
			JOptionPane.showMessageDialog(null, "You are missing database files on your computer. Reinstall the program.", "Failure", 0);
			System.exit(0);
		}
		catch(Exception exception){
			exception.printStackTrace();
			JOptionPane.showMessageDialog(null, "Error connecting to the database. \n" + exception.toString(), "Failure", 0);
			System.exit(0);
		}
	}

	/**
	 * Closes the connection to the database
	 */
	public void closeConnection(){
		try{
			_connection.close();
		}
		catch(SQLException exception){
			exception.printStackTrace();
		}
	}

	/**
	 * Returns a list of string of all the player names currently in the database.
	 * @return
	 * A list of strings.
	 */
	public LinkedList<String> getPlayerNames(){
		try{
			Statement statement = _connection.createStatement();
			ResultSet results = statement.executeQuery("SELECT NAME FROM PLAYERS");
			
			LinkedList<String> names = new LinkedList<String>();
			//adds the player name to a list
			while(results.next()){
				names.add(results.getString(1));
			}
			return names;
		}
		catch(SQLException exception){
			exception.printStackTrace();
		}
		
		return null;
	}

	/**
	 * Tries to find the specified player in the database and if successful returns the statistics for it in a player object.
	 * @param playerName = The name of the player
	 * @return
	 * The player that was searched for
	 */
	public Player getPlayer(String playerName){
		try{
			Statement statement = _connection.createStatement();
			ResultSet results = statement.executeQuery("SELECT * FROM PLAYERS WHERE NAME = '" + playerName.toLowerCase() + "'");
			
			//if there are no results
			if(results.next() == false){
				return null;
			}
			
			return new Player(results.getString(1), results.getInt(2), results.getInt(3), results.getInt(4), results.getInt(5), results.getInt(6), 
					results.getInt(7), results.getInt(8), results.getInt(9), results.getInt(10), results.getInt(11), results.getInt(12), 
					results.getInt(13), results.getInt(14));
		}
		catch(SQLException exception){
			exception.printStackTrace();
		}
		
		return null;
	}
	
	/**
	 * Searches the database for all games played by the specified player and returns them in a list.
	 * @param playerName = The player's name whose games you want found
	 * @return
	 * A list of games for the specified player
	 */
	public LinkedList<Game> getGamesForPlayer(String playerName){
		try{
			Statement statement = _connection.createStatement();
			ResultSet results = statement.executeQuery("SELECT * FROM GAMES WHERE PLAYERNAME = '" + playerName.toLowerCase() + "'");
			
			LinkedList<Game> games = new LinkedList<Game>();
			//adds each game to a list
			while(results.next()){
				games.add(new Game(results.getString(1), results.getInt(2), results.getInt(3), results.getInt(4), results.getInt(5), 
						results.getInt(6), results.getInt(7), results.getInt(8), results.getInt(9), results.getInt(10), 
						results.getInt(11), results.getInt(12), results.getInt(13)));
			}
			return games;
		}
		catch(SQLException exception){
			exception.printStackTrace();
		}
		
		return null;
	}

	/**
	 * Adds the specified game to the database for a player and the updates the player's statistics in the database.
	 * @param game = The game to be added for the player into the database.
	 */
	public void insertGame(Game game){
		Integer win = 0;
		//if the game was won
		if(game.getWin() > 0){
			win = 1;
		}
		
		try{
			Statement statement = _connection.createStatement();
			statement.execute("INSERT INTO GAMES VALUES('" + game.getPlayerName().toLowerCase() + "', " + game.getAttacks().toString() + 
					", " + game.getHits().toString() + ", " + game.getPhysDmgDone().toString() + ", " + game.getPhysDmgTaken().toString() + 
					", " + game.getSpellDmgDone().toString() + ", " + game.getSpellDmgTaken().toString() + ", " + game.getKills().toString() + 
					", " + game.getAssists().toString() + ", " + game.getDeaths().toString() + ", " + game.getNumSpellsCast().toString() + 
					", " + game.getTimePlayed().toString() + ", " + win.toString() + ")");
			
			this.updatePlayer(game);
		}
		catch(SQLException exception){
			exception.printStackTrace();
		}
	}
	
	/**
	 * Searches the database for the specified name and if it was not found, it inserts the specified name into the database with default statistics.
	 * @param playerName = The player name to be inserted.
	 * @return
	 * Whether or not it was successful
	 */
	public boolean insertPlayer(String playerName){
		boolean nameTaken = true;
		try{
			ResultSet result = _connection.createStatement().executeQuery("SELECT NAME FROM PLAYERS WHERE NAME = '" + playerName.toLowerCase() + "'");
			
			//if the name was not found
			if(result.next() == false){
				nameTaken = false;
			}
		}
		catch(SQLException exception){
			exception.printStackTrace();
		}
		
		//if the name was not found
		if(nameTaken == false){
			try{
				Statement statement = _connection.createStatement();
				statement.execute("INSERT INTO PLAYERS VALUES('" + playerName.toLowerCase() + "', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)");
				
				return true;
			}
			catch(SQLException exception){
				exception.printStackTrace();
			}
		}
		
		return false;
	}

	/**
	 * Updates the player's statistics with the specified game by adding them to the player's current statistics.
	 * @param game = The game to update the statistics with.
	 */
	private void updatePlayer(Game game){
		Player player = this.getPlayer(game.getPlayerName());
		
		int win=0, loss=0;
		//if the game as lost, increase the player's losses
		if(game.getWin() == 0){
			loss++;
		}
		//if the game was won, increase the player's wins
		else{
			win++;
		}
		
		try{
			Statement statement = _connection.createStatement();
			statement.execute("UPDATE PLAYERS SET ATTACKS = " + ((Integer)(player.getAttacks() + game.getAttacks())).toString() + 
					", HITS = " + ((Integer)(player.getHits() + game.getHits())).toString() + ", PHYSDMGDONE = " + ((Integer)(player.getPhysDmgDone() + game.getPhysDmgDone())).toString() + 
					", PHYSDMGTAKEN = " + ((Integer)(player.getPhysDmgTaken() + game.getPhysDmgTaken())).toString() + ", SPELLDMGDONE = " + ((Integer)(player.getSpellDmgDone() + game.getSpellDmgDone())).toString() + 
					", SPELLDMGTAKEN = " + ((Integer)(player.getSpellDmgTaken() + game.getSpellDmgTaken())).toString() + ", KILLS = " + ((Integer)(player.getKills() + game.getKills())).toString() + 
					", ASSISTS = " + ((Integer)(player.getAssists() + game.getAssists())).toString() + ", DEATHS = " + ((Integer)(player.getDeaths() + game.getDeaths())).toString() + 
					", NUMSPELLSCAST = " + ((Integer)(player.getNumSpellsCast() + game.getNumSpellsCast())).toString() + ", WINS = " + ((Integer)(player.getWins() + win)).toString() +
					", LOSSES = " + ((Integer)(player.getLosses() + loss)).toString() + ", TIMEPLAYED = " + ((Integer)(player.getTimePlayed() + game.getTimePlayed())).toString() +
					" WHERE NAME = '" + player.getName().toLowerCase() + "'");
		}
		catch(SQLException exception){
			exception.printStackTrace();
		}
	}

	/**
	 * Deletes all player's and games from the database.
	 */
	public void deleteAllFromDatabase(){
		try{
			_connection.createStatement().execute("DELETE FROM GAMES");
			_connection.createStatement().execute("DELETE FROM PLAYERS");
		}
		catch(SQLException exception){
			exception.printStackTrace();
		}
	}
}
