function main
%%%References:
%%%1. Chang-Xing Ma, George Casella, and Rongling Wu 
%%%   Functional Mapping of Quantitative Trait Loci Underlying 
%%%   the Character Process: A Theoretical Framework. 
%%%   Genetics (2002) 161(4) 1751-1762
%%%   http://www.genetics.org/cgi/reprint/161/4/1751
%%%2. Rongling Wu, Chang-Xing Ma, etc., George Casella
%%%   Quantitative trait loci for growth trajectories in Populus
%%%   Genetical Research, (2003), 81, pp 51 64.


   %%%%% a_Qq    b_Qq   r_Qq   a_qq    b_qq  r_qq   rho    sigma^2
   par=[19.9824 8.7768 0.4699 15.9507 7.5737 0.4836 0.7543 0.2260];
   N=100; %%sample size
   mrkdist=[0 20 20 20 20 20]; %%%marker distance
   mrkplace=cumsum(mrkdist);  %%%[0 20 40 60 80 100]
   qtlposition=50;
   time=1:7; %%%treat measured in time 1 to 7
   %%%%simulate N backcross marker and treat data
   [treat, mrk, mrkname]=SimulateData(N, mrkdist, qtlposition, par, time);
   
   res=[];
   parin=[19.9824 8.7768 0.4699 0.7543 0.2260]; %%%initial value
   for ii=1:(length(mrkplace)-1)%%% search for all marker intervals
      twomrks=mrk(:,[ii ii+1]); %%% current two markers in current inteval
      [solution0, LL0]=fminsearch('likelihoodnull',parin,[], treat); %%%search solution at NULL
      for cqtlposition=1:2:mrkdist(ii+1) %%%search qtl by step 2cM for current marker inteval
             qtlposition=cqtlposition+mrkplace(ii);
             cmM1Q=cqtlposition;
             cmQM2=mrkplace(ii+1)-qtlposition;
             theta=cmM1Q/(cmM1Q+cmQM2);
             prob=[1 1-theta theta 0]; %%%probability table for Qq at markers 1 1, 1 0, 0 1, 0 0;
             allprob=prob(4-((twomrks(:,1))*2+twomrks(:,2)))';
             whn=solution0;
             wh=[whn(1:3) whn(1:3) whn(4) whn(5)*0.8];
             [solution, LL]=fminsearch('likelihood',wh,[],treat,allprob);
             npar=EMiter(solution,treat,allprob);
             LL=likelihood(npar, treat, allprob);
             res=[res; [qtlposition 2*(LL0-LL) npar LL]];
      end
   end
   plot(res(:,1),res(:,2));
   save(['result'], 'res','solution0');


function npar=EMiter(par,y,prob)
npar=UpdatePar(par,y, prob);
while (sum(abs(npar-par)) > 10.e-4)
   par=npar;
   npar=UpdatePar(par,y, prob);
end

function [treat, mrk, mrkname]=SimulateData(N, mrkdist, qtlposition, par, time)
%%%generate data for Backcross only

%%generate markers
mrk=GenMarkerForBackcross(mrkdist, N);
mrkname=[];
for i=1:length(mrkdist)
    mrkname=[mrkname; 'marker' num2str(i)];
end

%%generate traits
aQq=par(1); bQq=par(2); rQq=par(3);
aqq=par(4); bqq=par(5); rqq=par(6);
sigma2=par(8); rho=par(7);
mu=[aQq./(1+bQq*exp(-rQq*time)); aqq./(1+bqq*exp(-rqq*time))];

lent=length(time);
for i=1:lent
  for j=1:lent
     SIGMA(i,j)=rho^abs(time(i)-time(j));
  end
end
SIGMA=SIGMA*sigma2;

mrkplace=cumsum(mrkdist);
idx=find(mrkplace>qtlposition);
qtlmrk1=idx(1)-1;qtlmrk2=idx(1);

theta=(qtlposition-mrkplace(qtlmrk1))/(mrkplace(qtlmrk2)-mrkplace(qtlmrk1));

prob=[1 1-theta theta 0];
allprob=prob(4-(mrk(:,qtlmrk1)*2+mrk(:,qtlmrk2)));
for i=1:N
   qtl(i)=(rand>allprob(i))+1;
   treat(i,:)=mvnrnd(mu(qtl(i),:), SIGMA, 1);
end

function mk=GenMarkerForBackcross(dist, N)
%%genarate N Backcross Markers from marker disttance (cM): dist.

if dist(1)~=0,
   cm=[0 dist]/100;
else
   cm=dist/100;
end   

n=length(cm);
rs=1/2*(exp(2*cm)-exp(-2*cm))./(exp(2*cm)+exp(-2*cm));

for j=1:N
   mk(j,1)=rand>0.5;
end   

for i=2:n
   for j=1:N
      if mk(j,i-1)==1,
         mk(j,i)=rand>rs(i);
      else
         mk(j,i)=rand<rs(i);
      end
   end   
end

