function newpar=UpdatePar(par,y, mrk)
%%%EM
%%%References:
%%%1. Chang-Xing Ma, George Casella, and Rongling Wu 
%%%   Functional Mapping of Quantitative Trait Loci Underlying 
%%%   the Character Process: A Theoretical Framework. 
%%%   Genetics (2002) 161(4) 1751-1762
%%%   http://www.genetics.org/cgi/reprint/161/4/1751
%%%2. Rongling Wu, Chang-Xing Ma, etc., George Casella
%%%   Quantitative trait loci for growth trajectories in Populus
%%%   Genetical Research, (2003), 81, pp 51 64.

a1=par(1);b1=par(2);c1=par(3); %%%for Qq
a0=par(4);b0=par(5);c0=par(6); %%%for qq
rho=par(7);s2=par(8);

[n,m]=size(y);

mu1=a1./(1+b1*exp(-c1*[1:m]));
mu0=a0./(1+b0*exp(-c0*[1:m]));
yy1=y-mu1(ones(n,1),:); yy0=y-mu0(ones(n,1),:);

st1=((1-rho^2)*yy1(:,m).^2+sum((yy1(:,1:(m-1))-rho*yy1(:,2:m)).^2,2));
st0=((1-rho^2)*yy0(:,m).^2+sum((yy0(:,1:(m-1))-rho*yy0(:,2:m)).^2,2));
term1=mrk.*exp(-st1/s2/(1-rho^2)/2);
term0=(1-mrk).*exp(-st0/s2/(1-rho^2)/2);
Q1=term1./(term1+term0); Q0=1-Q1; sQ1=sum(Q1); sQ0=sum(Q0);
dy=(y(:,1:(m-1))-rho*y(:,2:m));

up1=exp(-c1*[1:m]); up0=exp(-c0*[1:m]);
upt1=[1:m].*exp(-c1*[1:m]); upt0=[1:m].*exp(-c0*[1:m]);
dn1=1+b1*up1;       dn0=1+b0*up0;

%%%%%update a1
fcc1=1./dn1(1:(m-1))-rho./dn1(2:m);
tmp=sum(fcc1.^2)+(1-rho^2)/dn1(m)^2;
newa1=(dy*fcc1'+(1-rho^2)*y(:,m)/dn1(m))'*Q1/sQ1/tmp;

%%%%%update a0
fcc0=1./dn0(1:(m-1))-rho./dn0(2:m);
tmp=sum(fcc0.^2)+(1-rho^2)/dn0(m)^2;
newa0=(dy*fcc0'+(1-rho^2)*y(:,m)/dn0(m))'*Q0/sQ0/tmp;

%%%%%update b1
scc1=up1(1:(m-1))./dn1(1:(m-1)).^2-rho*up1(2:m)./dn1(2:m).^2;
tmp=a1*fcc1*scc1'+(1-rho^2)*a1*up1(m)/dn1(m)^3;
newb1=(sQ1*tmp)/((dy*scc1'+(1-rho^2)*y(:,m)*up1(m)/dn1(m)^2)'*Q1)*b1;

%%%%%update b0
scc0=up0(1:(m-1))./dn0(1:(m-1)).^2-rho*up0(2:m)./dn0(2:m).^2;
tmp=a0*fcc0*scc0'+(1-rho^2)*a0*up0(m)/dn0(m)^3;
newb0=(sQ0*tmp)/((dy*scc0'+(1-rho^2)*y(:,m)*up0(m)/dn0(m)^2)'*Q0)*b0;

%%%%%update c1
scct1=upt1(1:(m-1))./dn1(1:(m-1)).^2-rho*upt1(2:m)./dn1(2:m).^2;
tmp=a1*fcc1*scct1'+(1-rho^2)*a1*upt1(m)/dn1(m)^3*m;
newc1=(dy*scct1'+(1-rho^2)*m*y(:,m)*upt1(m)/dn1(m)^2)'*Q1/sQ1/tmp*c1;

%%%%%update c0
scct0=upt0(1:(m-1))./dn0(1:(m-1)).^2-rho*upt0(2:m)./dn0(2:m).^2;
tmp=a0*fcc0*scct0'+(1-rho^2)*a0*upt0(m)/dn0(m)^3;
newc0=(dy*scct0'+(1-rho^2)*y(:,m)*upt0(m)/dn0(m)^2)'*Q0/sQ0/tmp*c0;

%%%%%update sigma^2
news2=(st1'*Q1+st0'*Q0)/(1-rho^2)/m/n;

%%%%%update rho
A=(Q1'*sum(yy1(:,1:(m-1)).*yy1(:,2:m),2)+Q0'*sum(yy0(:,1:(m-1)).*yy0(:,2:m),2))/s2;
B=(Q1'*(sum(yy1(:,2:m).*yy1(:,2:m),2)-yy1(:,m).^2)+Q0'*(sum(yy0(:,2:m).*yy0(:,2:m),2)-yy0(:,m).^2))/s2;
C=(Q1'*st1+Q0'*st0)/s2;
newrho=sqrt(-((n*(m-1)-B)*rho^3+(B+C-(m-1)*n)*rho-A)/A);

newpar=[newa1 newb1 newc1 newa0 newb0 newc0 newrho news2];
%newpar=[a1 b1 c1 a0 b0 newc0 rho s2];
