%iDetect Demo on three cluster data

% Generate three clusters
N = 100; % Number of samples per cluster
cluster_1 = [randn(1,N)+3;randn(1,N)-3];
cluster_2 = [randn(1,N)-3;randn(1,N)-3];
cluster_3 = [randn(1,N);randn(1,N)+3];
DATA = [cluster_1,cluster_2,cluster_3]; %pool them together

% Plot clusters
figure;
plot(DATA(1,:), DATA(2,:), 'o');

% Add Noise
rand_features = 1000; % Number of irrelevant features
raw_DATA = DATA;
DATA = [raw_DATA; randn(rand_features, size(raw_DATA, 2))];

% Parameter and options
Para.it = 20;               % Maximum iteration
Para.distance = 'block';    % Distance metric. 'euclidean' or 'block'
Para.sigma = 1;             % Kernel width
Para.lambda = 2;            % Regularization parameter

% run iDetect
[Objective, Weight] = iDetect(DATA);

% Plot learned feature weight
figure; stem(Weight, 'o'); set(gca,'xscale','log');
title('Weights');
xlabel('Feature Index');
ylabel('Feature Weight');
