/***********************************************************************
ESPRIT-Forest: Parallel Clustering of Massive Amplicon Sequence Data in Subquadratic Time 
by: Yunpeng Cai, Yijun Sun, Wei Zheng, Jin Yao and Yujie Yang  (C) 2016
Please kindly cite [Y.Cai et.al PLOS Comp. Biol. 2016]

THE LICENSED WORK IS PROVIDED UNDER THE TERMS OF THE ADAPTIVE PUBLIC LICENSE ("LICENSE") AS FIRST COMPLETED BY: _Yunpeng Cai, Yijun Sun, Wei Zheng, Jin Yao, Yujie Yang_ [Insert the name of the Initial Contributor here]. ANY USE, PUBLIC DISPLAY, PUBLIC PERFORMANCE, REPRODUCTION OR DISTRIBUTION OF, OR PREPARATION OF DERIVATIVE WORKS BASED ON, THE LICENSED WORK CONSTITUTES RECIPIENT'S ACCEPTANCE OF THIS LICENSE AND ITS TERMS, WHETHER OR NOT SUCH RECIPIENT READS THE TERMS OF THE LICENSE. "LICENSED WORK" AND "RECIPIENT" ARE DEFINED IN THE LICENSE. A COPY OF THE LICENSE IS LOCATED IN THE TEXT FILE ENTITLED "LICENSE.TXT" ACCOMPANYING THE CONTENTS OF THIS FILE. IF A COPY OF THE LICENSE DOES NOT ACCOMPANY THIS FILE, A COPY OF THE LICENSE MAY ALSO BE OBTAINED AT THE FOLLOWING WEB SITE: http://www.acsu.buffalo.edu/~yijunsun/lab/ESPRIT-Forest.html [Insert Initial Contributor's Designated Web Site here]

Software distributed under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the specific language governing rights and limitations under the License.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

void* Malloc(size_t size)
{
	void *ptr;
	if ((ptr=malloc(size))==NULL)
		{
			fprintf(stderr,"Out of Memory Size requested!\n");
			exit(0);
		}
	return ptr;
}

void AddSuff(char *output,char *input, const char *suff)
{
	char *pch,*qch;
	int i;
	qch=input;
	while (*qch=='.' || *qch=='/' || *qch=='\\')
	    qch++;
	qch=strchr(qch,'.');

	qch=strchr(input,'.');
	if (qch ==NULL)
		{
			sprintf(output,"%s%s",input,suff);
			return;
		}
	do	
	{
		pch=qch;
		qch=strchr(pch+1,'.');
	}while(qch !=NULL);
	
	for (i=0;input+i < pch;i++)
		output[i]=input[i];
	output[i]=0;
	strcat(output,suff);
	strcat(output,pch);
}

void RepExt(char *output, const char *ext)
{
	char *pch,*qch;
	int i;
	qch=output;
	while (*qch=='.' || *qch=='/' || *qch=='\\')
	    qch++;
	qch=strchr(qch,'.');
	if (qch ==NULL)
		{
			strcat(output,".");
			strcat(output,ext);
			return;
		}
	do	
	{
		pch=qch;
		qch=strchr(pch+1,'.');
	}while(qch !=NULL);
	
	pch++;
	strcpy(pch,ext);
}
