#ifndef PROBCLUSTER_H
#define PROBCLUSTER_H
#include "PBPTree.h"
#include <set>
#include <stdio.h>
using namespace std;

typedef struct{
	int NNseq; //my nearest neighbour;
	int NNseq2;
	float NNdist;
	float NNdist2;
}SwapRec;

typedef struct{
	int parID;
	int linklevel;
}TreeRec;

typedef struct{
	Tree *Node;
	int ID;
	int NumSeqs;
	set<unsigned int> NNlist; //indice of CRs who register me as NN
	set<unsigned int> Seqlist; //sequence IDs
	int fromid1;
	int fromid2;
	int clsid;
	float distErr;
	int tagscan;
	bool is_outlier;
}ClustRec;

typedef struct{
	int id1;
	int id2;
	float dist;
	int clstag;
}PairRec;

class TreeClust{
	 Tree * root;
	 float levelmin;
	 float levelinc;
	 float levelmax;
		
	 public:
		int NumSeq;
	 	TreeClust(float lmin,float lmax);
	 	~TreeClust() { if (root) delete root;};
	 	
	 	Tree *AddSeq(int uid);
		Tree *AddSeqAt(int uid, Tree *par);
		Tree *AddSeqFrom(int uid, int branch, Tree *par);
		Tree* CreateBranch(int uid,float levelup);
		void RemoveNode(Tree *node);
		void EstimateNN(int uid, ClustRec *clRec, SwapRec *tRec);
		void FindNN(int uid,SwapRec *tRec,float leveldn);
		void ListLeaves(FILE *fp);
		void ListBottom(vector<Tree *> &tvec);
		void ListChildrenAt(float level, vector<Tree *> &tvec);
		Tree* FindInsertParent(int uid);
		Tree *Condense(Tree *node,int uid);
		
};

#endif
