#ifndef ProbModel_H
#define ProbModel_H
#include <fstream>
#include "util.h"
using namespace std;

#define Num_RNAType 4
#define MIN_PROB 1e-6


class ProbChar{
	public:
		ProbChar();
		ProbChar(float arr[]);
		
		float &operator [] (const int & idx) {return probvect[idx];};
		ProbChar &operator =(ProbChar &pc) 
		   {
		   	for (int i=0;i<=Num_RNAType+2; i++) probvect[i]=pc[i];
		   	return pc;
		  };
		float Dist(ProbChar &pc);
		void Assign(float arr[]);
		bool isGap() {return (probvect[0]+probvect[Num_RNAType+2]) >=1.0-EPS;};
		bool isUnknown() {return probvect[Num_RNAType+1] >=1.0-EPS;};
		float ProbEnd() {return probvect[Num_RNAType+2];};
		float ProbGap() {return probvect[0]+probvect[Num_RNAType+2];};
		
		float Norm() { 
			float res=0;
			for (int i=0;i<=Num_RNAType+2;i++) res+=probvect[i];
			return res;
		}
		
		void operator +=(ProbChar &pc)
			{
		   	for (int i=0;i<=Num_RNAType+2; i++) probvect[i]+=pc[i];
			}; 
		void operator *=(float w)
			{
		   	for (int i=0;i<=Num_RNAType+2; i++) probvect[i]*=w;
			}; 
		
		char ToChar();	
		char ToWildcard();
	private:
		float probvect[Num_RNAType+3];

};


class ProbString{
	
	public:
	
	ProbString(){len=0;seq=NULL;};
	ProbString(char *strseq);

	~ProbString();

	void Alloc(int len);	
	void Clear();
	void FromString(char *strseq);
	
	ProbChar & operator [] (const int & idx) {return seq[idx];};
	ProbString & operator =(ProbString &ps);
	void operator +=(ProbString &ps); 
	void operator *=(float w); 
	void Add(char *str, float wt);
	
	int Len() {return len;};
	
	float AveDist(ProbString &str);
	float AveDist(char *str);
		
	char* ToString();
	char* ToWildcard();
	bool Rectify(float thres);
	
	private:
		ProbChar *seq;
		int len;
};



fstream & operator <<(fstream &out, ProbChar &chr);
fstream & operator <<(fstream &out, ProbString &str);
fstream &operator >>(fstream &in,ProbChar &chr);
fstream &operator >>(fstream &in,ProbString &str);


extern ProbChar gapChar;
extern ProbChar EndgapChar;

#endif
