#ifndef PROBTREE_H
#define PROBTREE_H
#include <fstream>
#include <vector>
#include <string>
using namespace std;


//#define MAX_CHR 100

#define MIN_THRES 1e-4

class Tree{
		int Num_Children;
		float thres;
		Tree *Child;
		Tree *TailChild;
		Tree *Brother;
		Tree *Parent;

	public:
		int UID;

		Tree();
		~Tree();
		Tree(int uid);
		void AddChild(Tree * subtree);
		void DeleteChild(Tree *subtree);
		void SetThres(float th) {thres=th;};
		float GetThres() {return thres;};
		int NumChildren(){return Num_Children;};
		bool IsLeaf(){ return (Child==NULL);};
		bool BottomLevel() {if (Child==NULL) return true; else return Child->IsLeaf();};
		float FindSpanChild(int UID,Tree *&subtree);
				
		Tree *FirstChild() {return Child;};
		Tree *GetParent() {return Parent;};
		Tree *GetBrother() { return Brother;};
		Tree *FindChild(int uid);
		void ListChildren(vector<Tree *> & tvec);
		void ListChildrenAt(float thres, vector<Tree *> & tvec);
		void ListBottom(vector<Tree*> &tvec);
		void ListLeaf(vector<Tree *> & tvec);
		
};
#endif
