#!/bin/bash


if [ $# -lt 2 ]; then
echo "usage: ./esf-mp.sh numcpu <input.fas> [output]"
exit 0
fi

export OMP_NUM_THREADS=$1

if expr index $2 "." >/dev/null; then
prefix=`echo $2|sed -r 's/(.*)(\..*)/\1/g'`
suffix=`echo $2|sed -r 's/(.*)(\..*)/\2/g'`
else
prefix=$2
suffix=""
fi
#echo $prefix
#echo $suffix

if expr index $0 "/" >/dev/null; then
codepath=`echo $0|sed -r 's/(.*\/)(.*)/\1/g'`
else
codepath=""
fi

procfile=$prefix'_Clean'$suffix
frqfile=$prefix'_Clean.frq'
mapfile=$prefix'_Clean.map'
#echo $procfile

if ${codepath}preproc $2 ; then

if [ $# -ge 3 ]; then
${codepath}ESFclust -o $3 -f $frqfile $procfile
perl ${codepath}invmap.pl $3'.Clusters' $mapfile $3'.org.Clusters'
else 
${codepath}ESFclust -f $frqfile $procfile
perl ${codepath}invmap.pl $prefix'_Clean.Clusters' $mapfile $prefix'.org.Clusters'
fi

fi

