function [Weight, ConvergenceRate] = Online_IMRelief_2_1(patterns, targets, Para4IRelief,reference,it)

%IM_Relief_2: Relief using EM algorithm for both binary and multiclass problems.
%NOTE: IM_Relief_2 is different from IM_Relief_1 in the margin difinition.
%Online_IMRelief_2(refer to margin definition)_2(refer to online version)                
%--------------------------------------------------------------------------
%INPUT:
%     patterns:  training data: Each column is an observation
%     targets:   class label = {1,2,...C}
%     T: # of iteration
%   distance: 'Euclidean' or 'Block'
%OUTPUT:
%    Weight: weight of features
%--------------------------------------------------------------------------
%University of Florida, by Yijun Sun
%Octber 15/17/25, 2005
%==========================================================================
N_EachBlock= 1;
T =length(targets)*it;%length(targets)*5;%maximum iteration
a = [1];%[0.8,0.9,1];
ConvergenceRate = zeros(T+1,length(a));

distance = Para4IRelief.distance;
kernel = Para4IRelief.kernel;
sigma = Para4IRelief.sigma;
%----------------------------------
Uc          = unique(targets);
if min(Uc)==-1
    targets = targets/2+1.5; %transform targets into {1,2}
end

N_patterns = length(targets);% # of patterns
dim = size(patterns,1); % Data dimenionality

for n=1:length(Uc)
    temp = find(targets==n); 
    index{n} =temp;
    N(n) = length(temp);
end

%initilization
History = zeros(dim,T+1);
History(:,1)= 1/sqrt(dim)*ones(dim,1);
Weight = 1/sqrt(dim)*ones(dim,1);
Rand_Index = randperm(N_patterns);
% -------------------------------------------------------------------------
for t=1:T
    %disp(['>>>Processing ' num2str(t) ' / ' num2str(T)])
    if rem(t,N_patterns)==0,m=N_patterns;else;m = rem(t,N_patterns);end
    Select_Index = Rand_Index(m);
    Select_Patterns = patterns(:,Select_Index);
    Select_Targets = targets(Select_Index);
    
    NM = zeros(dim,N_EachBlock); 
    NH = zeros(dim,N_EachBlock); 
    Pro_NoT_Outlier=[];
    
    for i = 1:N_EachBlock,
        Prob_dif = 0;
        Prob_same = 0;
        
        index_SameClass = index{Select_Targets(i)};
        index_DiffClass =[];
        for c = 1:length(Uc)
            if c~=Select_Targets(i)
                temp =index{c};
                index_DiffClass = [index_DiffClass;temp(:)];
            end
        end
        
        switch lower(distance)
            case{'euclidean'}
                Temp_SameClass  = (patterns(:,index_SameClass) - Select_Patterns(:,i)*ones(1,length(index_SameClass))).^2;
                Temp_DiffClass  = (patterns(:,index_DiffClass) - Select_Patterns(:,i)*ones(1,length(index_DiffClass))).^2;
            case{'block'}
                Temp_SameClass  = abs(patterns(:,index_SameClass) - Select_Patterns(:,i)*ones(1,length(index_SameClass)));
                Temp_DiffClass  = abs(patterns(:,index_DiffClass) - Select_Patterns(:,i)*ones(1,length(index_DiffClass)));
        end
        
        if t==1
            dist_SameClass    = sum(Temp_SameClass,1)/sqrt(dim);
            dist_DiffClass    = sum(Temp_DiffClass,1)/sqrt(dim);
        else
            dist_SameClass    = (Weight(:)')*Temp_SameClass;
            dist_DiffClass    = (Weight(:)')*Temp_DiffClass;
        end
        temp_index_SameClass = find(dist_SameClass==0); 
        temp_index_DiffClass = find(dist_DiffClass==0); 
        
        prob_SameClass = exp(-dist_SameClass/sigma);prob_SameClass(temp_index_SameClass) = 0; 
        if sum(prob_SameClass)~=0;prob_S = prob_SameClass/sum(prob_SameClass);else;prob_S=0;end
        prob_DiffClass = exp(-dist_DiffClass/sigma);prob_DiffClass(temp_index_DiffClass) = 0; 
        prob_D = prob_DiffClass/sum(prob_DiffClass);
        
        if N(Select_Targets(i))>1
            Pro_NoT_Outlier(i) = (sum(prob_SameClass)/length(index_SameClass))/(sum(prob_SameClass)/length(index_SameClass)+sum(prob_DiffClass)/length(index_DiffClass));
            NH(:,i) = Temp_SameClass*prob_S(:)*Pro_NoT_Outlier(i);  
            NM(:,i) = Temp_DiffClass*prob_D(:)*Pro_NoT_Outlier(i); 
        else
            NM(:,i) = Temp_DiffClass*prob_D(:); 
        end
    end               %end of process of each block
    
    %compute intermediate results
    Pi = sum(NM-NH,2); 
    if t==1
        Intermediate_result = Pi;
        in = find(Pi<0); Pi(in)=0;
        Weight = Pi/norm(Pi);
        LearningRate(t) = 1/(c*t);
        Epsilon(t) = 2*a-1;
    else
        LearningRate(t) = 1/(a*t);
        Intermediate_result = Intermediate_result+LearningRate(t)*(Pi-Intermediate_result);
        
        %compute weight
        Nu = Intermediate_result;
        in = find(Nu<0); Nu(in)=0;
        Weight = Nu/norm(Nu);
        Epsilon(t) = ((t+1)*a-1)/(t*a);
    end
    History(:,t+1) = Weight;
    Difference = norm(Weight-History(:,t));
    Theta(t) = Difference;
end

if ~isempty(reference)
    reference(:,1) = reference(:,1)/norm(reference(:,1));
    Progress = sqrt(sum((History - reference(:,1)*ones(1,size(History,2))).^2,1));
    figure(2);
    plot(Progress(2:end),'-');
    hold on
    xlabel('Number of Iterations')
    ylabel('Difference');
    title('Difference from target weight');
    axis tight
    grid on
    boldify1
    ConvergenceRate=Progress(:);
else
    ConvergenceRate =[];
end

if ~isempty(reference)
    figure(1);
    plot(Weight/max(Weight),':*');
    hold on;plot(reference(:,1)/max(reference(:,1)),'r-o');
    hold on;plot(reference(:,2)/max(reference(:,2)),'k-.s');
    legend('Online','I-Relief','Relief',0)
    xlabel('Number of Features')
    ylabel('Scores');axis tight
    boldify2;
    grid on
    
    figure(4)
    plot(LearningRate,'-');
    xlabel('Number of Iterations')
    ylabel('Learning Rates');
    grid on;title('Learning Rates(\eta)')
    boldify2
    
    for t=1:length(Epsilon)
        w(t)=prod(Epsilon(t:end));   
    end
    figure;plot(w/sum(w))
end
return
