function [Weight, ConvergenceRate]= Online_IMRelief_1_1(patterns, targets, Para4IRelief,reference,it)

%Online_IM_Relief_1_1: Online version of Relief using EM algorithm for both binary and multiclass problems..Here
%we use the margin difinition that is also used in Relief-F. 
%Online_IMRelief_1(refer to margin definition)_1(refer to online version)                
%INPUT:
%     patterns:  training data: Each column is an observation
%     targets:   class label = {1,2,...C}
%     Para4IRelief: parameter for I-Relief
%     reference:  Reference vector learned in bacth learning. if there is no reference, then reference =[];
%        it: the number of iteration, recommended it = 2-5
%     
%OUTPUT:
%    Weight: weight of features
%    ConvergenceRate: Convergence Rate
%--------------------------------------------------------------------------
%University of Florida, by Yijun Sun
%Octber 15/17/25, Nov 3/25, Dec 5, 2005
%--------------------------------------------------------------------------
%==========================================================================
N_EachBlock= 1;
T =length(targets)*it;     %maximum iteration
A = [1];                   %[0.8,0.9,1];
ConvergenceRate = zeros(T+1,length(A));

for aa = 1:length(A)
    a=A(aa);
    distance = Para4IRelief.distance;
    kernel = Para4IRelief.kernel;
    sigma = Para4IRelief.sigma;
    %----------------------------------
    Uc          = unique(targets);
    if min(Uc)==-1
        targets = targets/2+1.5; %transform targets into {1,2}
    end
    
    N_patterns = length(targets);  % # of patterns
    dim = size(patterns,1);        % Data dimenionality
    
    for n=1:length(Uc)
        temp = find(targets==n); 
        index{n} =temp;
        N(n) = length(temp);
    end
    Prioi = N/sum(N);
    
    %initilization
    History = zeros(dim,T+1);
    History(:,1)= 1/sqrt(dim)*ones(dim,1);
    Weight = 1/sqrt(dim)*ones(dim,1);
    Rand_Index = [1:N_patterns];          %randperm(N_patterns);
    
    % -------------------------------------------------------------------------
    for t=1:T
        %disp(['>>>Processing ' num2str(t) ' / ' num2str(T)]);
        if rem(t,N_patterns)==0,m=N_patterns;else;m = rem(t,N_patterns);end
        Select_Index = Rand_Index(m);
        %     Rand_Index = randperm(N_patterns);
        %     Select_Index = Rand_Index(1);
        %     
        Select_Patterns = patterns(:,Select_Index);
        Select_Targets = targets(Select_Index);
        
        NM = zeros(dim,N_EachBlock); 
        NH = zeros(dim,N_EachBlock); 
        Pro_NoT_Outlier=[];
        
        for i = 1:N_EachBlock,
            Prob_dif = 0;
            Prob_same = 0;
            
            for c = 1:length(Uc)
                switch lower(distance)
                    case {'euclidean'}
                        Temp            = (patterns(:,index{c}) - Select_Patterns(:,i)*ones(1,N(c))).^2;
                    case {'block'}
                        Temp            = abs(patterns(:,index{c}) - Select_Patterns(:,i)*ones(1,N(c)));
                end
                
                dist    = (Weight(:)')*Temp;
                temp_index = find(dist==0);
                
                prob = exp(-dist/sigma);prob(temp_index) = 0; 
                if sum(prob)~=0;prob_1 = prob/sum(prob);else;prob_1=0;end
                
                if Select_Targets(i)==c; 
                    NH(:,i) = Temp*prob_1(:);
                    Prob_same = sum(prob)/N(c);
                end
                if Select_Targets(i)~=c; 
                    NM(:,i) = NM(:,i)+ Temp*prob_1(:);%*Prioi(c)/(1-Prioi(targets(i)));%keyboard
                    Prob_dif = Prob_dif+sum(prob)/N(c);
                end 
            end
            
            if N(Select_Targets(i))>1
                Pro_NoT_Outlier(i) = Prob_same/(Prob_same+Prob_dif);
                NH(:,i) = NH(:,i)*Pro_NoT_Outlier(i);
                NM(:,i) = NM(:,i)*Pro_NoT_Outlier(i);
            else
                NM(:,i) = NM(:,i); %for the case where there is only one sample in Class c.
            end      
        end %end of process of each block
        
        %compute intermediate results
        NM = NM/(length(Uc)-1);
        Pi = sum(NM-NH,2); 
        if t==1
            Intermediate_result = Pi;
            in = find(Pi<0); Pi(in)=0;
            Weight = Pi/norm(Pi);
            LearningRate(t) = 1/(c*t);
            Epsilon(t) = 2*a-1;
        else
            LearningRate(t) = 1/(a*t);
            Intermediate_result = Intermediate_result+LearningRate(t)*(Pi-Intermediate_result);
            
            %compute weight
            Nu = Intermediate_result;
            in = find(Nu<0); Nu(in)=0;
            Weight = Nu/norm(Nu);
            Epsilon(t) = ((t+1)*a-1)/(t*a);
        end
        History(:,t+1) = Weight;
        Difference = norm(Weight-History(:,t));
        Theta(t) = Difference;
    end
    
    if ~isempty(reference)
        reference(:,1) = reference(:,1)/norm(reference(:,1));
        Progress = sqrt(sum((History - reference(:,1)*ones(1,size(History,2))).^2,1));
        figure(2);
        plot(Progress(2:end),'-');
        hold on
        xlabel('Number of Iterations')
        ylabel('Difference');
        title('Difference from target weight');
        axis tight
        grid on
        boldify1
        ConvergenceRate(:,aa)=Progress(:);
    else
        ConvergenceRate =[];
    end
end

if ~isempty(reference)
    figure(1);
    plot(Weight/max(Weight),':*');
    hold on;plot(reference(:,1)/max(reference(:,1)),'r-o');
    hold on;plot(reference(:,2)/max(reference(:,2)),'k-.s');
    legend('Online','I-Relief','Relief',0)
    xlabel('Number of Features')
    ylabel('Scores');axis tight
    boldify1;
    
    figure(4)
    plot(LearningRate,'-');
    xlabel('Number of Iterations')
    ylabel('Learning Rates');
    grid on;title('Learning Rates(\eta)')
    boldify1
    
    for t=1:length(Epsilon)
        w(t)=prod(Epsilon(t:end));   
    end
    figure;plot(w/sum(w))
end

return



