function Main_AdaptiveRelief(dataset,No_RandomFeature,Percentage)

%FUNCTION MAIN: main function for Adaptive Relief
%========================================================
%
%Yijun Sun, University of Florida
%LUD:Oct 15/Dec 5, 2005
%========================================================
close all
AddSomePath; %add some pathes
% eval(['load C:\Work\AdaptiveRelief\Result\Result_' dataset '_' num2str(No_RandomFeature) '_' num2str(Percentage) '.mat'])
% KN = Para4Relief.KNNpara; % # of the nearest neighbors
KN = 10;
%---------------------------------------------------------
FinalResult_Weight = zeros(20,5);
Stat_IRelief = zeros(21,2,20);
Stat_Relief = zeros(21,2,20);
Stat_Simba = zeros(21,2,20);
OptimumFeature_IRelief = zeros(20,2);
OptimumFeature_Relief =zeros(20,2);

for No=1:20
    disp(['>>>> Processing ' num2str(No) '/' num2str(20)]);
    %load data
    eval(['load ' dataset '_train_data_' num2str(No) '.asc'])
    eval(['load ' dataset '_train_labels_' num2str(No) '.asc'])
    eval(['load ' dataset '_test_data_' num2str(No) '.asc'])
    eval(['load ' dataset '_test_labels_' num2str(No) '.asc'])
    
    switch dataset
        case {'flare-solar'}
            eval(['patterns = flare_solar_train_data_' num2str(No) ';']);
            patterns = patterns'; % Each column is an observation
            eval(['targets = flare_solar_train_labels_' num2str(No) ';']);
            eval(['test_patterns = flare_solar_test_data_' num2str(No) ';']);
            test_patterns = test_patterns';
            eval(['test_targets = flare_solar_test_labels_' num2str(No) ';']);
            
        otherwise      
            eval(['patterns =' dataset '_train_data_' num2str(No) ';']);
            patterns = patterns'; % Each column is a pattern.
            eval(['targets = ' dataset '_train_labels_' num2str(No) ';']);
            eval(['test_patterns =' dataset '_test_data_' num2str(No) ';']);
            test_patterns = test_patterns';
            eval(['test_targets =' dataset '_test_labels_' num2str(No) ';']);
    end
    
    %clear all data
    eval(['clear ' dataset '_train_data_' num2str(No) ';'])
    eval(['clear ' dataset '_train_labels_' num2str(No) ';']);
    eval(['clear ' dataset '_test_data_' num2str(No) ';']);
    eval(['clear ' dataset '_test_labels_' num2str(No) ';']);
    %-----------------------------------------------------------
    N = length(targets);             % Number of patterns
    Original_dim = size(patterns,1); % Number of original features
    patterns = [patterns; randn(No_RandomFeature,N)]; %Add some irrelevant features
    test_patterns = [test_patterns; randn(No_RandomFeature,size(test_patterns,2))]; % Add some irrelevant features
    dim = size(patterns,1); % Data dimenionality
    
    %---------------------------------------------------------------
    %Preprocess the data: 'unif' tranform each feature into [0, 1]
    [patterns, test_patterns] = preprocessing(patterns, test_patterns,'unif');
    %---------------------------------------------------------------
    %Add label noise
    index0 = find(targets==-1);
    index1 = find(targets==1);
    
    temp = randperm(length(index0));
    Num2change = round(length(index0)*Percentage/100);
    targets(index0(temp(1:Num2change))) = 1;
    
    temp = randperm(length(index1));
    Num2change = round(length(index1)*Percentage/100);
    targets(index1(temp(1:Num2change))) = -1;
    %---------------------------------------------------------------------
    %Parameter for Iterative Relief/Relief
    it = 10;                  % the number of iterations in I-RELIEF
    distance ='euclidean';    %'block';
    kernel = 'exp';           %'1/d';
    Para4IRelief.it = it;
    Para4IRelief.distance = distance;
    Para4IRelief.kernel = kernel;
    Para4IRelief.Outlier =1;
    %--------------------------------
    Para4Relief.distance = distance;

    %------------------------------------------------------------------

    if No==1
        given=1; 
        %if given==1; the parameter is given.
        if given==1
            %KN=1;
            %Para4Relief.KNNpara = KN;% # of the nearest neighbors in KNN
            Para4IRelief.sigma= 0.2;
            Para4Relief.KN= 10; % # of the nearest neighbors in Relief

        else
            % Cross-validation: only operated on the first dataset for computational reason.
            Error=[];
            K =[1:2:20];
            for k=1:length(K)
                Error(k) = CrossValidation(patterns,targets,'KNN_1',K(k),10,'fold'); 
            end
            [dum,I] = min(Error);
            KN = K(I(1)); % # of the nearest neighbors in KNN
            Para4Relief.KNNpara = KN;

            %Find sigma in Iterative AdaBoost
            Error =[];
            Sigma =[0.1,0.15,0.2,0.3,0.4,0.5,0.8,1,2];
            F=10;
            for k=1:length(Sigma)
                Para4IRelief.sigma = Sigma(k);
                Error(k) =FindSigma_IRelief(patterns,targets,KN,F,Para4IRelief);
            end
            [dum,I] = min(Error);
            Para4IRelief.sigma= Sigma(I(1)) % # of the nearest neighbors in KNN

            %Find K in Relief
            Error =[];
            K = [1:3:20];
            F=10;
            for k=1:length(K)
                Para4Relief.KN = K(k);
                Error(k) =FindK_Relief(patterns,targets,KN,F,Para4Relief);
            end
            [dum,I] = min(Error);
            Para4Relief.KN= K(I(1)); % # of the nearest neighbors in Relief
        end
    end
    
    %--------------------------------------------------------------------------
    %Relief Algorithm/need modification
    weights_relief = Original_Relief(patterns, targets, Para4Relief);
    
    keyboard
    %----------------------------------------------------------------------
    %I-M-Relief.
    weights = IMRelief_1(patterns, targets, Para4IRelief);
    %weights = New_I_Relief(patterns, targets, Para4IRelief);
    %[weights, ConvergenceRate]= Online_IMRelief_1_1(patterns, targets, Para4IRelief,[],it);
    
    %Simba
    extra_param.max_iter = 5;
    extra_param.start_points=5;
    weights_simba_lin = simba(patterns', targets,extra_param);
    figure(1);plot(weights/max(weights),'-o')
    hold on;
    plot(weights_relief/max(weights_relief),'-ko');
    plot(weights_simba_lin/max(weights_simba_lin),'-r*')
    legend('I-Relief','Relief','Simba');
    xlabel('Number of features')
    ylabel('Feature score')
    grid on;hold off; drawnow;

    
    %======================================================================
    %Test stage (I): Nearest Neighbor Algorithm
    switch lower(distance)
        case{'euclidean'}
            patterns_Irelief = diag(sqrt(weights))*patterns; 
            test_patterns_Irelief = diag(sqrt(weights))*test_patterns;
            
            patterns_relief = diag(sqrt(weights_relief))*patterns; 
            test_patterns_relief = diag(sqrt(weights_relief))*test_patterns;
           
        case{'block'}
            patterns_Irelief = diag((weights))*patterns; 
            test_patterns_Irelief = diag((weights))*test_patterns;
            
            patterns_relief = diag(sqrt(weights_relief))*patterns; 
            test_patterns_relief = diag(sqrt(weights_relief))*test_patterns;
    end
    result = Nearest_Neighbor(patterns(1:Original_dim,:), targets, test_patterns(1:Original_dim,:), KN, 'knn');
    Test_Error_Clean= length(find(result(:)~=test_targets(:)))/length(result);
    disp(['>>>> The testing error of clean data is ' num2str(Test_Error_Clean*100) '%.']);

    result = Nearest_Neighbor(patterns, targets, test_patterns, KN, 'knn');
    Test_Error_before= length(find(result(:)~=test_targets(:)))/length(result);
    disp(['>>>> The testing error of before feature selection is ' num2str(Test_Error_before*100) '%.']);

    result = Nearest_Neighbor(patterns_relief, targets, test_patterns_relief, KN, 'knn');
    Test_Error_relief= length(find(result(:)~=test_targets(:)))/length(result);
    disp(['>>>> The testing error of RELIEF is ' num2str(Test_Error_relief*100) '%.']);
    
    result = Nearest_Neighbor(patterns_Irelief, targets, test_patterns_Irelief, KN, 'knn');
    Test_Error_IRelief= length(find(result(:)~=test_targets(:)))/length(result);
    disp(['>>>> The testing error of A-RELIEF is ' num2str(Test_Error_IRelief*100) '%.']);
    
    patterns_simba = sqrt(diag(weights_simba_lin))*patterns; 
    test_patterns_simba = sqrt(diag(weights_simba_lin))*test_patterns;
    result = Nearest_Neighbor(patterns_simba, targets, test_patterns_simba,  KN, 'knn');
    Test_Error_Simba = length(find(result(:)~=test_targets(:)))/length(result);
    disp(['>>>> The testing error of Simba is ' num2str(Test_Error_Simba*100) '%.'])
    
    FinalResult_Weight(No,:) = [Test_Error_Clean, Test_Error_before,Test_Error_relief,Test_Error_IRelief,Test_Error_Simba];
    
    %------------------------------------------------------------
    %statistical of selected features
    weights = weights/max(weights);                     %for I-Relief
    weights_relief =weights_relief/max(weights_relief); %for Relief

    [Pd,Pf] = FeatureSelectStat(weights,No_RandomFeature);
    Stat_IRelief(:,:,No) = [Pd,Pf];
    N_NonZero_IRelief = sum(weights>0.02);
    
    [Pd,Pf] = FeatureSelectStat(weights_relief,No_RandomFeature);
    Stat_Relief(:,:,No) = [Pd,Pf];
    N_NonZero_Relief = sum(weights_relief>0.02);
    
    [Pd,Pf] = FeatureSelectStat(weights_simba_lin,No_RandomFeature);
    Stat_Simba(:,:,No) = [Pd,Pf];
    N_NonZero_Simba = sum(weights_simba_lin>0.02);
    %-------------------------------------------------------------
    
    %Testing errors of different number of features
    Test_Error_relief=[];Test_Error_IRelief=[];Test_Error_Simba=[];
    [dum,Index_Relief] = sort(weights_relief);
    [dum,Index_I_Relief] = sort(weights);
    [dum,Index_Simba] = sort(weights_simba_lin);
    if dim-No_RandomFeature>10
        Step =round(linspace(1,dim-No_RandomFeature,10));%[1:1:20,25:5:dim-No_RandomFeature];%
    else
        Step =[1:dim-No_RandomFeature];
    end
    if No==1;FinalResult_Threshold = zeros(length(Step),3,20);end

    Find_OptimumFeatureNumber_IRelief = [];
    Find_OptimumFeatureNumber_Relief = [];
    for f=1:length(Step)  %dim-No_RandomFeature
        index = Index_I_Relief(end-Step(f)+1:end);
        if length(index)>N_NonZero_IRelief;
            Test_Error_IRelief(f) = Test_Error_IRelief(f-1);
            Find_OptimumFeatureNumber_IRelief(f) =Find_OptimumFeatureNumber_IRelief(f-1);
        else
            Find_OptimumFeatureNumber_IRelief(f) = CrossValidation(patterns(index,:),targets,'KNN_1',KN,10,'fold'); 
            result = Nearest_Neighbor(patterns(index,:), targets, test_patterns(index,:), KN, 'knn');
            Test_Error_IRelief(f)= length(find(result(:)~=test_targets(:)))/length(result);
        end
        
        index = Index_Relief(end-Step(f)+1:end);
        if length(index)>N_NonZero_Relief;
            Test_Error_relief(f) = Test_Error_relief(f-1);
            Find_OptimumFeatureNumber_Relief(f) =Find_OptimumFeatureNumber_Relief(f-1);
        else
            Find_OptimumFeatureNumber_Relief(f) = CrossValidation(patterns(index,:),targets,'KNN_1',KN,10,'fold'); 
            result = Nearest_Neighbor(patterns(index,:), targets, test_patterns(index,:), KN, 'knn');
            Test_Error_relief(f)= length(find(result(:)~=test_targets(:)))/length(result);
        end
        
        index = Index_Simba(end-Step(f)+1:end);
        if length(index)>N_NonZero_Simba;
            Test_Error_Simba(f) = Test_Error_Simba(f-1);
             %Find_OptimumFeatureNumber_Simba(f) =Find_OptimumFeatureNumber_Simba(f-1);
        else
            %Find_OptimumFeatureNumber_Relief(f) = CrossValidation(patterns(index,:),targets,'KNN_1',KN,10,'fold'); 
            result = Nearest_Neighbor(patterns(index,:), targets, test_patterns(index,:), KN, 'knn');
            Test_Error_Simba(f)= length(find(result(:)~=test_targets(:)))/length(result);
        end
    end
    figure(2);plot(Step,Test_Error_relief,'-o')
    hold on
    plot(Step,Test_Error_Simba,'*-k')
    hold on
    plot(Step,Test_Error_IRelief,'-or')
    legend('Relief','Simba','I-Relief');hold off;drawnow;
    
    [dum,I] = min(Find_OptimumFeatureNumber_IRelief);
    OptimumFeature_IRelief(No,:)= [I(1),Test_Error_IRelief(I(1))];
    
    [dum,I] = min(Find_OptimumFeatureNumber_Relief);
    OptimumFeature_Relief(No,:)= [I(1),Test_Error_relief(I(1))];
    FinalResult_Threshold(:,:,No) = [Test_Error_relief(:),Test_Error_IRelief(:),Test_Error_Simba(:)];
end
Stat.IRelief = mean(Stat_IRelief,3);
Stat.Relief = mean(Stat_Relief,3);
Stat.Simba = mean(Stat_Simba,3);

%------------------------------------------------------------------
Result_threshold = sum(FinalResult_Threshold,3)/20;
figure(1);plot(Step,Result_threshold(:,1),'-v','MarkerSize',12)
hold on
plot(Step,Result_threshold(:,3),'*-k','MarkerSize',12);hold on;
plot(Step,Result_threshold(:,2),'-or','MarkerSize',12)
legend('Relief','Simba','I-Relief',0);
hold off;grid on;
axis tight
xlabel('Number of Features')
ylabel('Classification Error')
title([dataset '(' num2str(No_RandomFeature) '/' num2str(Percentage) ')'])
boldify1
%---------------------------------------------------------------------

%compute the statistics between RELIEF and I-RELIEF
X = OptimumFeature_IRelief(:,2);
Y = OptimumFeature_Relief(:,2);
[H,P,CI,STATS] = ttest2(X,Y);  
disp(['>>>> The significant level = ' num2str(P) '.'])


%eval(['save C:\Work\AdaptiveRelief\Result\Comparison\Comparison_' dataset '_' num2str(No_RandomFeature) '_' num2str(Percentage) '.mat OptimumFeature_IRelief OptimumFeature_Relief FinalResult_Threshold Para4Relief Para4IRelief Step'])
%eval(['save C:\Work\AdaptiveRelief\Result\Comparison\Result_' dataset '_' num2str(No_RandomFeature) '_' num2str(Percentage) '.mat FinalResult_Weight FinalResult_Threshold Para4Relief Para4IRelief Stat Step'])

return















