function Weight = IMRelief_1(patterns, targets, Para4IRelief)

%IM_Relief_1: Relief using EM algorithm for both binary and multiclass problems..
%Here we use the margin difinition that is also used in Relief-F
%NOTE: IM_Relief_1 is different from IM_Relief_2 in the margin difinition.
% when used for binary problem, IM_RELIEF_1 is eqivalent to IM_RELIEF_2
%--------------------------------------------------------------------------
%INPUT:
%     patterns:  training data: Each column is an observation
%     targets:   class label = {1,2,...C}
%OUTPUT:
%    Weight: weight of features
%--------------------------------------------------------------------------
%by Yijun Sun @University of Florida
%Oct. 15/17/25, Nov 3, 2005/June 2, 2006
%==========================================================================
T = Para4IRelief.it;              % maximum iteration
distance = Para4IRelief.distance; % distance metric
kernel = Para4IRelief.kernel;     % kernel function used to compute probability
sigma = Para4IRelief.sigma;       % kernel width
Outlier = Para4IRelief.Outlier;
%----------------------------------

Uc          = unique(targets);
if min(Uc)==-1
    targets = targets/2+1.5; %transform targets into {1,2}
end

if min(Uc)~=1 | max(Uc)~=length(Uc);
    error('Targets should run from 1 to C !')
end

N_patterns = length(targets);% # of patterns
dim = size(patterns,1);      % Data dimenionality

for n=1:length(Uc)
    temp = find(targets==n);
    index{n} =temp;
    N(n) = length(temp);
end
Prioi = N/sum(N);

History = zeros(dim,T+1);
Weight = 1/sqrt(dim)*ones(dim,1);
History(:,1)= Weight;
% -------------------------------------------------------------------------

Difference =1;
t=0;
Theta =[];
while Difference>0.01 & t<=T
    t=t+1;
    NM = zeros(dim,N_patterns);
    NH = zeros(dim,N_patterns);

    for i = 1:N_patterns,
        Prob_dif = 0;
        Prob_same = 0;

        for c = 1:length(Uc)
            switch lower(distance)
                case {'euclidean'}
                    Temp            = (patterns(:,index{c}) - patterns(:,i)*ones(1,N(c))).^2;
                case {'block'}
                    Temp            = abs(patterns(:,index{c}) - patterns(:,i)*ones(1,N(c)));
            end

            if t==1
                dist    = sum(Temp,1)/sqrt(dim);
            else
                dist    = (Weight(:)')*Temp;
            end
            temp_index = find(dist==0);

            switch lower(kernel) %calculate probabilities
                case{'exp'}
                    prob = exp(-dist/sigma);prob(temp_index) = 0;
                    if sum(prob)~=0;prob_1 = prob/sum(prob);else;prob_1=0;end
                case{'1/d'}
                    switch lower(distance)
                        case {'euclidean'}
                            prob = (1./(dist)).^(1/0.5); %1./sqrt(dist);%
                        case {'block'}
                            prob = 1./(dist);
                    end
                    prob(temp_index) = 0;
                    if sum(prob)~=0;prob_1 = prob/sum(prob);else;prob_1=0;end
            end

            if targets(i)==c;
                NH(:,i) = Temp*prob_1(:);
                Prob_same = sum(prob)/N(c);
            end
            if targets(i)~=c;
                NM(:,i) = NM(:,i)+ Temp*prob_1(:)*Prioi(c)/(1-Prioi(targets(i)));
                Prob_dif = Prob_dif+sum(prob)/N(c);
            end
        end
        if N(targets(i))>1
            if Outlier ==1
                Pro_NoT_Outlier(i) = Prob_same/(Prob_same+Prob_dif);
                NH(:,i) = NH(:,i)*Pro_NoT_Outlier(i);
                NM(:,i) = NM(:,i)*Pro_NoT_Outlier(i);
            else
                NH(:,i) = NH(:,i);
                NM(:,i) = NM(:,i);
            end
        else
            NM(:,i) = NM(:,i); %for the case where there is only one sample in Class c.
        end
    end

    %NM = NM/(length(Uc)-1);
    C = sum(NM-NH,2);
    C_original = C;
    %Objective_1(t) = (Weight(:)')*C;
    in = find(C<0); C(in)=0;
    Weight = C/norm(C);
    %Objective(t) = (Weight(:)')*C_original;

    Difference = norm(Weight-History(:,t));
    Theta(t) = Difference;
    History(:,t+1) = Weight;
end

%monitoring the feature weights
figure(9);plot(Theta,'-o')
title('Theta');
xlabel('Number of Iteration');
ylabel('Difference')
grid on
% 
% figure(11);plot(History(:,end-1),'o-r');hold on;
% plot(Weight,'*-b');hold off;
% title('Updating of Weights');
% legend('end-1','end')
%keyboard
return
%End of the code



